/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

%{

/************************************************************************/
/*									*/
/*		xrscplex.l						*/
/*									*/
/*	Lexical definitions for cross reference scanner for C++ 	*/
/*									*/
/************************************************************************/




#undef YYLMAX
#define YYLMAX		20480


static	void		scan_id();
static	void		handle_num();
static	void		handle_string();
static	void		fix_operator();
static	void		set_file_line();
static	void		include_file();
static	void		begin_csu();
static	void		end_csu();

static	Integer 	clevel = 0;
static	Integer 	cstack[128];
static	Integer 	bracect = 0;
static	String		cur_macro = NULL;



%}

%a 10240
%o 10240
%p 10240
%e 10240
%k 10240
%n 10240

%START PREP PRED PREX PREI PREL CSU CSU1 BASE BODY EXPR CEXPR FCTD ARRY ARGS IGN


WHITE	([\ \t\f])+
WHITE0	([\ \t\f])*
WHITEA	([\ \n\t\f])+
WHITEA0 ([\ \n\t\f])*

INT	([0-9]+)
HEXINT	(0x[0-9a-f]+)

STRING	(\"([^\n"\\]|(\\.)|(\\\n))*\")

ID	([a-zA-Z_$~][a-zA-Z_$0-9]*)
FILE	([-0-9/.a-zA-Z_$+]+)

CHAR0	(\'.\')
CHAR1	(\'\\.\')
CHAR2	(\'\\([0-7]{1,3})\')
CHAR	({CHAR0}|{CHAR1}|{CHAR2})

FLT0	([0-9]+\.[0-9]*)
EXP	([Ee][-+]?[0-9]+)
FLT1	({INT}{EXP})
FLT2	({FLT0}{EXP})
FLT	({FLT0}|{FLT1}|{FLT2})

CMMT	("/*"((("*"+[^*/])|[^*])*)("*"+"/"))
CCCMMT	("//".*)

DLOP	("++"|"--")
EQOP	("+="|"-="|"*="|"/="|"%="|">>="|"<<="|"&="|"^="|"|=")
SINGLE	([\[\](){};,=*:~])

OPPAIR	("<>"|"<="|">="|"++"|"--"|"<<"|">>"|"&&"|"||"|"=="|"!="|"()"|"->"|"[]"|{EQOP})
OP	({OPPAIR}|[-,*/%+<>&^|=~!])
OPNAME0 ("operator"{WHITE0}{OP})
OPNAME1 ("operator"{WHITE}{ID})
OPNAME	({OPNAME0}|{OPNAME1})

APTY	("("/{WHITE0}"*"{WHITE0}{ID}{WHITE0}")")

FCLASS	("friend"{WHITE}"class"/{WHITE}{ID}{WHITE0}";")

PURE	("="{WHITE0}0/";")


%%

^"#"{WHITE}/[1-9]               { begin_csu(); BEGIN PREL; }
^"#"{WHITE0}                    { begin_csu(); BEGIN PREX; }
<PREX>"define"{WHITE}           { BEGIN PRED; }
<PREX>"undef"{WHITE}            { BEGIN PRED; }
<PREX>"include"{WHITE}          { BEGIN PREI; }
<PREX>"line"{WHITE}             { BEGIN PREL; }
<PREX>{ID}			{ BEGIN PREP; }
<PREX>. 			;
<PRED>{ID}			{ XRSC_out_decl(cur_filename,yylineno,
						   yytext,"",0,SCLASS_MACRO,NULL);
				  cur_macro = SALLOC(yytext);
				  BEGIN PREP;
				}
<PREP>{ID}			{ XRSC_out_reference(yytext,cur_filename,
							yylineno,cur_macro);
				}
<PREP>{STRING}			;
<PREP>{INT}			;
<PREP>{HEXINT}			;
<PREP>{FLT}			;
<PREP>{WHITE}			;
<PREP>{EQOP}			;
<PREP>{DLOP}			;
<PREP>"..."                     ;
<PREP>{OPNAME}			;
<PREP>{CHAR}			;
<PREP>{OPPAIR}			;
<PREP,PREX,PRED,PREL,PREI>"\\\n" ;
<PREP,PREX,PRED,PREL,PREI>{WHITE0}"\n"/{WHITEA0}  {
				   if (cur_macro != NULL) {
				      SFREE(cur_macro);
				      cur_macro = NULL;
				    };
				   end_csu();
				}
<PREP>. 			;
<PREL>{INT}{WHITE}\"{FILE}\"    { BEGIN PREP;
				  set_file_line(yytext);
				}
<PREL>. 			{ BEGIN PREP; }
<PREI>\<{FILE}\>.*\n		{ include_file(yytext); end_csu(); }
<PREI>\"{FILE}\".*\n            { include_file(yytext); end_csu(); }
<PREI>{OPPAIR}			{ BEGIN PREP; }
<PREI>. 			{ BEGIN PREP; }

<IGN>^"#"{WHITE0}"line"{WHITE}/.*[\n]  { BEGIN PREL; }
<IGN>^"#"{WHITE}/[1-9].*[\n]    { BEGIN PREL; }
<IGN>.*[\n]			;
<IGN>.				;

<CSU>{ID}			{ yylval.string = SALLOC(yytext); BEGIN CSU1; return LX_ID; }
<CSU,CSU1>":"                   { BEGIN BASE; return ':'; }
<CSU,CSU1>"{"                   { BEGIN BODY; return '{'; }
<CSU,CSU1>{WHITEA}		;
<CSU,CSU1>.			{ end_csu();
				  if (clevel != 0) yyless(1);
				  return ';';
				}

<BASE>"virtual"                 { return LX_VIRTUAL; }
<BASE>"private"                 { return LX_PRIVATE; }
<BASE>"public"                  { return LX_PUBLIC; }
<BASE>"protected"               { return LX_PROTECTED; }
<BASE>{ID}			{ yylval.string = SALLOC(yytext); return LX_ID; }
<BASE>","                       { return ','; }
<BASE>"{"                       { BEGIN BODY; return '{'; }
<BASE>{WHITEA}			;
<BASE>. 			{ end_csu();
				  if (clevel != 0) yyless(1);
				  return ';';
				}

<BODY>"private"{WHITEA0}":"     { return LX_PRIVATE; }
<BODY>"public"{WHITEA0}":"      { return LX_PUBLIC; }
<BODY>"protected"{WHITEA0}":"   { return LX_PROTECTED; }
<BODY>"::"                      { return LX_COLCOL; }
<BODY>"="                       { BEGIN EXPR; bracect = 0; return '='; }
<BODY>":"                       { BEGIN CEXPR; return ':'; }
<BODY>"["                       { BEGIN ARRY; bracect = 0; return '['; }
<BODY>"}"                       { end_csu(); return '}'; }
<BODY>[;,*&)]			{ return yytext[0]; }
<BODY>"{"                       { BEGIN FCTD; bracect = 0; return '{'; }
<BODY>"("                       { BEGIN ARGS; bracect = 0; return '('; }
<BODY>{PURE}			{ return LX_PURE; }
<BODY>"static"                  { return LX_STATIC; }
<BODY>"typedef"                 { return LX_TYPEDEF; }
<BODY>"extern"                  { return LX_EXTERN; }
<BODY>"const"                   { return LX_CONST; }
<BODY>"volatile"                { return LX_VOLATILE; }
<BODY>"inline"                  { return LX_INLINE; }
<BODY>"virtual"                 { return LX_VIRTUAL; }
<BODY>"friend"                  { return LX_FRIEND; }
<BODY>"enum"                    { return LX_ENUM; }
<BODY>{OPNAME}			{ fix_operator(); yylval.string = SALLOC(yytext); return LX_ID; }
<BODY>{ID}			{ yylval.string = SALLOC(yytext); return LX_ID; }
<BODY>{WHITEA}			;
<BODY>{CMMT}			;
<BODY>{CCCMMT}			;
<BODY>{APTY}			{ return LX_APAREN; }
<BODY>{FCLASS}			{ return LX_FCLASS; }
<BODY>. 			;

<EXPR>";"                       { BEGIN BODY; return ';'; }
<EXPR>"{"                       { ++bracect; }
<EXPR>"}"                       { if (bracect-- <= 0) { BEGIN 0; return '}'; } }
<EXPR>{WHITEA}			;
<EXPR>. 			;

<CEXPR>";"                      { BEGIN BODY; return ';'; }
<CEXPR>"{"                      { BEGIN FCTD; bracect = 0; return '{'; }
<CEXPR>{WHITEA} 		;
<CEXPR>.			;

<ARRY>";"                       { BEGIN BODY; return ';'; }
<ARRY>"["                       { ++bracect; }
<ARRY>"]"                       { if (bracect-- <= 0) { BEGIN BODY; return ']'; } }
<ARRY>{WHITEA}			;
<ARRY>. 			;

<FCTD>"{"                       { ++bracect; }
<FCTD>"}"                       { if (bracect-- <= 0) { BEGIN BODY; return '}'; } }
<FCTD>{WHITEA}			;
<FCTD>. 			;

<ARGS>"("                       { ++bracect; }
<ARGS>")"                       { if (bracect-- <= 0) { BEGIN BODY; return ')'; } }
<ARGS>{WHITEA}			;
<ARGS>. 			;

"class"                         { begin_csu(); return LX_CLASS; }
"struct"                        { begin_csu(); return LX_STRUCT; }
"union"                         { begin_csu(); return LX_UNION; }
{STRING}			;
{CHAR}				;
{ID}				;
{INT}				;
{HEXINT}			;
{FLT}				;
{OPNAME}			;
{WHITEA}			;
{CMMT}				;
{CCCMMT}			;
.				;


%%


static void
scan_id()
{
   Integer i;

   XRSC_out_reference(yytext,cur_filename,yylineno,cur_macro);
};




static void
handle_num()
{
   if (USE_NUMBERS && STRNEQ(yytext,"0") && STRNEQ(yytext,"1")) {
      XRSC_out_reference(yytext,cur_filename,yylineno,cur_macro);
    };
};





static void
handle_string()
{
   if (USE_STRINGS) {
      XRSC_out_reference(yytext,cur_filename,yylineno,cur_macro);
    };
};




static void
fix_operator()
{
   Character buf[1024];
   String s;

   s = &yytext[8];
   while (isspace(*s)) ++s;

   sprintf(buf,"operator%c%s",SPACE_CHARACTER,s);
   strcpy(yytext,buf);
};





static void
set_file_line(buf)
   String buf;
{
   Integer line;
   String file,s;

   line = atol(buf);
   file = index(buf,'"');
   if (file != NULL && line != 0) {
      ++file;
      s = index(file,'"');
      if (s != NULL) {
	 *s = 0;
	 XRSC_set_file(file,line-1);
       };
    };
};





static void
include_file(name)
   String name;
{
   String s;
   Boolean gbl;

   gbl = (name[0] == '<');
   ++name;
   if (gbl) s = index(name,'>');
   else s = index(name,'"');

   *s = 0;

   XRSC_push_file(name,gbl);
};





static void
begin_csu()
{
   cstack[clevel++] = (int) yybgin;
   BEGIN CSU;
};



static void
end_csu()
{
   if (clevel > 0) yybgin = (struct yysvf *) cstack[--clevel];
   else BEGIN 0;
};






/* end of xrscplex.l */
