/************************************************************************/
/*									*/
/*		xrscmain.c						*/
/*									*/
/*	Main program for C cross referencing scanning			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xrsc_local.h"




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


	Boolean 	XRSC__interact;
	Boolean 	XRSC__cplusplus;
	Boolean 	XRSC__use_cpp;
	String		XRSC__scanfile;
	String		XRSC__include[32];
	Integer 	XRSC__num_include;
	String		XRSC__comp_flags;
	Integer 	XRSC__level;
	Boolean 	XRSC__scan_all;

static	Sequence	scanned;
static	Sequence	found;
static	Sequence	ignored;
static	String		curfile;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		find_file_name();





/************************************************************************/
/*									*/
/*	XRSC_init -- system initialization				*/
/*									*/
/************************************************************************/


void
XRSC_init()
{
   XRSC_decl_init();
   XRSC_out_init();
   XRSC_expr_init();
};





/************************************************************************/
/*									*/
/*	main -- main program						*/
/*									*/
/************************************************************************/


main(argc,argv)
   Integer argc;
   String argv[];
{
   Integer fct,i,ln,j;
   FILE * fp;
   Character nbf[1024];
   String name;
   Character cmd[10240];
   String s;

   XRSC_init();
   XRSC__num_include = 0;
   XRSC__interact = TRUE;
   XRSC__cplusplus = FALSE;
   XRSC__scanfile = NULL;
   XRSC__use_cpp = TRUE;
   XRSC__level = 0;
   XRSC__scan_all = FALSE;
   name = "<stdin>";
   scanned = NULL;
   found = NULL;
   ignored = NULL;
   XRSC__comp_flags = NULL;

   fct = 0;
   for (i = 1; i < argc; ++i) {
      if (argv[i][0] == '-') {
	 switch (argv[i][1]) {
	    case 'I' :
	       XRSC__include[XRSC__num_include++] = &argv[i][2];
	       break;
	    case 'S' :
	       XRSC__scanfile = &argv[i][2];
	       fp = fopen(XRSC__scanfile,"r");
	       if (fp != NULL) {
		  while (fgets(nbf,1024,fp) != NULL) {
		     ln = strlen(nbf);
		     nbf[ln-1] = 0;
		     scanned = CONS(SALLOC(nbf),scanned);
		   };
		  fclose(fp);
		};
	       break;
	    case 'F' :
	       XRSC__comp_flags = &argv[i][2];
	       break;
	    case 'N' :
	       name = &argv[i][2];
	       break;
	    case 'b' :
	       XRSC__interact = FALSE;
	       break;
	    case 'C' :
	       XRSC__cplusplus = TRUE;
	       break;
	    case 'p' :
	       XRSC__use_cpp = FALSE;
	       break;
	    case 'l' :
	       XRSC__level = 1;
	       break;
	    case 'a' :
	       XRSC__scan_all = 1;
	       break;
	    case 0 :
	       ++fct;
	       curfile = name;
	       XRSC_parse(NULL,name,stdin);
	       break;
	    default :
	       fprintf(stderr,"XRSC+ Illegal option \"%s\"\n",argv[i]);
	       break;
	  };
       }
      else if (!XRSC__use_cpp) {
	 ++fct;
	 curfile = argv[i];
	 XRSC_parse(argv[i],argv[i]);
       }
      else {
	 ++fct;

	 /* do CPP scanning for argv[i] **********/

	 if (XRSC__cplusplus) {
	    s = getenv("CC_COMMAND");
	    if (s == NULL) s = "CC";
	  }
	 else s = "cc";
	 sprintf(cmd,"%s -E",s);

	 if (XRSC__comp_flags != NULL) {
	    strcat(cmd," ");
	    strcat(cmd,XRSC__comp_flags);
	  };

	 for (j = 0; j < XRSC__num_include; ++j) {
	    strcat(cmd," -I");
	    strcat(cmd,XRSC__include[j]);
	  };

	 strcat(cmd," ");
	 strcat(cmd,argv[i]);
	 fp = popen(cmd,"r");
	 curfile = argv[i];
	 XRSC_parse(NULL,argv[i],fp);
	 pclose(fp);
       };
    };

   exit(0);
};





/************************************************************************/
/*									*/
/*	XRSC_find_file -- find file given name				*/
/*	XRSC_find_file_line -- find file given name for #line		*/
/*	find_file_name -- get real file name				*/
/*									*/
/************************************************************************/


Boolean
XRSC_find_file(file,glbl,prev,buf)
   String file;
   Boolean glbl;
   String prev;
   String buf;
{
   Sequence l;
   String s;

   find_file_name(file,glbl,prev,buf);

   forin (s,String,l,scanned) {
      if (STREQL(buf,s)) {
	 if (STREQL(buf,curfile)) return FALSE;
	 return TRUE;
       };
    };

   scanned = CONS(SALLOC(buf),scanned);

   return FALSE;
};





Boolean
XRSC_find_file_line(file)
   String file;
{
   Sequence l;
   String s;
   Character buf[1024];
   Boolean fg;

   forin (s,String,l,found) {
      if (STREQL(file,s)) return FALSE;
    };

   forin (s,String,l,ignored) {
      if (STREQL(file,s)) return TRUE;
    };

   fg = XRSC_find_file(file,TRUE,NULL,buf);

   XRSC_out_header(file);

   if (fg) ignored = CONS(SALLOC(file),ignored);
   else found = CONS(SALLOC(file),found);

   return fg;
};





static void
find_file_name(file,glbl,prev,buf)
   String file;
   Boolean glbl;
   String prev;
   String buf;
{
   String s;
   Integer i;

   if (file[0] == '/') {
      strcpy(buf,file);
      return;
    };

   if (!glbl) {
      strcpy(buf,prev);
      s = rindex(buf,'/');
      if (s != NULL) {
	 ++s;
	 *s = 0;
       }
      else buf[0] = 0;
      strcat(buf,file);
      if (access(buf,0) >= 0) return;
    };

   for (i = 0; i < XRSC__num_include; ++i) {
      strcpy(buf,XRSC__include[i]);
      strcat(buf,"/");
      strcat(buf,file);
      if (access(buf,0) >= 0) return;
    };

   if (XRSC__cplusplus) {
      strcpy(buf,"/usr/include/CC/");
      strcat(buf,file);
      if (access(buf,0) >= 0) return;
      strcpy(buf,"/cs/include/CC/");
      strcat(buf,file);
      if (access(buf,0) >= 0) return;
    };

   strcpy(buf,"/usr/include/");
   strcat(buf,file);
   if (access(buf,0) >= 0) return;

   strcpy(buf,file);
};





/* end of xrscmain.c */


