/************************************************************************/
/*									*/
/*		xrsc_local.h						*/
/*									*/
/*	Local include file for cross reference module			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include <ctype.h>
#include <datatypes.h>
#include <sequence.h>
#include "xref_common.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define CPP_COMMAND	"/lib/cpp"

#define USE_NUMBERS	0
#define USE_STRINGS	0



/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef enum _XRSC_SCLASS {
   SCLASS_STATIC,
   SCLASS_EXTERN,
   SCLASS_AUTO,
   SCLASS_REGISTER,
   SCLASS_TYPEDEF,
   SCLASS_EXTDEF,
   SCLASS_PARAM,
   SCLASS_FIELD,
   SCLASS_EFUNCTION,
   SCLASS_SFUNCTION,
   SCLASS_STRUCTID,
   SCLASS_UNIONID,
   SCLASS_ENUMID,
   SCLASS_CONST,
   SCLASS_MACRO,
   SCLASS_FRIEND,
   SCLASS_CLASSID,
} XRSC_SCLASS;




typedef enum _XRSC_SCOPE_TYPE {
   SCOPE_EXTERN,
   SCOPE_ARGS,
   SCOPE_INTERN,
   SCOPE_SUE,
   SCOPE_NONE,
} XRSC_SCOPE_TYPE;




typedef enum _XRSC_FINISH_DECL {
   FINISH_SEMI,
   FINISH_COMMA,
   FINISH_EQ,
   FINISH_BAD,
} XRSC_FINISH;





/************************************************************************/
/*									*/
/*	Global storage							*/
/*									*/
/************************************************************************/


extern	Boolean 	XRSC__interact;
extern	Boolean 	XRSC__cplusplus;
extern	Boolean 	XRSC__use_cpp;
extern	String		XRSC__scanfile;
extern	String		XRSC__include[];
extern	Integer 	XRSC__num_include;
extern	String		XRSC__comp_flags;
extern	Integer 	XRSC__level;
extern	Boolean 	XRSC__scan_all;

extern	Boolean 	XRSC__ignore;





/************************************************************************/
/*									*/
/*	Module Local Entries						*/
/*									*/
/************************************************************************/


					/* xrscmain.c			*/
extern	void		XRSC_init();
extern	Boolean 	XRSC_find_file();
extern	Boolean 	XRSC_find_file_line();



					/* xrscsyn.y/xrsclex.l		*/
extern	void		XRSC_parse();
extern	void		XRSC_set_file();
extern	void		XRSC_push_file();



					/* xrscdecl.c			*/
extern	void		XRSC_decl_init();
extern	void		XRSC_decl_begin();
extern	void		XRSC_decl_end();
extern	void		XRSC_decl_statements();
extern	void		XRSC_decl_scope_use();
extern	void		XRSC_decl_finish();
extern	String		XRSC_decl_inq_name();
extern	void		XRSC_decl_scan_id();
extern	void		XRSC_decl_set_sclass();
extern	void		XRSC_decl_set_fclass();
extern	void		XRSC_decl_scan_type();
extern	void		XRSC_decl_scan_invalid();
extern	void		XRSC_decl_function_body();
extern	void		XRSC_decl_set_type();
extern	void		XRSC_decl_add_type();
extern	void		XRSC_decl_set_id();
extern	void		XRSC_decl_sue_id();
extern	void		XRSC_decl_enum();



					/* xrscout.c			*/
extern	void		XRSC_out_init();
extern	void		XRSC_out_header();
extern	void		XRSC_out_reference();
extern	void		XRSC_out_scope();
extern	void		XRSC_out_decl();
extern	void		XRSC_out_proc();
extern	void		XRSC_out_assign();
extern	void		XRSC_out_call();
extern	void		XRSC_out_hier();
extern	void		XRSC_out_memb();
extern	void		XRSC_out_map();






/* end of xrsc_local.h */






