/************************************************************************/
/*									*/
/*		xrefwin.c						*/
/*									*/
/*	Window manipulation routines for cross-reference viewing	*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "xref_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_windows;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Boolean 	setup_window();
static	int		xref_control();
static	void		check_windows();
static	int		xref_edit_control();




/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


#define MENU_WIN	1
#define DISPLAY_WIN	2



static	LEAF_DATA	xref_leaf[] = {
   LEAF_ROOT(NULL),
   { MENU_WIN, LEAF_TYPE_PDM,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT_LINE, LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { DISPLAY_WIN, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_BY,
	     LEAF_COORD_RX, LEAF_COORD_NEXT(MENU_WIN) },
	NULL, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	XREF_win_init -- module initialization			       */
/*									*/
/************************************************************************/


void
XREF_win_init()
{
   all_windows = NULL;
};





/************************************************************************/
/*									*/
/*	XREF_create -- create a new make interface window		*/
/*									*/
/************************************************************************/


XREF_WIN
XREF_create(w,sys)
   ASH_WINDOW w;
   String sys;
{
   XREF_WIN xw;

   xw = PALLOC(XREF_WIN_INFO);
   xw->window = w;
   xw->disp_win = NULL;
   xw->edit_info = NULL;
   xw->clear_fg = FALSE;
   xw->skip_fg = FALSE;
   xw->edit_info = NULL;
   xw->data = NULL;
   xw->outline[0] = 0;

   PROTECT;
   all_windows = CONS(xw,all_windows);
   UNPROTECT;

   ASHset_window_id(w,"xref");
   ASHset_window_defaults(w);

   if (sys != NULL) xw->data = XREF_set_system(sys,TRUE);

   while (xw->data == NULL) {
      if (!XREF_menu_system(xw)) return NULL;
    };

   if (!setup_window(xw)) return NULL;

   XREF_menu_setup(xw);
   XREF_edit_setup(xw);

   return xw;
};





/************************************************************************/
/*									*/
/*	XREF_find_window -- find xref window given ash window		*/
/*									*/
/************************************************************************/


XREF_WIN
XREF_find_window(w)
   ASH_WINDOW w;
{
   register Sequence l;
   register XREF_WIN xw;

   forin (xw,XREF_WIN,l,all_windows) {
      if (xw->window == w) break;
      else if (xw->menu_win == w) break;
      else if (xw->disp_win == w) break;
    };

   return xw;
};





/************************************************************************/
/*									*/
/*	XREF_for_all_windows -- call a routine for each window		*/
/*									*/
/************************************************************************/


void
XREF_for_all_windows(rtn,d)
   Function_Ptr rtn;
   Universal d;
{
   Sequence l;
   XREF_WIN xw;

   forin (xw,XREF_WIN,l,all_windows) {
      (*rtn)(xw,d);
    };
};





/************************************************************************/
/*									*/
/*	setup_window -- define the portions of a xref window	       */
/*									*/
/************************************************************************/


static Boolean
setup_window(xw)
   XREF_WIN xw;
{
   Character buf[1024];

   LEAFsetup_window(xw->window,xref_leaf,xw);

   LEAFset_control(xw->window,xref_control);
   LEAFredraw(xw->window);

   xw->menu_win = LEAFinq_window(xw->window,MENU_WIN,0);
   xw->disp_win = LEAFinq_window(xw->window,DISPLAY_WIN,0);

   if (xw->disp_win == NULL) {
      fprintf(stderr,"XREF:  Window too small to run display\n");
      ASHremove(xw->window);
      return FALSE;
    };

   ASHset_control(xw->disp_win,xref_edit_control);
   LEAFset_refresh(xw->window,check_windows);

   if (xw->data->system == NULL) sprintf(buf,"xref: <NO SYSTEM>");
   else sprintf(buf,"xref: %s",xw->data->system);
   ASHset_window_name(xw->window,buf);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	xref_control -- handle ASH and other control messages	       */
/*	check_windows -- handle refresh making window too small 	*/
/*	xref_edit_control -- handle control messages for edit window	*/
/*									*/
/************************************************************************/


static int
xref_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   register XREF_WIN xw;

   xw = XREF_find_window(w);

   if (xw == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      PROTECT;
      all_windows = REMOB(xw,all_windows);
      UNPROTECT;
      xw->window = NULL;
    };

   return ASH_CONTROL_REJECT;
};





static void
check_windows(w)
   ASH_WINDOW w;
{
   XREF_WIN xw;
   ASH_WINDOW dw;

   xw = XREF_find_window(w);

   if (xw == NULL) return;

   dw = LEAFinq_window(w,DISPLAY_WIN,0);

   if (dw != xw->disp_win) {
      if (ASHinq_valid_window(w)) ASHremove(w);
    };
};





static int
xref_edit_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   register XREF_WIN xw;

   xw = XREF_find_window(w);

   if (xw == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"EDIT$REMOVE")) {
      ASHremove(xw->window);
    };

   return ASH_CONTROL_REJECT;
};




/* end of xrefwin.c */
