/************************************************************************/
/*									*/
/*		xrdbmain.c						*/
/*									*/
/*	Main program for xref database					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xrdb_local.h"




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


	Boolean 	XRDB__interact;
	Boolean 	XRDB__cplus2;
	Boolean 	XRDB__compress;



/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	main -- main program						*/
/*									*/
/************************************************************************/


main(argc,argv)
   Integer argc;
   String argv[];
{
   Integer i;
   String file;
   Boolean noload;

   file = NULL;
   XRDB__interact = TRUE;
   XRDB__cplus2 = FALSE;
   XRDB__compress = FALSE;
   noload = FALSE;

   XRDB_syn_init();
   XRDB_file_init();
   XRDB_data_init();
   XRDB_scan_init();

   for (i = 1; i < argc; ++i) {
      if (argv[i][0] == '-') {
	 switch (argv[i][1]) {
	    case 'C' :
	       XRDB__cplus2 = TRUE;
	       break;
	    case 'I' :
	       XRDB_file_include(&argv[i][2]);
	       break;
	    case 'F' :
	       XRDB_comp_flags(&argv[i][2]);
	       break;
	    case 'b' :
	       XRDB__interact = FALSE;
	       break;
	    case 'l' :
	       noload = !noload;
	       break;
	    case 'Z' :
	       XRDB__compress = TRUE;
	       break;
	    default :
	       fprintf(stderr,"XRDB: Invalid parameter %s\n",argv[i]);
	       break;
	  };
       }
      else if (file != NULL) {
	 fprintf(stderr,"XRDB: Only one system can be specified to xref\n");
       }
      else file = argv[i];
    };

   if (file != NULL && !XRDB_file_setup(file,noload)) {
      fprintf(stderr,"XRDB: Error loading cross reference table for %s\n",file);
      file = NULL;
    };

   yyparse();

   exit(0);
};





/* end of xrdbmain.c */
