/*	Copyright 1988 Brown University -- Steven P. Reiss		*/

%{

/************************************************************************/
/*									*/
/*		xrdblex.l						*/
/*									*/
/*	Lexical definitions for cross reference database query language */
/*									*/
/************************************************************************/




#undef YYLMAX
#define YYLMAX		4096



%}

%o 10240

%start ARG



WHITE	([\ \t\n])+
WHITE0	([\ \t\n])*

INT	([0-9]+)

STRING	(\"([^\n"\\]|(\\.))*\")
QITEM	(\@[^\n@]*\@)

ID	([-0-9/.a-zA-Z_$]+)

CHAR0	(\'.\')
CHAR1	(\'\\.\')
CHAR2	(\'\\([0-7]{1,3})\')
CHAR	({CHAR0}|{CHAR1}|{CHAR2})

FLT0	([0-9]+\.[0-9]*)
EXP	([Ee][-+]?[0-9]+)
FLT1	({INT}{EXP})
FLT2	({FLT0}{EXP})
FLT	({FLT0}|{FLT1}|{FLT2})

CMMT	("/*"([^\n*]|(\*+[^/]))*"*/")

ITEM	({INT}|{ID}|{CHAR}|{FLT}|{STRING})
CONST	(\`{ITEM})

OP	("=="|"!="|"<="|"<"|">"|">="|"~=")



%%

{ITEM}				{ yylval.string = SALLOC(yytext);
				  return LX_ITEM;
				}
{QITEM} 			{ if (yytext[yyleng-1] == '@') yytext[yyleng-1] = 0;
				  yylval.string = SALLOC(&yytext[1]);
				  return LX_CONST;
				}
{CONST} 			{ yylval.string = SALLOC(&yytext[1]);
				  return LX_CONST;
				}
"="                             { yylval.intval = QOP_EQL; return LX_OP; }
"=="                            { yylval.intval = QOP_EQL; return LX_OP; }
"!="                            { yylval.intval = QOP_NEQ; return LX_OP; }
"<="                            { yylval.intval = QOP_LEQ; return LX_OP; }
">="                            { yylval.intval = QOP_GEQ; return LX_OP; }
"<"                             { yylval.intval = QOP_LSS; return LX_OP; }
">"                             { yylval.intval = QOP_GTR; return LX_OP; }
"~="                            { yylval.intval = QOP_MATCH; return LX_OP; }
"&&"                            { return '&'; }
"||"                            { return '|'; }

{CMMT}				;
{WHITE} 			;
.				{ return yytext[0]; }


%%

/* end of xrdblex.l */
