/************************************************************************/
/*									*/
/*		xrdb_local.h						*/
/*									*/
/*	Local include file for cross reference database 		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include <datatypes.h>
#include <sequence.h>

#include "xref_common.h"

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <sys/file.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define XRDB_VERSION	3




/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _XRDB_SYS *	XRDB_SYS;
typedef struct _XRDB_FILE *	XRDB_FILE;
typedef struct _XRDB_SCOPE *	XRDB_SCOPE;
typedef struct _XRDB_NAME *	XRDB_NAME;
typedef struct _XRDB_TYPE *	XRDB_TYPE;

typedef struct _XRDB_REF *	XRDB_REF;
typedef struct _XRDB_DECL *	XRDB_DECL;
typedef struct _XRDB_CALL *	XRDB_CALL;
typedef struct _XRDB_FCT *	XRDB_FCT;
typedef struct _XRDB_HIER *	XRDB_HIER;
typedef struct _XRDB_MEMB *	XRDB_MEMB;
typedef struct _XRDB_MDEF *	XRDB_MDEF;

typedef Integer 		XRDB_FILE_ID;
typedef Integer 		XRDB_SCOPE_ID;
typedef Integer 		XRDB_NAME_ID;
typedef Integer 		XRDB_TYPE_ID;
typedef Integer 		XRDB_DECL_ID;
typedef Integer 		XRDB_LINE;


typedef Integer 		XRDB_SCOPE_CLASS;
#define XRDB_SCOPE_NONE 	0
#define XRDB_SCOPE_EXTERN	1
#define XRDB_SCOPE_INTERN	2
#define XRDB_SCOPE_ARGS 	3
#define XRDB_SCOPE_SUE		4




typedef Integer 		XRDB_DECL_CLASS;
#define XRDB_DECL_NONE		0
#define XRDB_DECL_STATIC	1
#define XRDB_DECL_EXTERN	2
#define XRDB_DECL_AUTO		3
#define XRDB_DECL_REGISTER	4
#define XRDB_DECL_TYPEDEF	5
#define XRDB_DECL_PARAM 	6
#define XRDB_DECL_FIELD 	7
#define XRDB_DECL_EFUNCTION	8
#define XRDB_DECL_SFUNCTION	9
#define XRDB_DECL_STRUCTID	10
#define XRDB_DECL_UNIONID	11
#define XRDB_DECL_ENUMID	12
#define XRDB_DECL_CONST 	13
#define XRDB_DECL_EXTDEF	14
#define XRDB_DECL_CLASSID	15
#define XRDB_DECL_MACRO 	16




typedef Integer 		XRDB_PROT_CLASS;
#define XRDB_PROT_NONE		0
#define XRDB_PROT_PUBLIC	1
#define XRDB_PROT_PRIVATE	2
#define XRDB_PROT_PROTECTED	3





typedef struct _XRDB_SYS {		/* system description		*/
   String name;
   String directory;
} XRDB_SYS_INFO;




typedef struct _XRDB_NAME {		/* name description		*/
   String name;
   XRDB_NAME_ID id;
} XRDB_NAME_INFO;




typedef struct _XRDB_FILE {		/* file description		*/
   XRDB_NAME_ID name;
   XRDB_NAME_ID tail;
   XRDB_FILE_ID id;
   XRDB_FILE_ID usedby;
} XRDB_FILE_INFO;




typedef struct _XRDB_SCOPE {		/* scope description		*/
   XRDB_SCOPE_CLASS class;
   Integer id;
   XRDB_LINE start_line;
   XRDB_LINE end_line;
   XRDB_FILE_ID file;
   XRDB_SCOPE_ID inside;
} XRDB_SCOPE_INFO;




typedef struct _XRDB_TYPE {		/* type description		*/
   XRDB_NAME_ID type;
   XRDB_TYPE_ID id;
} XRDB_TYPE_INFO;




typedef struct _XRDB_REF {		/* reference			*/
   XRDB_NAME_ID name;
   XRDB_FILE_ID file;
   XRDB_LINE line;
   Integer assign;
   XRDB_NAME_ID function;
} XRDB_REF_INFO;




typedef struct _XRDB_DECL {		/* declaration			*/
   XRDB_NAME_ID name;
   XRDB_SCOPE_ID scope;
   XRDB_FILE_ID file;
   XRDB_TYPE_ID type;
   XRDB_DECL_CLASS class;
   XRDB_LINE line;
   XRDB_DECL_ID id;
   XRDB_NAME_ID function;
 } XRDB_DECL_INFO;



typedef struct _XRDB_CALL {		/* call information		*/
   XRDB_NAME_ID from;
   XRDB_NAME_ID to;
   XRDB_FILE_ID file;
   XRDB_LINE line;
} XRDB_CALL_INFO;




typedef struct _XRDB_FCT {		/* function information 	*/
   XRDB_NAME_ID name;
   XRDB_FILE_ID file;
   XRDB_LINE line;
   XRDB_SCOPE_ID scope;
   Integer numargs;
   String args;
} XRDB_FCT_INFO;




typedef struct _XRDB_HIER {		/* class hierarchy information	*/
   XRDB_NAME_ID class;
   XRDB_NAME_ID parent;
   XRDB_FILE_ID file;
   XRDB_LINE line;
   Integer public;
   Integer virtual;
   Integer friend;
} XRDB_HIER_INFO;





typedef struct _XRDB_MEMB {		/* class-member information	*/
   XRDB_NAME_ID class;
   XRDB_NAME_ID member;
   XRDB_FILE_ID file;
   XRDB_LINE line;
   XRDB_PROT_CLASS protect;
   Integer isdata;
   Integer inline;
   Integer friend;
   Integer virtual;
   Integer isstatic;
   Integer ispure;
   Integer isconst;
} XRDB_MEMB_INFO;





typedef struct _XRDB_MDEF {		/* member definition information*/
   XRDB_NAME_ID class;
   XRDB_NAME_ID member;
   XRDB_FILE_ID file;
   XRDB_LINE line;
   XRDB_TYPE_ID type;
   XRDB_NAME_ID name;
} XRDB_MDEF_INFO;





/************************************************************************/
/*									*/
/*	Database storage definitions					*/
/*									*/
/************************************************************************/


extern	Sequence	XRDB__all_systems;

extern	XRDB_FILE	XRDB__db_file;
extern	Integer 	XRDB__db_file_max;
extern	Integer 	XRDB__db_file_ct;
extern	XRDB_FILE_ID	XRDB__db_file_id;

extern	XRDB_SCOPE	XRDB__db_scope;
extern	Integer 	XRDB__db_scope_max;
extern	Integer 	XRDB__db_scope_ct;
extern	XRDB_SCOPE_ID	XRDB__db_scope_id;

extern	XRDB_NAME	XRDB__db_name;
extern	Integer 	XRDB__db_name_max;
extern	Integer 	XRDB__db_name_ct;
extern	XRDB_NAME_ID	XRDB__db_name_id;

extern	XRDB_TYPE	XRDB__db_type;
extern	Integer 	XRDB__db_type_max;
extern	Integer 	XRDB__db_type_ct;
extern	XRDB_TYPE_ID	XRDB__db_type_id;

extern	XRDB_REF	XRDB__db_ref;
extern	Integer 	XRDB__db_ref_max;
extern	Integer 	XRDB__db_ref_ct;

extern	XRDB_DECL	XRDB__db_decl;
extern	Integer 	XRDB__db_decl_max;
extern	Integer 	XRDB__db_decl_ct;
extern	XRDB_DECL_ID	XRDB__db_decl_id;

extern	XRDB_CALL	XRDB__db_call;
extern	Integer 	XRDB__db_call_max;
extern	Integer 	XRDB__db_call_ct;

extern	XRDB_FCT	XRDB__db_fct;
extern	Integer 	XRDB__db_fct_max;
extern	Integer 	XRDB__db_fct_ct;

extern	XRDB_HIER	XRDB__db_hier;
extern	Integer 	XRDB__db_hier_max;
extern	Integer 	XRDB__db_hier_ct;

extern	XRDB_MEMB	XRDB__db_memb;
extern	Integer 	XRDB__db_memb_max;
extern	Integer 	XRDB__db_memb_ct;

extern	XRDB_MDEF	XRDB__db_mdef;
extern	Integer 	XRDB__db_mdef_max;
extern	Integer 	XRDB__db_mdef_ct;


extern	Boolean 	XRDB__interact;
extern	Boolean 	XRDB__cplus2;
extern	Boolean 	XRDB__compress;




/************************************************************************/
/*									*/
/*	Module Local Entries						*/
/*									*/
/************************************************************************/



					/* xrdbsyn.y xrdblex.l		*/
extern	void		XRDB_syn_init();



					/* xrdbfile.c			*/
extern	void		XRDB_file_init();
extern	void		XRDB_file_include();
extern	void		XRDB_comp_flags();
extern	Boolean 	XRDB_file_setup();
extern	Boolean 	XRDB_file_check();



					/* xrdbscan.c			*/
extern	void		XRDB_scan_init();
extern	void		XRDB_scan_file();
extern	Integer 	XRDB_scan_string();



					/* xrdbdata.c			*/
extern	void		XRDB_data_init();
extern	void		XRDB_db_store();
extern	Integer 	XRDB_db_load();
extern	void		XRDB_db_system();
extern	void		XRDB_db_add_system();
extern	XRDB_FILE_ID	XRDB_db_new_file();
extern	XRDB_FILE_ID	XRDB_db_find_file();
extern	XRDB_SCOPE_ID	XRDB_db_new_scope();
extern	XRDB_SCOPE_ID	XRDB_db_set_scope();
extern	XRDB_NAME_ID	XRDB_db_find_name();
extern	XRDB_TYPE_ID	XRDB_db_find_type();
extern	void		XRDB_db_ref();
extern	void		XRDB_db_ref_assign();
extern	void		XRDB_db_decl();
extern	void		XRDB_db_call();
extern	void		XRDB_db_fct();
extern	void		XRDB_db_hier();
extern	void		XRDB_db_memb();
extern	String		XRDB_db_file_string();
extern	String		XRDB_db_name_string();
extern	String		XRDB_db_type_string();
extern	void		XRDB_db_check_files();
extern	void		XRDB_db_map_name();
extern	void		XRDB_db_fixup_member_defs();





/* end of xrdb_local.h */





