/************************************************************************/
/*									*/
/*		viewask.c						*/
/*									*/
/*	Options routines for specific viewers				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "view_local.h"



/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	VIEW_ask_init -- module initialization				*/
/*									*/
/************************************************************************/


void
VIEW_ask_init()
{
};




/************************************************************************/
/*									*/
/*	VIEW_ask_btn -- handle options selection			*/
/*									*/
/************************************************************************/


Integer
VIEW_ask_btn(vw,menu,btn)
   VIEW_WIN vw;
   String menu;
   String btn;
{
   Integer i;
   Function_Ptr rp;

   if (vw == NULL || vw->type == NULL || vw->type->name == NULL) return FALSE;

   if (vw->type->options_rtn == NULL) return TRUE;

   rp = (Function_Ptr) DLlookup(vw->type->options_rtn);
   if (rp == NULL) return FALSE;

   i = (*rp)(vw,menu,btn);

   return i;
};




/************************************************************************/
/*									*/
/*	VIEW_remove_btn -- handle remove selection			*/
/*									*/
/************************************************************************/


Integer
VIEW_remove_btn(vw,menu,btn)
   VIEW_WIN vw;
   String menu;
   String btn;
{
   Integer i;
   Function_Ptr rp;

   if (vw == NULL || vw->type == NULL || vw->type->name == NULL) return FALSE;

   if (vw->type->remove_rtn == NULL) return TRUE;

   rp = (Function_Ptr) DLlookup(vw->type->remove_rtn);
   if (rp == NULL) return FALSE;

   i = (*rp)(vw,menu,btn);

   return i;
};




/************************************************************************/
/*									*/
/*	VIEW_ask_stack -- code for stack viewer 			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

Integer
VIEW_ask_stack(vw,mnm,bnm)
   VIEW_WIN vw;
   String mnm;
   String bnm;
{
   String menus[32];
   Integer ct;
   Integer dfg,gfg;
   Character top[32],bot[32];
   Integer i;
   String sys;

   ct = 0;
   menus[ct++] = "%CStack Viewer Options\n";

   menus[ct++] = "%0o Dump\n";
   menus[ct++] = "%3o Dump Globals\n";
   menus[ct++] = "Levels at top of stack:    %1.16t";
   menus[ct++] = "Levels at bottom of stack: %2.16t";

   menus[ct++] = "\n   %a%M   %c";
   menus[ct] = 0;

   dfg = TRUE;
   gfg = TRUE;
   top[0] = 0;
   bot[0] = 0;

   if (!STEMdialog(vw->window,menus,&dfg,top,bot,&gfg)) return FALSE;

   sys = vw->system;
   if (sys == NULL || *sys == 0) sys = "*";

   MSGsenda("DDTR SET %s STACK_DUMP %d",sys,dfg);
   MSGsenda("DDTR SET %s STACK_GLOBAL %d",sys,(gfg ? 2 : 1));

   if (top[0] != 0) {
      i = atol(top);
      if (i == 0) i = 1024;
      MSGsenda("DDTR SET %s STACK_TOP %d",sys,i);
    };

   if (bot[0] != 0) {
      i = atol(top);
      MSGsenda("DDTR SET %s STACK_BOTTOM %d",sys,i);
    };

   MSGsenda("DDTR SET %s STACK_SHOW 1",sys);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	VIEW_ask_trace -- options for trace menu			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

Integer
VIEW_ask_trace(vw,mnm,bnm)
   VIEW_WIN vw;
   String mnm;
   String bnm;
{
   String menus[16];
   Integer ct;
   Character abuf[1024],bbuf[1024],cbuf[64],dbuf[64];
   String sys;
   String r,s,r0,s1,s0;
   Integer disp,ln;

   ct = 0;
   menus[ct++] = "%CVariable to trace\n";

   menus[ct++] = "Variable: %0.38t";
   menus[ct++] = "\n   Watch in ...";

   if (!vw->type->simple) {
      menus[ct++] = "      File:    %1.32t";
      menus[ct++] = "      Routine: %2.32t";
      menus[ct++] = "      Line:    %3.16t";
    }
   else {
      menus[ct++] = "      Routine: %2.32t";
    };

   menus[ct++] = "%4o Only set at update points";

   menus[ct++] = "\n   %a%M   %c";
   menus[ct] = 0;

/* FIELDinq_selection(abuf);		*/
   abuf[0] = 0;

   if (!vw->type->simple) {
      FIELDinq_file(bbuf);
      FIELDinq_function(cbuf);
    }
   else {
      bbuf[0] = 0;
      cbuf[0] = 0;
    };

   dbuf[0] = 0;
   disp = TRUE;

   if (!STEMdialog(vw->window,menus,abuf,bbuf,cbuf,dbuf,&disp)) return FALSE;

   if (abuf[0] == 0) return FALSE;

   if (bbuf[0] == 0) strcpy(bbuf,"*");
   if (cbuf[0] == 0) strcpy(cbuf,"*");
   if (dbuf[0] == 0) strcpy(dbuf,"0");

   sys = vw->system;
   if (sys == NULL || *sys == 0) sys = "*";

   s = (disp ? "DISPLAY" : "WATCH");
   r = MSGcalla("DDTR EVENT ADD %S %S %S %S %S * 0 %s 1",sys,bbuf,cbuf,dbuf,abuf,s);

   if (r == NULL) {
      sprintf(bbuf,"\nNo active system to trace %s\n\n%%M   %%a",abuf);
      STEMdialog1(vw->window,bbuf);
    };

   if (r != NULL) {
      r0 = r;
      ln = strlen(s);
      for ( ; *r != 0 && (strncmp(r,s,ln) != 0 || r[ln] != ' '); ++r);
      if (*r != 0) {
	 r = &r[ln+1];
	 while (isspace(*r)) ++r;
       };
      if (*r != 0) {
	 s = index(r,' ');
	 if (s == NULL) s = index(r,'\n');
	 if (s != NULL) *s = 0;
	 strcpy(bbuf,r);
	 s = bbuf;
	 if (s[0] == '*' && abuf[0] != '*') ++s;
	 else if (s[0] == '(' && s[1] == '*' && abuf[0] != '(' && abuf[0] != '*') {
	    s[0] = ' ';
	    s[1] = ' ';
	    s0 = index(s,')');
	    if (s0 != NULL) *s0 = ' ';
	  };
	 s = MSGcalla("DDTR EVAL %s %S",sys,s);
	 if (s == NULL) sprintf(abuf,"%s = << UNDEFINED >>",r);
	 else {
	    s0 = s;
	    s1 = index(s,'\n');
	    if (s1 != NULL) *s1 = 0;
	    if (s[0] == '"') {
	       s1 = index(&s[1],'"');
	       if (s1 != NULL && STREQL(s1,"\" is not active")) s = "<< NOT ACTIVE >>";
	     };
	    sprintf(abuf,"%s = %s",r,s);
	    SFREE(s0);
	  };
	 VIEW_add(vw,VIEW_find_class(vw,"TRACE"),r,abuf);
       }
      else {
	 r = r0;
	 if (index(r,'%') != NULL) r = "Problem with ddt.  Try again";
	 sprintf(bbuf,"%%CCan't trace %s:\n\n%s\n\n%%M   %%a",abuf,r);
	 STEMdialog1(vw->window,bbuf);
       };
      SFREE(r0);
    };

   return TRUE;
};




/************************************************************************/
/*									*/
/*	VIEW_ask_trace_remove -- remove button for trace menu		*/
/*									*/
/************************************************************************/


#define BITS_PER	30
#define WORDS		4

/*ARGSUSED*/

Integer
VIEW_ask_trace_remove(vw,mnm,bnm)
   VIEW_WIN vw;
   String mnm;
   String bnm;
{
   String menu[20480],buf[1024];
   Integer ct,i,dct;
   String sys;
   Integer val[WORDS];
   String del[BITS_PER*WORDS];

   strcpy(menu,"%CRemove Variable Tracing\n\n");

   ct = vw->num_disp;
   if (ct == 0) return FALSE;

   if (ct > BITS_PER*WORDS) ct = BITS_PER*WORDS;
   for (i = 0; i < ct; ++i) {
      sprintf(buf,"   %%%d.%df %s   \n",(i / BITS_PER),(1 << (i % BITS_PER)),
		  vw->displays[i].key.str);
      strcat(menu,buf);
    };

   strcat(menu,"\n   %a%M   %c");

   for (i = 0; i < WORDS; ++i) val[i] = 0;

   if (!STEMdialog1(vw->window,menu,&val[0],&val[1],&val[2],&val[3])) return FALSE;

   sys = vw->system;
   if (sys == NULL || *sys == 0) sys = "*";

   dct = 0;
   for (i = 0; i < ct; ++i) {
      if (val[i/BITS_PER] & (1 << (i % BITS_PER))) {
	 MSGsenda("DDTR EVENT REMOVE %s * * 0 %S * 0 WATCH 0",sys,
		     vw->displays[i].key.str);
	 MSGsenda("DDTR EVENT REMOVE %s * * 0 %S * 0 TRACE 0",sys,
		     vw->displays[i].key.str);
	 MSGsenda("DDTR EVENT REMOVE %s * * 0 %S * 0 DISPLAY 0",sys,
		     vw->displays[i].key.str);
	 del[dct++] = SALLOC(vw->displays[i].key.str);
       };
    };

   for (i = 0; i < dct; ++i) {
      VIEW_remove(vw,NULL,del[i]);
      SFREE(del[i]);
    };

   return TRUE;
};




/* end of viewask.c */

