/************************************************************************/
/*									*/
/*		view_local.h						*/
/*									*/
/*	Local definitions for view package				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	VIEW__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>

#include <auxd.h>
#include <editor.h>
#include <edt.h>
#include <msg.h>
#include <field.h>

#include <view.h>





/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/






/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _VIEW_CLASS *	VIEW_CLASS;
typedef struct _VIEW_DATA *	VIEW_DATA;
typedef struct _VIEW_WTYPE *	VIEW_WTYPE;
typedef struct _VIEW_WIN *	VIEW_WIN;



typedef struct _VIEW_CLASS {
   String	name;
   String	display_fmt;
   String	msg_add;
   String	msg_remove;
   String	msg_end;
} VIEW_CLASS_INFO;





typedef struct _VIEW_DATA {
   String	text;
   union {
      String	   str;
      Float	   num;
    } key;
   Boolean	invalid;
} VIEW_DATA_INFO;





typedef struct _VIEW_WTYPE {
   String	name;
   String	msg_open;
   String	msg_clear;
   String	msg_invalidate;
   String	options_rtn;
   String	options_name;
   String	remove_rtn;
   String	remove_name;
   Boolean	num_key;
   Boolean	simple;
   Boolean	askfirst;
   Sequence	allowed;
} VIEW_WTYPE_INFO;





typedef struct _VIEW_WIN {
   ASH_WINDOW	window;
   VIEW_WTYPE	type;
   ASH_WINDOW	edit_win;
   ASH_WINDOW	menu_win;
   String	system;
   EDT_ID	edit_info;
   Boolean	willow_fg;
   Integer	num_disp;
   VIEW_DATA	displays;
   Integer	max_disp;
} VIEW_WIN_INFO;






/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* viewmain.c		       */
extern	void		VIEW_init();



					/* viewwin.c		       */
extern	void		VIEW_win_init();
extern	VIEW_WIN	VIEW_create();
extern	VIEW_WIN	VIEW_find_window();



					/* viewmenu.c			*/
extern	void		VIEW_menu_init();
extern	void		VIEW_edit_mouse();





					/* viewedit.c		       */
extern	void		VIEW_edit_init();
extern	void		VIEW_edit_setup();
extern	void		VIEW_insert_line();
extern	void		VIEW_delete_line();
extern	void		VIEW_replace_line();
extern	void		VIEW_truncate_at();





					/* viewmsg.c		       */
extern	void		VIEW_mon_init();
extern	void		VIEW_mon_setup();
extern	void		VIEW_mon_remove();


					/* viewtext.c			*/
extern	void		VIEW_text_init();
extern	void		VIEW_text_setup();
extern	void		VIEW_add();
extern	void		VIEW_remove();
extern	void		VIEW_end();
extern	void		VIEW_clear();
extern	void		VIEW_invalidate();



					/* viewask.c			*/
extern	void		VIEW_ask_init();
extern	Integer 	VIEW_ask_btn();
extern	Integer 	VIEW_remove_btn();
extern	Integer 	VIEW_ask_stack();
extern	Integer 	VIEW_ask_trace();
extern	Integer 	VIEW_ask_trace_remove();



					/* viewdef.c			*/
extern	void		VIEW_def_init();
extern	VIEW_WTYPE	VIEW_find_window_type();
extern	VIEW_CLASS	VIEW_find_class();
extern	Integer 	VIEW_inq_window_types();
extern	Integer 	VIEW_inq_classes();





/* end of view_local.h */
