#include "list.h" 

/* Procedure : create_new_item
 * 
 * This procedure creates a new item to add to the list.  It sets the 
 * value field of the list item to the given parameter.  A pointer to 
 * the new item is returned.  The next and back fields are initialized 
 * to point back to the node itself. 
 *
 * Calls : none
 * Called by : add_to_list 
 * Returns : list_item_t *  -  new item with given value 
 */

list_item_t
*create_new_item(value)
int              value;   /* value associated with new item */
{
    list_item_t     *new_item;

    new_item = (list_item_t *)malloc(sizeof(list_item_t));
    new_item->value = value;
    new_item->next = NULL;

    return(new_item);
}


/* Procedure : add_to_list
 *
 * This procedure adds the given item (created by create_new_item) to the list before 
 * the item pointed to by the parameter after. 
 *
 * Calls : none
 * Called by : ?
 * Returns : void
 */

void
add_to_list(before,after,new_item)
list_item_t       *before;    /* node before current node */
list_item_t       *after;     /* node after current node  */
list_item_t       *new_item;  /* item to add to list */
{
    new_item->next = after;
    before->next = new_item;
}

/* Procedure : free_list  
 *
 * This procedure frees the dynamic storage associated with a given 
 * linked list.  It goes through the list deleting each item.
 * It then deletes the dummy node.
 *
 * Calls : none
 * Called by : ?
 * Returns : void
 */

void
free_list(head)
list_item_t      *head;   /* list to free */
{
    list_item_t    *item_to_free;

    while ((head->next != NULL))
    {
       item_to_free = head->next;
       head->next = head->next->next;
       free(item_to_free);
    }
    free(head);
}


