/************************************************************************/
/*									*/
/*		pmat_local.h						*/
/*									*/
/*	Local definitions for pattern matching package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include <datatypes.h>
#include <sequence.h>
#include "pmat.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_ARGS	10
#define MAX_DUMMY	20
#define MAX_TOTAL	(MAX_ARGS+MAX_DUMMY)





/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _PMAT_ARG *	PMAT_ARG;


typedef enum {
   PMAT_TYPE_NONE,
   PMAT_TYPE_CHAR,
   PMAT_TYPE_STRING,
   PMAT_TYPE_QUOTES,
   PMAT_TYPE_PATTERN,
   PMAT_TYPE_NPATTERN,
   PMAT_TYPE_FLOAT,
   PMAT_TYPE_INT
} PMAT_ARG_TYPE;




typedef struct _PMAT_ARG {
   PMAT_ARG_TYPE type;
   Byte base;
   Boolean dummy;
   Short length;
   Universal dflt;
   Universal match;
} PMAT_ARG_INFO;





typedef struct _PMAT_PAT {
   String	pattern;
   Integer	numargs;
   Integer	retargs;
   PMAT_ARG_INFO * arg;
} PMAT_PAT_INFO;






/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/






/* end of pmat_local.h */
