/************************************************************************/
/*									*/
/*		msgutil.c						*/
/*									*/
/*	Utility routines for MSG module 				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "msg_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define SERVICE_CHECK_MSG	"SERVICE CHECK %s"
#define SERVICE_RUNNING_MSG	"SERVICE START %s"

#define SERVICE_RUNNING_RPY	"SERVICE START %1s"




/************************************************************************/
/*									*/
/*	Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _SERVER *	SERVER;

typedef struct _SERVER {
   String id;
   Boolean pending;
   Boolean active;
   SERVER next;
} SERVER_INFO;





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	SERVER		first_server;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		running_routine();
static	void		check_routine();
static	SERVER		find_service();




/************************************************************************/
/*									*/
/*	MSG_util_init -- module initialization				*/
/*									*/
/************************************************************************/


void
MSG_util_init()
{
   first_server = NULL;

   MSGregister(SERVICE_RUNNING_RPY,running_routine,1,NULL);
};





/************************************************************************/
/*									*/
/*	MSGservice_start -- start up a service				*/
/*									*/
/************************************************************************/


void
MSGservice_start(id,rtn,sys,args)
   String id;
   Function_Ptr rtn;
   String sys;
   String args[];
{
   String rslt;
   Integer pid,i,ct;
   SERVER s;

   s = find_service(id);

   if (!s->pending) {
      rslt = MSGcalla(SERVICE_CHECK_MSG,id);
      if (rslt != NULL && *rslt != 0) {
	 s->active = TRUE;
	 return;
       };
      s->active = FALSE;
    };

   PROTECT;
   if (!s->pending) {
      s->pending = TRUE;
      UNPROTECT;

      if (rtn != NULL) (*rtn)();
      else {
	 pid = vfork();

	 if (pid < 0) {
	    fprintf(stderr,"Can't fork off service %s\n",id);
	    exit(1);
	  };

	 if (pid == 0) {
	    ct = getdtablesize();
	    for (i = 3; i < ct; ++i) close(i);

	    execv(sys,args);
	    fprintf(stderr,"Can't exec service %s\n",id);
	    exit(1);
	  };
       };
    };

   while (!s->active) {
      CMPXselect(0);
    };
};






/************************************************************************/
/*									*/
/*	MSGservice_register -- register a service as now available	*/
/*									*/
/************************************************************************/


Boolean
MSGservice_register(id)
   String id;
{
   Character buf[1024];
   SERVER s;

   s = find_service(id);

   s->pending = TRUE;
   if (s->active) return FALSE;

   sprintf(buf,SERVICE_CHECK_MSG,id);
   MSGregister(buf,check_routine,0,NULL);

   MSGsenda(SERVICE_RUNNING_MSG,id);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	running_routine -- handle running messages from servers 	*/
/*									*/
/************************************************************************/


static void
running_routine(id,rid)
   String id;
   Integer rid;
{
   SERVER s;

   s = find_service(id);

   s->active = TRUE;
   s->pending = FALSE;

   if (rid >= 0) MSGreply(rid,NULL);
};





/************************************************************************/
/*									*/
/*	check_routine -- handle check messages for a server		*/
/*									*/
/************************************************************************/


static void
check_routine(rid)
   Integer rid;
{
   Character buf[128];

   if (rid >= 0) {
      sprintf(buf,"%d",getpid());
      MSGreply(rid,buf);
    };
};





/************************************************************************/
/*									*/
/*	find_service -- find service by name				*/
/*									*/
/************************************************************************/


static SERVER
find_service(id)
   String id;
{
   SERVER s;

   PROTECT;
   for (s = first_server; s != NULL; s = s->next) {
      if (STREQL(s->id,id)) break;
    };

   if (s == NULL) {
      s = PALLOC(SERVER_INFO);
      s->id = SALLOC(id);
      s->pending = FALSE;
      s->active = FALSE;
      s->next = first_server;
      first_server = s;
    };
   UNPROTECT;

   return s;
};





/* end of msgutil.c */
