/************************************************************************/
/*									*/
/*		msg_local.h						*/
/*									*/
/*	Local definitions for editor interface package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	MSG__sema

#include <datatypes.h>
#include <sequence.h>

#include <auxd.h>
#include <pmat.h>
#include <cmpx.h>

#include <msg.h>






/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define SERVER_NAME	"msgserver"
#define SERVER_ID	"msgserver"
#define MSG_ARG 	"-msglock"




/************************************************************************/
/*									*/
/*	System definitions						*/
/*									*/
/************************************************************************/


#ifndef FD_SET
#undef NBBY
#undef FD_SETSIZE
#define NBBY	8		/* number of bits in a byte */
/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */
#define FD_SETSIZE	32

typedef long	fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define howmany(x, y)	(((x)+((y)-1))/(y))
#endif

#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define REGISTER_CHAR	'\1'
#define FREE_CHAR	'\2'
#define EOM_CHAR	'\3'
#define ABORT_CHAR	'\4'
#define CALL_CHAR	'\5'
#define REPLY_CHAR	'\6'




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


extern	void		MSG_file_init();

extern	void		MSG_util_init();





/* end of msg_local.h */
