/************************************************************************/
/*									*/
/*		fsymmips.c						*/
/*									*/
/*	Symbol reading definitions for DEC 3100 (mips-based) computer	*/
/*									*/
/************************************************************************/
/* Copyright 1989 Brown University -- Steven P. Reiss			*/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "fsym_local.h"

#include <a.out.h>
#include <sys/file.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local type definitions						*/
/*									*/
/************************************************************************/


typedef struct _FSYM_ID {
   FILE * fid;
   String stringtbl;
   struct filehdr fhdr;
   struct aouthdr ahdr;
   HDRR symhdr;
   String lstring;
   FDR * fdesc;
} FSYM_ID_INFO;





/************************************************************************/
/*									*/
/*	Macros								*/
/*									*/
/************************************************************************/


#ifdef sparc
#define N_BADMACH(hdr) ((hdr).a_machtype != M_SPARC)
#else
#define N_BADMACH(hdr) ((hdr).a_machtype == M_SPARC)
#endif





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	FSYMopen -- open a .o or executable file			*/
/*									*/
/************************************************************************/


FSYM_ID
FSYMopen(name,execonly)
   String name;
   Boolean execonly;
{
   FILE * fid;
   FSYM_ID fs;
   Integer ln;

   fid = fopen(name,"r");
   if (fid == NULL) return NULL;

   fs = PALLOC(FSYM_ID_INFO);
   fs->fid = fid;
   fs->lstring = NULL;
   fs->fdesc = NULL;

   if (fread(&fs->fhdr,sizeof(struct filehdr),1,fid) != 1) {
      FSYMclose(fs);
      return NULL;
    };

   if (!ISCOFF(fs->fhdr.f_magic)) {
      FSYMclose(fs);
      return NULL;
    };

   if (execonly && (fs->fhdr.f_flags & F_EXEC) == 0) {
      FSYMclose(fs);
      return NULL;
    };

   if (fs->fhdr.f_opthdr > 0) {
      fseek(fid,sizeof(struct filehdr)+fs->fhdr.f_opthdr,0);
      if (fread(&fs->ahdr,sizeof(struct aouthdr),1,fid) != 1) {
	 FSYMclose(fs);
	 return NULL;
       };
      if (execonly && fs->ahdr.magic == OMAGIC) {
	 FSYMclose(fs);
	 return NULL;
       };
    };

   fseek(fid,fs->fhdr.f_symptr,0);
   if (fread(&fs->symhdr,sizeof(HDRR),1,fid) != 1 || fs->symhdr.magic != magicSym) {
      FSYMclose(fs);
      return NULL;
    };

   fseek(fid,fs->symhdr.cbSsOffset,0);
   ln = fs->symhdr.issMax;
   fs->lstring = (String) malloc(ln+10);
   if (ln != 0) fread(fs->lstring,ln,1,fid);

   fseek(fid,fs->symhdr.cbFdOffset,0);
   ln = fs->symhdr.ifdMax;
   if (ln != 0) {
      fs->fdesc = (FDR *) calloc(ln,sizeof(FDR));
      fread(fs->fdesc,ln,sizeof(FDR),fid);
    };

   return fs;
};






/************************************************************************/
/*									*/
/*	FSYMclose -- close binary file					*/
/*									*/
/************************************************************************/


void
FSYMclose(fs)
   FSYM_ID fs;
{
   if (fs->fid != NULL) fclose(fs->fid);
   fs->fid = NULL;

   if (fs->lstring != NULL) free(fs->lstring);
   fs->lstring = NULL;

   if (fs->fdesc != NULL) free(fs->fdesc);
   fs->fdesc = NULL;

   free(fs);
};





/************************************************************************/
/*									*/
/*	FSYMtest_exec -- check for executable vs .o file		*/
/*									*/
/************************************************************************/


int
FSYMtest_exec(fs)
   FSYM_ID fs;
{
   return ((fs->fhdr.f_flags & F_EXEC) != 0);
};






/************************************************************************/
/*									*/
/*	FSYMsymbols -- read symbols from executable file		*/
/*									*/
/************************************************************************/


void
FSYMsymbols(fs,tbl,data)
   FSYM_ID fs;
   FSYM_CALL * tbl;
   Universal data;
{
   Integer nsym,nfil;
   Integer i,j,k,ln;
   Integer base;
   voidFunction_Ptr rtns[FSYM_TYPE_CT];
   FSYM_TYPE ft;
   String name;
   SYMR * symtbl;
   PDR * proctbl;
   SYMR * sym;

   for (i = 0; i < FSYM_TYPE_CT; ++i) rtns[i] = NULL;

   for (i = 0; tbl[i].type != FSYM_TYPE_END; ++i) {
      rtns[(int) tbl[i].type] = tbl[i].addr;
    };

   nsym = fs->symhdr.isymMax;
   nfil = fs->symhdr.ifdMax;
   if (nsym == 0 || nfil == 0) return;

   symtbl = (SYMR *) calloc(nsym,sizeof(SYMR));
   fseek(fs->fid,fs->symhdr.cbSymOffset,0);
   fread(symtbl,sizeof(SYMR),nsym,fs->fid);

   proctbl = (PDR *) calloc(fs->symhdr.ipdMax,sizeof(PDR));
   fseek(fs->fid,fs->symhdr.cbPdOffset,0);
   fread(proctbl,sizeof(PDR),fs->symhdr.ipdMax,fs->fid);

   for (i = 0; i < nfil; ++i) {
      base = fs->fdesc[i].issBase;
      for (j = 0; j < fs->fdesc[i].csym; ++j) {
	 sym = &symtbl[fs->fdesc[i].isymBase+j];
	 if (sym->iss == 0) name = "";
	 else name = &fs->lstring[sym->iss+base];

	 switch (sym->st) {
	    case stFile :
	       ft = FSYM_TYPE_SO;
	       ln = strlen(name);
	       if (name[ln-2] == '.' && name[ln-1] == 'h') ft = FSYM_TYPE_BINCL;
	       break;
	    case stProc :
	       ft = FSYM_TYPE_TEXT_EXT;
	       break;
	    case stStaticProc :
	       ft = FSYM_TYPE_TEXT;
	       break;
	    case stLocal :
	    case stParam :
	       ft = FSYM_TYPE_AUTO;
	       break;
	    case stStatic :
	       ft = FSYM_TYPE_LOCAL;
	       break;
	    case stGlobal :
	       ft = FSYM_TYPE_GLOBAL;
	       break;
	    case stTypedef :
	       ft = FSYM_TYPE_TYPE;
	       if (sym->value != 0) ft = FSYM_TYPE_STRUCT;
	       break;
	    case stBlock :
	       if (sym->sc == scText) ft = FSYM_TYPE_LBRAC;
	       else ft = FSYM_TYPE_END;
	       break;
	    case stEnd :
	       ln = strlen(name);
	       if (name[0] == 0 && sym->sc == scText) ft = FSYM_TYPE_RBRAC;
	       else if (name[ln-2] == '.' && name[ln-1] == 'h') ft = FSYM_TYPE_EINCL;
	       else ft = FSYM_TYPE_END;
	       break;

	    default :
	       ft = FSYM_TYPE_END;
	       break;
	  };

	 if (rtns[(int) ft] != NULL) {
	    (*rtns[(int) ft])(name,sym->sc,sym->value,ft,data);
	  };

	 if (rtns[(int) FSYM_TYPE_SLINE] != NULL &&
		(ft == FSYM_TYPE_TEXT || ft == FSYM_TYPE_TEXT_EXT)) {
	    for (k = 0; k < fs->symhdr.ipdMax; ++k) {
	       if (fs->fdesc[i].isymBase+j == proctbl[k].isym) {
		  (*rtns[(int) FSYM_TYPE_SLINE])(NULL,proctbl[k].lnLow,
						    proctbl[k].adr,FSYM_TYPE_SLINE,data);
		  (*rtns[(int) FSYM_TYPE_SLINE])(NULL,proctbl[k].lnHigh,
						    proctbl[k].adr,FSYM_TYPE_SLINE,data);
		  break;
		};
	     };
	  };
       };
    };

   free(symtbl);
   free(proctbl);
};




/* end of fsymmips.c */
