/************************************************************************/
/*									*/
/*		fprofrun.c						*/
/*									*/
/*	Routines to run the fieldgprof system from fprof		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "fprof_local.h"




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	FPROF_run_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
FPROF_run_init()
{
};




/************************************************************************/
/*									*/
/*	FPROF_run_setup -- setup fprof database for a window		*/
/*									*/
/************************************************************************/


void
FPROF_run_setup(fw)
   FPROF_WIN fw;
{
   Integer ip[2],op[2];
   Character buf[128];
   Integer pid;
   Boolean errfg;

   MSGcommand_name(GPROF_NAME,buf);

   pipe(ip);
   pipe(op);

   errfg = FALSE;

   pid = vfork();

   if (pid < 0) {
      FPROF_error(fw,"Can't start fprof database");
      return;
    };

   if (pid == 0) {
      dup2(ip[0],0);
      dup2(op[1],1);
      dup2(op[1],2);
      close(ip[1]);
      close(op[0]);
      execl(buf,"gprof","-i",0);
      errfg = TRUE;
      _exit(1);
    };

   if (!errfg) {
      fw->pid = pid;
      fw->cmd_file = fdopen(ip[1],"w");
      fw->data_file = fdopen(op[0],"r");
      close(ip[0]);
      close(op[1]);
    };

   if (fw->system != NULL) {
      FPROF_run_system(fw);
    };
};




/************************************************************************/
/*									*/
/*	FPROF_run_system -- change/set system for fprof database	*/
/*									*/
/************************************************************************/


void
FPROF_run_system(fw)
   FPROF_WIN fw;
{
   if (fw->system == NULL || fw->cmd_file == NULL) return;

   fprintf(fw->cmd_file,"S %s\n",fw->system);

   fflush(fw->cmd_file);

   FPROF_data_clear(fw);

   FPROF_run_update(fw);
   FPROF_run_profile(fw,NULL,NULL,NULL);
};







/************************************************************************/
/*									*/
/*	FPROF_run_update -- get new gmon.out file			*/
/*									*/
/************************************************************************/


void
FPROF_run_update(fw)
   FPROF_WIN fw;
{
   fprintf(fw->cmd_file,"R\n");
   fflush(fw->cmd_file);
};





/************************************************************************/
/*									*/
/*	FPROF_run_profile -- get profile information			*/
/*									*/
/************************************************************************/


void
FPROF_run_profile(fw,fl,file,fct)
   FPROF_WIN fw;
   FPROF_LINE fl;
   String file;
   String fct;
{
   String line;
   Character buf[1024];
   Integer ln;

   if (file == NULL || *file == '?') {
      file = "?";
      fct = "*";
      line = "*";
    }
   else if (fct == NULL || *fct == '?') {
      fct = "?";
      line = "*";
    }
   else {
      line = "?";
    };

   FPROF_edit_save_top(fw);

   fprintf(fw->cmd_file,"P %s %s %s\n",file,fct,line);
   fflush(fw->cmd_file);

   FPROF_data_gather(fw,fl,NULL);

   for ( ; ; ) {
      if (fgets(buf,1024,fw->data_file) == NULL) break;
      ln = strlen(buf);
      if (buf[ln-1] == '\n') buf[ln-1] = 0;
      if (STREQL(buf,ENDQUERY)) break;
      FPROF_data_gather(fw,fl,buf);
    };

   FPROF_edit_goto_top(fw);
};





/************************************************************************/
/*									*/
/*	FPROF_run_order -- set sort order in gprof			*/
/*									*/
/************************************************************************/


void
FPROF_run_order(fw)
   FPROF_WIN fw;
{
   Character c;

   switch (fw->order) {
      case ORDER_SYMS :
	 c = 'S';
	 break;
      case ORDER_TIME :
	 c = 'T';
	 break;
      case ORDER_COUNT :
	 c = 'C';
	 break;
      case ORDER_ALPHA :
	 c = 'A';
	 break;
    };

   fprintf(fw->cmd_file,"O %c\n",c);
   fflush(fw->cmd_file);
};





/* end of fprofrun.c */




