/************************************************************************/
/*									*/
/*		fprofmenu.c						*/
/*									*/
/*	Menu handling routines for FPROF package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "fprof_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


typedef struct _NAME_DATA {
   Character name[256];
   Character file[256];
   Character type[256];
   Integer count;
} NAME_DATA;






/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	int		system_btn();
static	int		update_btn();
static	int		order_btn();
static	int		quit_btn();
static	void		set_system();





/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


static STEM_PDM_DATA	fprof_menus[] = {
   { STEM_PSTATE_MENU,	"Profile",      NULL },
   { STEM_PSTATE_BTN,	"System",       system_btn },
   { STEM_PSTATE_BTN,	"Files",        NULL },
   { STEM_PSTATE_BTN,	"Update",       update_btn },
   { STEM_PSTATE_BTN,	"Order",        order_btn },
   { STEM_PSTATE_BTN,	"Quit",         quit_btn },

   { STEM_PSTATE_END }
};





/************************************************************************/
/*									*/
/*	FPROF_menu_init -- module initialization			*/
/*									*/
/************************************************************************/


void
FPROF_menu_init()
{
};





/************************************************************************/
/*									*/
/*	FPROF_menu_setup -- setup menu for window			*/
/*									*/
/************************************************************************/


void
FPROF_menu_setup(fw)
   FPROF_WIN fw;
{
   if (fw->menu_win == NULL) return;

   STEMpdm_define(fw->menu_win,fw,fprof_menus);
};





/************************************************************************/
/*									*/
/*	FPROF_menu_system -- get system name				*/
/*									*/
/************************************************************************/


Boolean
FPROF_menu_system(fw)
   FPROF_WIN fw;
{
   Character menu[10240];
   Character sys[64],buf[256];
   Integer sct,val;
   Integer i;
   String systems[32];

   strcpy(menu,"%CSystem to Profile\n\n");

   sct = FIELDinq_systems(32,systems);

   strcat(menu,"System: %0.32t\n\n");

   if (fw->system != NULL) {
      sprintf(buf,"   %%1.0o %s\n",fw->system);
      strcat(menu,buf);
      val = 0;
    }
   else val = 1;

   for (i = 0; i < sct; ++i) {
      if (fw->system != NULL && STREQL(fw->system,systems[i])) continue;
      sprintf(buf,"   %%1.%do %s\n",i+1,systems[i]);
      strcat(menu,buf);
    };

   strcat(menu,"\n   %a%M   %c\n");

   sys[0] = 0;

   if (fw->system != NULL || sct != 1) {
      if (!STEMdialog1(fw->window,menu,sys,&val)) return FALSE;
    };

   if (sys[0] == 0) {
      if (fw->system != NULL && val == 0) return FALSE;
      else if (val-1 >= sct) return FALSE;
      strcpy(sys,systems[val-1]);
    };

   if (fw->system != NULL && STREQL(sys,fw->system)) return FALSE;

   if (fw->system != NULL) SFREE(fw->system);

   set_system(fw,sys);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	system_btn -- handle Set System button				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
system_btn(fw,menu,btn)
   FPROF_WIN fw;
   String menu;
   String btn;
{
   FPROF_menu_system(fw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	update_btn -- handle update request				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
update_btn(fw,menu,btn)
   FPROF_WIN fw;
   String menu;
   String btn;
{
   FPROF_run_system(fw);
};





/************************************************************************/
/*									*/
/*	order_btn -- handle sort order request				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
order_btn(fw,mnm,btn)
   FPROF_WIN fw;
   String mnm;
   String btn;
{
   String menu[20];
   Integer ct,vl;
   FPROF_ORDER fo;

   ct = 0;
   menu[ct++] = "%CSort Order for Profiling\n";
   menu[ct++] = "%0.0o Symbol table order";
   menu[ct++] = "%0.1o Run time";
   menu[ct++] = "%0.2o Usage counts";
   menu[ct++] = "%0.3o Alphabetical";
   menu[ct++] = "\n   %a%M   %c";
   menu[ct] = 0;

   vl = (Integer) fw->order;

   if (!STEMdialog(fw->window,menu,&vl)) return FALSE;

   fo = (FPROF_ORDER) vl;
   if (fo == fw->order) return TRUE;

   fw->order = fo;
   FPROF_run_order(fw);
   FPROF_run_system(fw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	quit_btn -- handle quit request 				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
quit_btn(fw,mnm,btn)
   FPROF_WIN fw;
   String mnm;
   String btn;
{
   ASHremove(fw->window);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	set_system -- set new system					*/
/*									*/
/************************************************************************/


static void
set_system(fw,sys)
   FPROF_WIN fw;
   String sys;
{
   Character buf[1024];

   fw->system = SALLOC(sys);

   sprintf(buf,"fprof: %s",fw->system);
   ASHset_window_name(fw->window,buf);

   FPROF_run_system(fw);
};





/* end of fprofmenu.c */


