/************************************************************************/
/*									*/
/*		fprofmain.c						*/
/*									*/
/*	General routines for cross-reference viewing			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "fprof_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	fprof_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	FPROFinit -- package initialization				*/
/*									*/
/************************************************************************/


void
FPROFinit()
{
   PROT_INIT;
   PROTECT;
   if (!fprof_inited) {
      fprof_inited = TRUE;
      MSGinit(FALSE);
      FPROF_win_init();
      FPROF_menu_init();
      FPROF_edit_init();
      FPROF_run_init();
      FPROF_data_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	FPROFnew_willow_window -- create a new willow window		*/
/*									*/
/************************************************************************/


int
FPROFnew_willow_window(w)
   ASH_WINDOW w;
{
   register FPROF_WIN xw;

   FPROFinit();

   xw = FPROF_create(w,NULL);

   if (xw == NULL) return FALSE;

   xw->willow_fg = TRUE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	FPROFnew_window -- create a new building window of given type	*/
/*									*/
/************************************************************************/


int
FPROFnew_window(w,sys)
   ASH_WINDOW w;
   String sys;
{
   register FPROF_WIN xw;

   FPROFinit();

   xw = FPROF_create(w,sys);

   return (xw != NULL);
};





/************************************************************************/
/*									*/
/*	FPROF_error -- handle error conditions				*/
/*									*/
/************************************************************************/


/*VARARGS2*/

void
FPROF_error(xw,pat,a1,a2,a3,a4,a5,a6,a7,a8)
   FPROF_WIN xw;
   String pat;
   Universal a1,a2,a3,a4,a5,a6,a7,a8;
{
   Character buf[512],msg[128];

   sprintf(msg,pat,a1,a2,a3,a4,a5,a6,a7,a8);

   sprintf(buf,"\n%s\n%%R%%a",msg);

   STEMdialog1(xw->window,buf);
};





/* end of fprofmain.c */
