/************************************************************************/
/*									*/
/*		fprofedit.c						*/
/*									*/
/*	Editor interface for profiling interface			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "fprof_local.h"
#include <editor.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	int		fprof_mouse();




/************************************************************************/
/*									*/
/*	FPROF_edit_init -- module initialization			 */
/*									*/
/************************************************************************/


void
FPROF_edit_init()
{
};





/************************************************************************/
/*									*/
/*	FPROF_edit_setup -- setup editor				*/
/*									*/
/************************************************************************/


void
FPROF_edit_setup(fw)
   FPROF_WIN fw;
{
   register EDT_DATA ed;
   register EDT_ID ei;

   if (fw->disp_win == NULL) return;

   ed = PALLOC(EDT_DATA_INFO);
   ed->readonly = FALSE;
   ed->create = FALSE;
   ed->temporary = TRUE;
   ed->scroll = TRUE;
   ed->raw = FALSE;
   ed->echo = FALSE;
   ed->savectl = FALSE;
   ed->mode = "SCRIPT";
   ed->bounds_rtn = NULL;
   ed->input_rtn = NULL;
   ed->mouse_rtn = fprof_mouse;
   ed->file_rtn = NULL;
   ed->input_filter = NULL;
   ed->output_filter = NULL;

   ei = EDTdefine_editor(fw->disp_win,NULL,ed,fw,fw->menu_win,NULL);

   EDTenable(ei,FALSE);

   fw->edit_info = ei;
};





/************************************************************************/
/*									*/
/*	FPROF_edit_clear -- clear edit display				*/
/*	FPROF_edit_remove -- remove set of lines			*/
/*	FPROF_edit_insert -- insert a new line				*/
/*									*/
/************************************************************************/


void
FPROF_edit_clear(fw,from)
   FPROF_WIN fw;
   Integer from;
{
   if (fw->edit_info != NULL) {
      EDTenable(fw->edit_info,TRUE);
      EDTtruncate_at(fw->edit_info,from);
      EDTenable(fw->edit_info,FALSE);
    };
};





void
FPROF_edit_remove(fw,from,to)
   FPROF_WIN fw;
   Integer from;
   Integer to;
{
   Integer i;

   if (fw->edit_info != NULL) {
      EDTenable(fw->edit_info,TRUE);
      for (i = 0; i < to-from+1; ++i) {
	 EDTdelete_line(fw->edit_info,from);
       };
      EDTenable(fw->edit_info,FALSE);
    };
};





void
FPROF_edit_insert(fw,line,text)
   FPROF_WIN fw;
   Integer line;
   String text;
{
   if (fw->edit_info != NULL) {
      EDTenable(fw->edit_info,TRUE);
      EDTinsert_line(fw->edit_info,line,text);
      EDTenable(fw->edit_info,FALSE);
    };
};





/************************************************************************/
/*									*/
/*	FPROF_edit_save_top -- remember top line of display		*/
/*	FPROF_edit_goto_top -- goto top line of display 		*/
/*									*/
/************************************************************************/


void
FPROF_edit_save_top(fw)
   FPROF_WIN fw;
{
   Integer top,bot,wid;
   Integer ct;

   ct = EDTinq_bounds(fw->edit_info,&wid,&top,&bot,1);

   if (ct == 0) fw->topline = 1;
   else fw->topline = top;
};





void
FPROF_edit_goto_top(fw)
   FPROF_WIN fw;
{
   EDTgoto(fw->edit_info,fw->topline);
};





/************************************************************************/
/*									*/
/*	fprof_mouse -- handle mouse hits on editor			 */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
fprof_mouse(fw,btn,l,c,fl,fc,tl,tc)
   FPROF_WIN fw;
   Integer btn;
   Integer l,c;
   Integer fl,fc;
   Integer tl,tc;
{
   Boolean fg;

   fg = FPROF_data_expand(fw,l);

   return fg;
};





/* end of fprofedit.c */
