/************************************************************************/
/*									*/
/*		formtrans.c						*/
/*									*/
/*	Routines to manage transcript window for FORM front end 	*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "form_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_COMPONENTS		256





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	int		form_trans_control();
static	void		form_trans_mouse();




/************************************************************************/
/*									*/
/*	FORM_trans_init -- module initialization			*/
/*									*/
/************************************************************************/


void
FORM_trans_init()
{
};





/************************************************************************/
/*									*/
/*	FORM_trans_setup -- setup information window for browser	*/
/*									*/
/************************************************************************/


void
FORM_trans_setup(fw,newfg)
   FORM_WIN fw;
   Boolean newfg;
{
   ASH_WINDOW w;

   if (newfg) {
      w = ASHroot_window(ASHinq_display_name(fw->window),"transcript");
      w = WINDsetup(w);
    }
   else {
      w = fw->window;
    };

   if (w == NULL) return;

   fw->text_win = w;
   ASHset_control(fw->text_win,form_trans_control);

   fw->edit_info = EDTedit_output(fw->text_win,fw);
   if (fw->edit_info == NULL) {
      fw->text_win = NULL;
      if (ASHinq_valid_window(w)) ASHremove(w);
      return;
    };

   EDTprohibit_close(fw->edit_info);
   EDTauto_linefeed(fw->edit_info,TRUE);
   EDTset_mouse_rtn(fw->edit_info,form_trans_mouse);

   if (fw->last_trans != NULL && fw->last_trans[0] != 0)
      EDTshell_output(fw->edit_info,fw->last_trans);

   EDTenable(fw->edit_info,FALSE);

   ASHvisible(w,TRUE);
};





/************************************************************************/
/*									*/
/*	FORM_trans_output -- output text to transcript			*/
/*									*/
/************************************************************************/


void
FORM_trans_output(fw,txt)
   FORM_WIN fw;
   String txt;
{
   if (txt == NULL) {			/* Start of output		*/
    }
   else {
      if (fw->edit_info != NULL) {
	 EDTenable(fw->edit_info,TRUE);
	 EDTshell_output(fw->edit_info,txt);
	 EDTenable(fw->edit_info,FALSE);
       };
    };
};






/************************************************************************/
/*									*/
/*	form_trans_control -- handle control messages on window 	*/
/*									*/
/************************************************************************/


static int
form_trans_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   FORM_WIN fw;

   fw = FORM_find_window(w);
   if (fw == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      fw->text_win = NULL;
      fw->edit_info = NULL;
    };

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	form_trans_mouse -- handle mouse hits on window 		*/
/*									*/
/************************************************************************/


static void
form_trans_mouse(fw,btn,l,c,fl,fc,tl,tc)
   FORM_WIN fw;
   Integer btn;
   Integer l,c;
   Integer fl,fc;
   Integer tl,tc;
{
   String b;

   if (btn & RIP_BTN_LEFT) b = "LEFT";
   else if (btn & RIP_BTN_MID) b = "MID";
   else if (btn & RIP_BTN_RIGHT) b = "RIGHT";
   else b = "NONE";

   if (l == 0) {
      l = EDTcur_line(fw->edit_info);
      c = EDTcur_char(fw->edit_info);
    };


   FORM_msg_check_trans(fw,l,b);
};






/* end of forminfo.c */
