/************************************************************************/
/*									*/
/*		formsetup.c						*/
/*									*/
/*	Setup routines for FORM front end				*/
/*									*/
/************************************************************************/


#include "form_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_ENUMS		256



/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		load_attributes();





/************************************************************************/
/*									*/
/*	FORM_setup_init -- module initialization			*/
/*									*/
/************************************************************************/


void
FORM_setup_init()
{
};





/************************************************************************/
/*									*/
/*	FORM_setup_load -- load initial definitions			*/
/*									*/
/************************************************************************/


void
FORM_setup_load()
{
   load_attributes();
};





/************************************************************************/
/*									*/
/*	load_attributes -- get basic attribute definitions		*/
/*									*/
/************************************************************************/



static void
load_attributes()
{
   AUXD hdl,db;
   String nm,s;
   FORM_ATTR_CLASS cls;
   String enms[MAX_ENUMS];
   Integer i,ct;
   Float minv,maxv;
   Sequence vals;
   FORM_ATTR_TYPE typ;
   FORM_ATTR_VALUE val;
   Boolean ro;

   hdl = AUXDget_handle(NULL,"FORM");
   if (hdl == NULL) return;

   for (db = AUXDget_handle(hdl,"ATTR_TYPE"); db != NULL; db = AUXDnext_handle(db)) {
      nm = AUXDget_info(db,"NAME");
      if (nm == NULL) continue;
      s = AUXDget_info(db,"CLASS");
      if (s == NULL) s = nm;
      if (STREQL(s,"BOOLEAN") || STREQL(s,"Boolean")) cls = FORM_ATTR_CLASS_BOOLEAN;
      else if (STREQL(s,"INT") || STREQL(s,"int")) cls = FORM_ATTR_CLASS_INT;
      else if (STREQL(s,"STRING") || STREQL(s,"String")) cls = FORM_ATTR_CLASS_STRING;
      else if (STREQL(s,"ENUM") || STREQL(s,"enum")) cls = FORM_ATTR_CLASS_ENUM;
      else if (STREQL(s,"FLOAT") || STREQL(s,"float")) cls = FORM_ATTR_CLASS_FLOAT;
      else continue;
      if (cls == FORM_ATTR_CLASS_INT || cls == FORM_ATTR_CLASS_FLOAT) {
	 minv = AUXDget_info_real(db,"MIN");
	 maxv = AUXDget_info_real(db,"MAX");
       }
      else minv = maxv = 0.0;
      vals = NULL;
      if (cls == FORM_ATTR_CLASS_ENUM) {
	 ct = AUXDget_info_list(db,"VALUES",MAX_ENUMS,enms);
	 for (i = ct-1; i >= 0; --i) vals = CONS(enms[i],vals);
       };

      FORM_attr_define_type(nm,cls,vals,minv,maxv);
    };

   for (db = AUXDget_handle(hdl,"ATTR_ID"); db != NULL; db = AUXDnext_handle(db)) {
      nm = AUXDget_info(db,"NAME");
      s = AUXDget_info(db,"TYPE");
      typ = FORM_attr_find_type(s);
      if (typ == NULL) continue;
      if (!AUXDget_defined(db,"DEFAULT")) val = FORM_attr_value_null();
      else switch (typ->aclass) {
	 case FORM_ATTR_CLASS_BOOLEAN :
	    val = FORM_attr_value_boolean(AUXDget_info_int(db,"DEFAULT"));
	    break;
	 case FORM_ATTR_CLASS_INT :
	    val = FORM_attr_value_int(AUXDget_info_int(db,"DEFAULT"));
	    break;
	 case FORM_ATTR_CLASS_STRING :
	    val = FORM_attr_value_string(AUXDget_info(db,"DEFAULT"));
	    break;
	 case FORM_ATTR_CLASS_ENUM :
	    val = FORM_attr_value_enum(typ,AUXDget_info(db,"DEFAULT"));
	    break;
	 case FORM_ATTR_CLASS_FLOAT :
	    val = FORM_attr_value_float(typ,AUXDget_info_real(db,"DEFAULT"));
	    break;
       };
      ro = !AUXDget_defined(db,"SETABLE");
      FORM_attr_define_id(nm,s,val,ro);
    };
};





/* end of formsetup.c */
