/************************************************************************/
/*									*/
/*		fieldutil.c						*/
/*									*/
/*	Utility windows for FIELD					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "field_local.h"
#include <edt.h>



/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_systems;
static	String		cur_file;
static	String		cur_function;




/********************************************************************************/
/*										*/
/*	Forward definitions							*/
/*										*/
/********************************************************************************/


static	Integer 	build_wait_fct();
static	int		util_control_top();
static	int		util_control();
static	void		handle_system_msg();
static	void		handle_donesys_msg();
static	void		handle_focus_msg();




/************************************************************************/
/*									*/
/*	Leaf definitions for dual-window systems			*/
/*									*/
/************************************************************************/


#define TOP_WINDOW	1
#define BOT_WINDOW	2

static LEAF_DATA	dual_leaf[] = {
   LEAF_ROOT(NULL),
   { TOP_WINDOW, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_REL_SIZE(50), LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { BOT_WINDOW, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_BY, LEAF_COORD_RX, LEAF_COORD_NEXT_LINE(TOP_WINDOW) },
	NULL, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	FIELD_util_init -- module initialization			*/
/*									*/
/************************************************************************/


void
FIELD_util_init()
{
   all_systems = NULL;
   cur_file = NULL;
   cur_function = NULL;

   MSGregister("DEBUG SYSTEM %1s",handle_system_msg,1,NULL);
   MSGregister("DEBUG NEWSYS %1s %s",handle_donesys_msg,1,NULL);
   MSGregister("DEBUG FINISH %1s",handle_donesys_msg,1,NULL);
   MSGregister("DEBUG FOCUS %s %1s %2s %d",handle_focus_msg,2,NULL);
};






/************************************************************************/
/*									*/
/*	FIELDnew_shell_window -- new willow shell window		*/
/*									*/
/************************************************************************/


int
FIELDnew_shell_window(w)
   ASH_WINDOW w;
{
   ASHset_window_name(w,"Unix Shell");
   ASHset_window_id(w,"UnixShell");
   ASHset_window_defaults(w);

   EDTedit_shell(w);

   return TRUE;
};






/************************************************************************/
/*									*/
/*	FIELDset_wd -- set working directory				*/
/*									*/
/************************************************************************/


int
FIELDset_wd()
{
   Character nwd[128];
   String menu;
   Boolean fg;

   menu = "%CSet Working Directory\n\nNew: %0.48t\n\n   %a%M   %c";

   strcpy(nwd,MSGinq_wd());

   if (!STEMdialog1(ASHinq_top(),menu,nwd)) return FALSE;

   fg = MSGset_wd(nwd);

   return fg;
};





/************************************************************************/
/*									*/
/*	FIELDbuild -- handle build command				*/
/*									*/
/************************************************************************/


static	Integer 	build_wait_fct();


int
FIELDbuild()
{
   MSGcall("ANNOT RQST_SAVE *");

   STEMdialog1_wait(ASHinq_top(),build_wait_fct,"Building default system ...");
};






static Integer
build_wait_fct(w)
   ASH_WINDOW w;
{
   MSGcall("BUILD MAKE *");

   return 1;
};





/************************************************************************/
/*									*/
/*	FIELDxref_view -- xref+annotview window 			*/
/*									*/
/************************************************************************/


int
FIELDxref_view(w,id)
   ASH_WINDOW w;
   String id;
{
   ASH_WINDOW tw,bw;
   Boolean fg;

   LEAFsetup_window(w,dual_leaf,NULL);

   LEAFredraw(w);

   tw = LEAFinq_window(w,TOP_WINDOW,0);
   bw = LEAFinq_window(w,BOT_WINDOW,0);

   ASHset_control(tw,util_control_top);
   ASHset_control(bw,util_control);

   fg = XREFnew_window(tw,id);
   if (fg) fg = ANNOTnew_window(bw,"annotview",NULL);

   return fg;
};






/************************************************************************/
/*									*/
/*	FIELDdbg_view -- dbg+annotview window				*/
/*	FIELDdbg_tango -- dbg+annottango window 			*/
/*									*/
/************************************************************************/


int
FIELDdbg_view(w,typ,id,cid)
   ASH_WINDOW w;
   String typ;
   String id;
   String cid;
{
   ASH_WINDOW tw,bw;
   Boolean fg;
   extern int FORMinit();

   MSGservice_start("FORM",FORMinit,NULL,NULL);

   LEAFsetup_window(w,dual_leaf,NULL);

   LEAFredraw(w);

   tw = LEAFinq_window(w,TOP_WINDOW,0);
   bw = LEAFinq_window(w,BOT_WINDOW,0);

   ASHset_control(tw,util_control_top);
   ASHset_control(bw,util_control);

   fg = DBGnew_window(tw,typ,id,cid);
   if (fg) fg = ANNOTnew_window(bw,"annotddt",NULL);

   return fg;
};






int
FIELDdbg_tango(w,typ,id,cid)
   ASH_WINDOW w;
   String typ;
   String id;
   String cid;
{
   ASH_WINDOW tw,bw;
   Boolean fg;
   extern int FORMinit();

   MSGservice_start("FORM",FORMinit,NULL,NULL);

   LEAFsetup_window(w,dual_leaf,NULL);

   LEAFredraw(w);

   tw = LEAFinq_window(w,TOP_WINDOW,0);
   bw = LEAFinq_window(w,BOT_WINDOW,0);

   ASHset_control(tw,util_control_top);
   ASHset_control(bw,util_control);

   fg = DBGnew_window(tw,typ,id,cid);
   if (fg) fg = ANNOTnew_window(bw,"annottango",NULL);

   return fg;
};






/************************************************************************/
/*									*/
/*	FIELDmemory_info -- print information on memory usage		*/
/*									*/
/************************************************************************/


int
FIELDmemory_info()
{
   Function_Ptr rtn;

   rtn = (Function_Ptr) DLlookup("mallocmap");
   if (rtn != NULL) (*rtn)("FIELD");

   rtn = (Function_Ptr) DLlookup("_mstats");
   if (rtn != NULL) (*rtn)("FIELD");

   return 0;
};





/************************************************************************/
/*									*/
/*	FIELDinq_systems -- return set of known systems 		*/
/*									*/
/************************************************************************/


int
FIELDinq_systems(max,sys)
   Integer max;
   String sys[];
{
   Sequence l;
   Integer ct;
   String s;

   ct = 0;
   forin (s,String,l,all_systems) {
      if (ct >= max) break;
      sys[ct++] = s;
    };

   return ct;
};






/************************************************************************/
/*									*/
/*	FIELDsystem_match -- check for match of system names		*/
/*									*/
/************************************************************************/


int
FIELDsystem_match(name,sys)
   String name;
   String sys;
{
   String s,p;

   if (sys != NULL && (sys[0] == 0 || STREQL(sys,"*"))) sys = NULL;
   if (name != NULL && (name[0] == 0 || STREQL(name,"*"))) name = NULL;

   if (name == NULL || sys == NULL) return TRUE;

   s = sys;
   p = name;

   for ( ; ; ) {
      while (*s != 0 && *s != '^') {
	 if (*p++ != *s++) return FALSE;
       };

      if (*s == 0 || *p == 0) break;
      if (*s++ != *p++) return FALSE;
    };

   return TRUE;
};






/************************************************************************/
/*									*/
/*	FIELDsystem_request -- request system from user 		*/
/*									*/
/************************************************************************/


int
FIELDsystem_request(w,whom,sys)
   ASH_WINDOW w;
   String whom;
   Character sys[];
{
   Character buf[10240],buf1[1024];
   String nms[16];
   String s;
   Integer i,ct,idx;

   sprintf(buf,"%%CSystem for %s\n\n",whom);

   strcat(buf,"Name: %0.48t\n\n");

   ct = FIELDinq_systems(16,nms);
   idx = -1;

   for (i = 0; i < ct; ++i) {
      sprintf(buf1,"   %%1.%do %s\n",i+1,nms[i]);
      strcat(buf,buf1);
      if (STREQL(nms[i],sys)) {
	 idx = i+1;
	 sys[0] = 0;
       };
    };
   if (i > 0) strcat(buf,"\n");

   strcat(buf,"   %1.0o All systems\n\n");

   strcat(buf,"   %a%M   %c");

   strcpy(buf1,sys);
   if (STREQL(buf1,"*")) buf1[0] = 0;
   if (idx < 0) {
      if (buf1[0] == 0) idx = 0;
      else idx = ct+1;
    };

   if (!STEMdialog1(w,buf,buf1,&idx)) return FALSE;

   s = buf1;
   while (*s != 0 && isspace(*s)) ++s;

   if (s[0] != 0 && (idx > ct || STRNEQ(buf1,sys))) {
      strcpy(sys,s);
    }
   else if (idx > ct) return FALSE;
   else if (idx == 0) strcpy(sys,"");
   else strcpy(sys,nms[idx-1]);

   return TRUE;
};






/************************************************************************/
/*									*/
/*	FIELDinq_selection -- get name from current edit selection	*/
/*	FIELDinq_function -- get name of current focus function 	*/
/*	FIELDinq_file -- get name of current focus file 		*/
/*									*/
/************************************************************************/


char *
FIELDinq_selection(buf)
   String buf;
{
   String s,t,s0;
   Integer i;

   s0 = EDTinq_selection(NULL);

   if (s0 != NULL) {
      s = s0;
      while (isspace(*s)) ++s;
      if (*s == '"' || *s == '\'') {
	 i = strlen(s);
	 t = &s[i-1];
	 while (*t != *s) --t;
	 t[1] = 0;
       }
      else {
	 t = s;
	 while (isalnum(*t) || *t == '_' || *t == '$') ++t;
	 *t = 0;
       };
      if (t == s) t = NULL;
      else t = s;
      free(s0);
    }
   else t = NULL;

   if (t == NULL) buf[0] = 0;
   else {
      strcpy(buf,t);
      t = buf;
    };

   return t;
};





char *
FIELDinq_function(buf)
   String buf;
{
   if (cur_function == NULL) {
      buf[0] = 0;
      buf = NULL;
    }
   else strcpy(buf,cur_function);

   return buf;
};





char *
FIELDinq_file(buf)
   String buf;
{
   String s;

   if (cur_file == NULL) {
      buf[0] = 0;
      buf = NULL;
    }
   else {
      s = rindex(cur_file,'/');
      if (s == NULL) s = cur_file;
      else ++s;
      strcpy(buf,s);
    };

   return buf;
};





/********************************************************************************/
/*										*/
/*	util_control_top -- handle control message for utility top sub window	*/
/*	util_control -- handle control message for utility sub windows		*/
/*										*/
/********************************************************************************/


static int
util_control_top(msg,w)
   String msg;
   ASH_WINDOW w;
{
   Character buf[1024];
   String s,t;

   if (STREQL(msg,"ASH$TITLE")) {
      s = ASHinq_window_name(w);
      t = buf;
      while (*s != 0 && *s != ':') *t++ = *s++;
      *t = 0;
      if (*s == ':') {
	 strcat(t,"view");
	 strcat(t,s);
       };
      ASHset_window_name(ASHinq_parent(w),buf);
    }
   else return util_control(msg,w);

   return ASH_CONTROL_REJECT;
};






static int
util_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   ASH_WINDOW p;

   if (STREQL(msg,"ASH$REMOVE")) {
      p = ASHinq_parent(w);
      if (ASHinq_valid_window(p)) ASHremove(p);
    };

   return ASH_CONTROL_REJECT;
};






/************************************************************************/
/*									*/
/*	handle_system_msg -- handle messages defining a new system	*/
/*	handle_donesys_msg -- handle messages changing systems		 */
/*									*/
/************************************************************************/


static void
handle_system_msg(sys,rid)
   String sys;
   Integer rid;
{
   Sequence l;
   String s;

   if (rid >= 0) MSGreply(rid,NULL);

   forin (s,String,l,all_systems) {
      if (STREQL(sys,s)) break;
    };

   if (s == NULL) all_systems = APPEND(SALLOC(sys),all_systems);
};





static void
handle_donesys_msg(sys,rid)
   String sys;
   Integer rid;
{
   Sequence l;
   String s;

   if (rid >= 0) MSGreply(rid,NULL);

   forin (s,String,l,all_systems) {
      if (STREQL(sys,s)) {
	 all_systems = REMOB(s,all_systems);
	 break;
       };
    };
};





/************************************************************************/
/*									*/
/*	handle_focus_msg -- handle focus messages from debuggers	*/
/*									*/
/************************************************************************/


static void
handle_focus_msg(fil,fun,rid)
   String fil;
   String fun;
   Integer rid;
{
   if (rid >= 0) MSGreply(rid,NULL);

   if (cur_file != NULL) SFREE(cur_file);
   if (fil == NULL || fil[0] == 0 || STREQL(fil,"*")) cur_file = NULL;
   else cur_file = SALLOC(fil);

   if (cur_function != NULL) SFREE(cur_function);
   if (fun == NULL || fun[0] == 0 || STREQL(fun,"*")) cur_function = NULL;
   else cur_function = SALLOC(fun);
};





/* end of fieldutil.c */
