/************************************************************************/
/*									*/
/*		fielduser.c						*/
/*									*/
/*	Routines for handling FIELD user I/O window			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "field_local.h"
#include <sys/file.h>
#include <sgtty.h>



/********************************************************************************/
/*										*/
/*	Local storage								*/
/*										*/
/********************************************************************************/


static	ASH_WINDOW	user_window;
static	String		user_system;
static	Character	user_pty[64];




/********************************************************************************/
/*										*/
/*	Forward definitions							*/
/*										*/
/********************************************************************************/


static	int		field_user_control();
static	void		field_user_system();
static	void		field_user_start();
static	void		field_user_stop();





/********************************************************************************/
/*										*/
/*	FIELD_user_init -- module initialization				*/
/*										*/
/********************************************************************************/


void
FIELD_user_init()
{
   user_window = NULL;
   user_system = NULL;
   MSGregister("DEBUG START %1s",field_user_start,1,NULL);
   MSGregister("DEBUG STOP %1s %d %2s",field_user_stop,2,NULL);
   MSGregister("DEBUG SYSTEM %1s",field_user_system,1,NULL);
};





/************************************************************************/
/*									*/
/*	FIELDnew_user_output -- user output window			*/
/*									*/
/************************************************************************/


int
FIELDnew_user_output(w)
   ASH_WINDOW w;
{
   if (user_window != NULL) return FALSE;

   ASHset_window_name(w,"Input/Output Window");
   ASHset_window_id(w,"userio");
   ASHset_window_defaults(w);

   ASHset_control(w,field_user_control);
   user_window = w;
   user_system = NULL;

   EDTedit_pty(w,user_pty);

   MSGsenda("DDT SET * USER_TTY %s",user_pty);

   return TRUE;
};





/********************************************************************************/
/*										*/
/*	FIELDinq_user_tty -- return tty name of user_pty			*/
/*										*/
/********************************************************************************/


char *
FIELDinq_user_tty()
{
   return user_pty;
};





/********************************************************************************/
/*										*/
/*	field_user_control -- handle ASH control messages			*/
/*										*/
/********************************************************************************/


static int
field_user_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   if (w != user_window) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      MSGsenda("DDT SET * USER_TTY *");
      user_window = NULL;
      user_system = NULL;
      user_pty[0] = 0;
    };

   return ASH_CONTROL_REJECT;
};





/********************************************************************************/
/*										*/
/*	field_user_system -- handle DDT SYSTEM message				*/
/*										*/
/********************************************************************************/


/*ARGSUSED*/

static void
field_user_system(sys)
   String sys;
{
   if (user_window != NULL) {
      if (user_system == NULL) user_system = SALLOC(sys);
      if (STREQL(user_system,sys)) {
	 MSGsenda("DDT SET %s USER_TTY %s",sys,user_pty);
       };
    };
};





/********************************************************************************/
/*										*/
/*	field_user_start -- handle DDT START messages				*/
/*	field_user_stop -- handle DDT STOP messages				*/
/*										*/
/********************************************************************************/


static void
field_user_start(sys,rid)
   String sys;
   Integer rid;
{
   FILE * fid;
   Integer arg;

   if (user_window != NULL) {
      fid = fopen(user_pty,"w");
      if (fid != NULL) {
	 arg = 0;
	 ioctl(fileno(fid),TIOCFLUSH,&arg);
	 fprintf(fid,"\n---------------------------------------------------\n");
	 fprintf(fid,"---   %s\n",sys);
	 fprintf(fid,"---------------------------------------------------\n");
	 fclose(fid);
       };
    };

   MSGreply(rid,NULL);
};





static void
field_user_stop(sys,sts,rid)
   String sys;
   String sts;
   Integer rid;
{
   FILE * fid;

   if (user_window != NULL) {
      fid = fopen(user_pty,"w");
      if (fid != NULL) {
	 fprintf(fid,"\n---------------------------------------------------\n");
	 if (STREQL(sts,"OK")) {
	    fprintf(fid,"---   %s: execution completed\n",sys);
	  }
	 else {
	    fprintf(fid,"---   %s: program terminated with %s\n",sys,sts);
	  };
	 fprintf(fid,"---------------------------------------------------\n\n");
	 fclose(fid);
       };
    };

   MSGreply(rid,NULL);
};





/* end of fielduser.c */
