/************************************************************************/
/*									*/
/*		fieldmain.c						*/
/*									*/
/*	Main program (WIND entry) for FIELD system			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "field_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define CONTROL_WIDTH		512
#define CONTROL_HEIGHT		200

#define THREAD_INTERVAL_SEC	0
#define THREAD_INTERVAL_USEC	200000

#define MAX_WINDOWS		64
#define MAX_COMMANDS		32





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		fieldmain();
static	void		main_prog();
static	void		mainloop();
static	int		main_control();
static	void		error_exit();
static	void		setup_auxd();
static	void		auxd_command();
static	void		key_activate();





/************************************************************************/
/*									*/
/*	Main program							*/
/*									*/
/************************************************************************/


typedef struct _args { Integer cnt; String *args; };


void
main(argc,argv)
   Integer argc;
   String argv[];
{
   struct _args A;
   Boolean thfg;
   Integer i;

   A.cnt = argc;
   A.args = argv;

   thfg = FALSE;
   for (i = 1; i < argc; ++i) {
      if (strncmp(argv[i],"-T",2) == 0) thfg = TRUE;
    };

   if (thfg) {
      BWEthread_begin(THREAD_PRIORITY,0,0,0,main_prog,&A);
    };

   main_prog(&A);

   exit(0);
};






static void
main_prog(A)
   struct _args *A;
{
   Integer argc;
   String *argv;
   Integer i;
   String file,file2;
   String innm,otnm,auxdnm;
   Character buf[128];
   Integer stksz,prior;
   Boolean msgdbg,thfg;
   String s,s1;

   wait3(0,1,0);		/* avoid loader problems on sun4 */

   argc = A->cnt;
   argv = A->args;
   stksz = THREAD_STACK_SIZE;
   prior = THREAD_PRIORITY;

   file = NULL;
   file2 = NULL;
   innm = NULL;
   otnm = NULL;
   msgdbg = FALSE;
   thfg = FALSE;
   auxdnm = NULL;

   s = getenv("FIELD_DIR");
#ifdef FIELD_DIRECTORY
   if (s == NULL) s = FIELD_DIRECTORY;
#endif
   if (s != NULL) BWEset_local_project(s);

   if (STRNEQ(getenv("USER"),"spr")) {
      signal(SIGINT,SIG_IGN);
      signal(SIGQUIT,SIG_IGN);
    };

   MSGrundata_name("fieldrc",buf);
   ASHresource_file(buf,FALSE);

   s = getenv("FIELDRC");
   if (s != NULL) ASHresource_file(s,TRUE);

   sprintf(buf,"%s/.fieldrc",getenv("HOME"));
   ASHresource_file(buf,TRUE);

   sprintf(buf,".fieldrc");
   ASHresource_file(buf,TRUE);

   for (i = 1; i < argc; ++i) {
      if (STREQL(argv[i],"-t")) argv[i] = "-totranscript";
      else if (STREQL(argv[i],"-f")) argv[i] = "-fromtranscript";
      else if (STREQL(argv[i],"-s")) argv[i] = "-stacksize";
      else if (STREQL(argv[i],"-p")) argv[i] = "-priority";
      else if (STREQL(argv[i],"-a")) argv[i] = "-auxd";
    };

   argc = MSGset_application(argc,argv);
   argc = ASHset_application(argc,argv);

   for (i = 1; i < argc; ++i) {
      if (argv[i][0] != '-') {
	 if (file == NULL) file = argv[i];
	 else if (file2 == NULL) file2 = argv[i];
	 else error_exit("Can't specify multiple systems");
       }
      else {
	 switch (argv[i][1]) {
	    default :
	    case 'h' :
	       printf("field [-a file] [-t file] [-f file] [system]\n");
	       exit(0);
	       break;

	    case 'T':           /* USE THREADS          */
	       thfg = TRUE;
	       break;

	    case 't' :          /* To transcript file   */
	       if (++i >= argc) {
		  error_exit("No file name for transcript");
		  exit(1);
		};
	       otnm = argv[i];
	       break;

	    case 'f' :          /* From transcript file */
	       if (++i >= argc) {
		  error_exit("No file name for form transcript");
		  exit(1);
		};
	       innm = argv[i];
	       break;

	    case 'a' :          /* Auxd file            */
	       if (++i >= argc) {
		  error_exit("No file name for auxd");
		  exit(1);
		};
	       auxdnm = argv[i];
	       break;

	    case 's' :          /* stack size           */
	       if (++i >= argc) {
		  error_exit("No size for stack size");
		  exit(1);
		};
	       stksz = atol(argv[i]);
	       if (stksz <= 0) stksz = THREAD_STACK_SIZE;
	       else stksz = stksz*1024-400;
	       break;

	    case 'p' :          /* priority             */
	       if (++i >= argc) {
		  error_exit("No value for priority");
		  exit(1);
		};
	       prior = atol(argv[i]);
	       if (prior <= 0) prior = THREAD_PRIORITY;
	       else if (prior >= 32) prior = 31;
	       break;

	    case 'D' :
	       if (argv[i][2] == 'M' || argv[i][2] == 0) msgdbg = TRUE;
	       break;
	     };
       };
    };

   s1 = ASHinq_resource("name");
   if (s1 == NULL) s1 = argv[0];
   s = rindex(s1,'/');
   if (s == NULL) s = s1;
   else ++s;
   s = SALLOC(s);

   setup_auxd(auxdnm,s);

   ASHinit(ASH_MODE_INQUIRE);

   if (innm != NULL) BIOinput_transcript(innm);
   if (otnm != NULL) BIOtranscript(otnm);

   WINDthread_stack_size(stksz);
   WINDthread_priority(prior);

   EDTstartup();

   RIPinit();
   BIOset_cursor_standard(NULL,ASH_CURSOR_SMALL_GLASSES);
   BIOset_cursor(NULL,TRUE);

   MSGinit(msgdbg);

   MSGwait_fct(RIPidler);

   FIELD_user_init();
   FIELD_util_init();

   sprintf(buf,"%s/lib/field/help",BWElocal_project());
   if (access(buf,0) < 0) {
      sprintf(buf,"%s/field/help",BWElocal_project());
    };
   HELPsetup("field",buf);

   if (thfg) THREADstartclock(THREAD_INTERVAL_SEC,THREAD_INTERVAL_USEC);

   FIELD_auxd_services();
   FIELD_auxd_windows();

   auxd_command(s,file,file2);

   mainloop();

#ifdef USE_DYNLOAD_WITH_SHARED_LIBS
   WINDexit(0); 			/* put calls somewhere for dynload	*/
   HELPnew_window(NULL);
   HELPnew_mouse_window(NULL);
   HELPnew_window_on(NULL);
#endif
};






/************************************************************************/
/*									*/
/*	fieldmain -- main code for top field window			*/
/*									*/
/************************************************************************/


static void
fieldmain(file,file2)
   String file;
   String file2;
{
   ASH_WINDOW w;
   String s;
   Character buf[1024];

   w = ASHinq_top();

   ASHset_window_id(w,"field");

   if (!WINDdraw_window(w)) exit(1);

   if (file != NULL) {
      s = rindex(file,'.');
      if (s != NULL && (STREQL(s,".c") || STREQL(s,".p") || STREQL(s,".h"))) {
	 if (file2 != NULL) error_exit("Can't specify multiple systems");
	 WINDactivate("ANNOT",file,NULL);
       }
      else {
	 if (file2 != NULL) {
	    sprintf(buf,"dbg %s %s",file,file2);
	  }
	 else {
	    sprintf(buf,"dbg %s",file);
	  };
	 WINDactivate("dbg",buf,NULL);
	 WINDactivate("annotddt",NULL,NULL);
       };
    };
};






/************************************************************************/
/*									*/
/*	mainloop -- main loop of pds -- get input and process		*/
/*	main_control -- handle control messages for top window		*/
/*									*/
/************************************************************************/


static void
mainloop()
{
   ASH_WINDOW w;

   w = ASHinq_top();
   ASHset_control(w,main_control);

   for ( ; ; ) {
      RIPuser_pick(NULL);
    };
};





/*ARGSUSED*/

static int
main_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   if (STREQL(msg,"ASH$REMOVE")) exit(0);

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	error_exit -- exit with an error message			*/
/*									*/
/************************************************************************/


static void
error_exit(msg)
   String msg;
{
   printf("%s.\n",msg);

   exit(1);
};





/************************************************************************/
/*									*/
/*	setup_auxd -- handle reading and using AUXD file for field	*/
/*	auxd_command -- handle commands from AUXD specifications	*/
/*	FIELD_auxd_services -- startup services specified by AUXD file	*/
/*	FIELD_auxd_windows -- handle windo definitions from AUXD specs	*/
/*									*/
/************************************************************************/


static void
setup_auxd(auxdnm,sys)
   String auxdnm;
   String sys;
{
   Character buf[256],buf1[256];
   AUXD hdl,h1;
   String s1,s2;
   Function_Ptr fp;

   MSGrundata_name("field_data.auxd",buf);
   AUXDuse(buf);

   if (auxdnm == NULL) {
      strcpy(buf1,sys);
      for (s1 = buf1; *s1 != 0; ++s1) if (islower(*s1)) *s1 = toupper(*s1);
      strcat(buf1,".AUXD");
      auxdnm = getenv(buf1);
    };

   if (auxdnm == NULL) {
      sprintf(buf,"%s/.%s.auxd",getenv("HOME"),sys);
      if (access(buf,4) < 0) {
	 sprintf(buf,"%s/.field.auxd",getenv("HOME"));
	 if (access(buf,4) < 0) {
	    sprintf(buf1,"%s.auxd",sys);
	    MSGrundata_name(buf1,buf);
	    if (access(buf,4) < 0) MSGrundata_name("field.auxd",buf);
	  };
       };
      auxdnm = buf;
    };
   AUXDuse(auxdnm);

   hdl = AUXDget_handle(NULL,"FIELD");
   if (hdl == NULL) return;

   for (h1 = AUXDget_handle(hdl,"USE"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
      s1 = AUXDget_info(h1,"NAME");
      s2 = AUXDget_info(h1,"ENVIRON");
      if (s2 != NULL) s2 = getenv(s2);
      if (s2 == NULL) {
	 if (s1 == NULL || s1[0] == '/') s2 = s1;
	 else if (access(s1,4) >= 0) s2 = s1;
	 else {
	    MSGrundata_name(s1,buf1);
	    s2 = buf1;
	  };
       }
      if (s2 != NULL) AUXDuse(s2);
    };

   for (h1 = AUXDget_handle(hdl,"SETENV"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
      s1 = AUXDget_info(h1,"NAME");
      if (s1 == NULL) continue;
      s2 = AUXDget_info(h1,"VALUE");
      if (s2 == NULL) s2 = "";
      if (AUXDget_defined(h1,"IFNDEF") && getenv(s1) != NULL) continue;
      if (s2[0] == '~') sprintf(buf1,"%s=%s%s",s1,getenv("HOME"),&s2[1]);
      else sprintf(buf1,"%s=%s",s1,s2);
      s1 = SALLOC(buf1);
      putenv(s1);
    };

   for (h1 = AUXDget_handle(hdl,"LOAD"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
      s1 = AUXDget_info(h1,"FILE");
      if (s1 == NULL) continue;
      if (access(s1,4) < 0) s1 = MSGrundata_name(s1,buf1);
      if (s1 != NULL && !DLload(s1)) continue;
      s2 = AUXDget_info(h1,"CALL");
      if (s2 != NULL) {
	 fp = (Function_Ptr) DLlookup(s2);
	 if (fp != NULL) (*fp)();
       };
     };
};





static void
auxd_command(sys,file,file2)
   String sys;
   String file;
   String file2;
{
   AUXD hdl,h1;
   String s1,s2;
   Function_Ptr fp;
   Boolean fg;
   ASH_WINDOW w;

   hdl = AUXDget_handle(NULL,"FIELD");

   if (hdl != NULL) {
      for (h1 = AUXDget_handle(hdl,"COMMAND"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
	 s1 = AUXDget_info(h1,"NAME");
	 if (STREQL(sys,s1)) {
	    if (file2 != NULL && !AUXDget_defined(h1,"TWOARG")) {
	       error_exit("Can't specify multiple systems");
	     };
	    s2 = AUXDget_info(h1,"CALL");
	    if (s2 == NULL) continue;
	    fp = (Function_Ptr) DLlookup(s2);
	    if (fp == NULL) continue;
	    s2 = AUXDget_info(h1,"DATA");
	    w = ASHinq_top();
	    if (!AUXDget_defined(h1,"NOSETUP")) w = WINDsetup(w);
	    if (w == NULL) error_exit("Window too small");
	    if (s2 != NULL) {
	       fg = (*fp)(w,s2,file,file2);
	     }
	    else {
	       fg = (*fp)(w,file,file2);
	     };
	    if (!fg) exit(0);
	    ASHvisible(w,TRUE);
	    break;
	  };
       };
    };

   if (hdl == NULL || h1 == NULL) {
      fieldmain(file,file2);
    };
};






void
FIELD_auxd_services()
{
   AUXD hdl,h1;
   String info[64];
   Integer ct;
   String s1,s2;
   Function_Ptr fp;

   hdl = AUXDget_handle(NULL,"FIELD");
   if (hdl == NULL) return;

   for (h1 = AUXDget_handle(hdl,"SERVICE"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
      s1 = AUXDget_info(h1,"NAME");
      if (s1 == NULL) continue;
      s2 = AUXDget_info(h1,"CALL");
      if (s2 == NULL) {
	 fp = NULL;
	 s2 = AUXDget_info(h1,"SYSTEM");
	 if (s2 == NULL) continue;
	 ct = AUXDget_info_list(h1,"ARGS",63,info);
	 info[ct] = NULL;
       }
      else {
	 fp = (Function_Ptr) DLlookup(s2);
	 if (fp == NULL) continue;
	 s2 = NULL;
	 info[0] = NULL;
       };
      MSGservice_start(s1,fp,s2,info);
    };
};






void
FIELD_auxd_windows()
{
   AUXD hdl,h1;
   String s1,s2,s3,s4;
   Function_Ptr fp;
   Integer i;
   WIND_DEF_INFO wdef;
   Character buf[256];

   hdl = AUXDget_handle(NULL,"FIELD");

   if (hdl != NULL) {
      for (h1 = AUXDget_handle(hdl,"BUTTON"); h1 != NULL; h1 = AUXDnext_handle(h1)) {
	 s4 = AUXDget_info(h1,"NAME");
	 if (s4 == NULL) continue;
	 s2 = AUXDget_info(h1,"ICON_CHAR");
	 if (s2 != NULL) {
	    s3 = AUXDget_info(h1,"ICON_FONT");
	    if (s3 == NULL) s3 = "old_english.36";
	    sprintf(buf,"%s@%s@%s",s4,s2,s3);
	  }
	 else {
	    s2 = AUXDget_info(h1,"MENU");
	    if (s2 != NULL) sprintf(buf,"%s^%s",s4,s2);
	    else strcpy(buf,s4);
	  };
	 wdef.name = SALLOC(buf);

	 s1 = AUXDget_info(h1,"CALL");
	 if (s1 == NULL) fp = NULL;
	 else fp = (Function_Ptr) DLlookup(s1);
	 wdef.rtn = fp;

	 s1 = AUXDget_info(h1,"KEY");
	 if (s1 != NULL) {
	    for (i = 1; i < FKEY_MOUSE_FIRST; ++i) {
	       if (i == ' ') i = 0177;          /* SKIP standard chars  */
	       if (STREQL(s1,BIO__key_names[i])) {
		  if (FKEY_TEST_UP(i)) break;
		  BIOset_mapping(NULL,i,BIO_MAP_ACTION,key_activate,s4);
		  if (FKEY_TEST(i)) {
		     i = (i - FKEY_FIRST) % FKEY_COUNT;
		     i = FKEY_UP(i);
		     BIOset_mapping(NULL,i,BIO_MAP_NONE,NULL,NULL);
		   };
		  break;
	       };
	     };
	  };

	 wdef.action = AUXDget_info(h1,"ACTION");
	 wdef.unique = AUXDget_defined(h1,"UNIQUE");
	 wdef.nogeneric = AUXDget_defined(h1,"NOGENERIC");
	 wdef.usethreads = ! AUXDget_defined(h1,"NOTHREADS");
	 wdef.nowindow = AUXDget_defined(h1,"NOWINDOW");

	 WINDdefine(&wdef);
       };
    };
};






/************************************************************************/
/*									*/
/*	key_activate -- handle keystroke commands			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
key_activate(data,w,x,y)
   String data;
   ASH_WINDOW w;
   Integer x,y;
{
   WINDactivate(data,NULL,NULL);
};





/* end of fieldmain.c */
