.fo 'FIELD'- % -'Integration Mechanisms'
.po +0.5i
.ll 6.5i
.tp
.EQ
delim !!
.EN
.]-
.ds <. .
.ds <, ,
.sp 1i
.(l C
.sz +2
.sz +2
.ft B
Connecting Tools using Message Passing
in the
FIELD Program Development Environment\(dg
.ft
.sz
.(f
\(dg This research was supported in part by grants from Defence Advanced
Research
Projects Agency, the National Science Foundation, and the Digital Equipment
Corporation.  Equipment support was provided by the National Science
Foundation.
.)f
.sp 1
.b "Steven P. Reiss"
.sp 1
Department of Computer Science
Brown University
Providence, RI 02912
.sp 1
February, 1989
.sz
.)l
.sp 1i
.(l C
.sz +2
.b "Abstract"
.sz
.)l
.pp
.sz +2
Selective broadcasting is a mechanism that allows a wide variety of
programming tools to be combined in an integrated environment.  It follows the
UNIX
philosophy of allowing independent tools to easily cooperate though simple
conventions
while at the same time providing the functionality necessary to a complex
programming
environment.  In the FIELD program development environment, selective
broadcasting
is combined with an annotation editor that allows consistent,
multi-function access to
source files.  FIELD
demonstrates the power and capabilities of these mechanisms. The environment is
currently being used for both instruction and research at Brown University.
.sp
.lp
Keywords:  Programming environments, integration mechanisms, message passing,
tools.
.bp
.sz
.ps 11p
.nr pp 11
.nr sp 11
.(l C
.sz +2
.ft B
Connecting Tools using Message Passing
in the
FIELD Program Development Environment
.ft
.sz
.sp 1
.b "Steven P. Reiss"
.)l
.sp 2
.ls 2
.sh 1 "Introduction"
.pp
Workstations have been generally available for five years.  They offer a host
of graphical capabilities, powerful processors, and mouse-based input, and
can be used to support powerful integrated environments based on
graphically oriented tools.
However, workstation programming in classical languages, e.g. C or Pascal, is
still done
using collections of unintegrated tools.
.pp
In two arenas, however, this is not the case.  The first is special-purpose,
controlled environments for languages such as Lisp or Smalltalk.  Here, where
the whole
system is based on a single, semi-interpretive language, a variety of
graphically oriented environments have been produced.  Most of this work,
however, is
specific to the underlying languages and does not apply to general programming
in more
common languages such as C or Pascal.
.pp
The other exception occurs on personal computers where simple but powerful
programming
environments for traditional languages have
blossomed.  Manufacturers and software companies
have understood the potential for using mouse input and graphical output to
aid the programmer.  Integrated environments such as Lightspeed Pascal
.[
lightspeed pascal reference manual
.]
provide a powerful framework for teaching programming and for writing
and debugging simple Pascal programs.  Such environments, however, are highly
integrated and are suitable only for small programs.
.pp
The FIELD project was started as an effort to show that highly
integrated, interactive environments like those on personal machines can be
implemented on workstations for classical languages and large-scale
programming.  At
the same time, we wanted to show that the
more advanced capabilities of workstations can be used to attain a more
productive and powerful environment by providing functionality not found on
personal machines or in standard software engineering environments.
.pp
FIELD was designed to accomplish these ends and at the same time to provide a
production
environment for both research and instructional programming at Brown.  To make
the environment operational as soon as possible and to ensure that it could be
maintained
and would work in an educational environment, the system was designed to be
simple and
inexpensive.  We made use of existing tools wherever possible:
standard UNIX tools, workstation software developed at Brown, and other
available
tools and software.  At the same time, the system attempts to provide a
testbed environment in which new tools such as program animation systems can
be easily
incorporated.
.pp
All these goals were accomplished in FIELD by providing a consistent graphical
front end
and a simple integration framework that allows existing and new UNIX tools to
cooperate.
The front end is based on an updated version of the set of tools called the
Brown
Workstation Environment.
.[
pato reiss brown environment for workstations software tools
.]
This includes a variety of input interfaces including static, pull-down and
pop-up
menus, dialog boxes and scroll bars; a powerful and extensible base editor; a
geometry package; drawing packages including one for the automatic layout and
display
of structured diagrams; an integrated help facility; and an application
window manager.
.pp
The integration framework,
a principal contribution of the FIELD system,
allows a wide variety of tools to
be tied together with minimum effort.  It combines a communications mechanism
that we
call \fIselective broadcasting\fP,
with an annotation editor that provides consistent access to
the source in multiple contexts and with a set of specialized interactive
analysis tools.
In selective broadcasting all tools talk to
a central message server.  Each tool registers a set of patterns with the
server.  Tools
communicate by sending messages to the server and receiving those messages
that match their
registered patterns.
This approach is easy to implement and to extend.  It
offers several advantages over the more
traditional integration mechanisms involving program databases or a single,
massive
system.  The FIELD system demonstrates that this simpler approach is both
feasible and
desirable.
.pp
This paper describes the integration framework used in FIELD.
Section 2 gives an overview of FIELD.
Section 3 describes the integration mechanism.
Section 4 describes the message facility that serves as a basis for
integration.
Section 5 describes related research.
Section 6 describes the current status and our future plans.
.sh 1 "Overview of FIELD"
.pp
FIELD is being developed to serve three purposes: to be the principal
programming
environment
for teaching undergraduates, a programming environment for research, and a
testbed
for developing new tools for programming environments.  The first use requires
that the
environment be
.q "user-friendly" .
The second requires that the environment handle moderate-sized (100,000-line)
systems that span multiple files in multiple directories.  The third requires
that
the environment be flexible and easily extensible.
.pp
These goals are achieved by offering a rich set of tools based on the UNIX
programming
environment, by providing a common graphics-oriented front end to all these
tools, and by
developing an
integration mechanism that allows these tools to cooperate and makes it easy
to add
new tools to the system.  In developing the tools, we used existing
tools wherever possible and integrated them into our framework by providing a
reasonable
front end and an
interface to the rest of the environment.  The front ends are based on the
current version
of the Brown Workstation Environment.
.pp
The tools chosen to be part of the initial version of FIELD come both from
existing UNIX tools and from software developed at Brown for other research
projects.  Below we describe the current set of FIELD tools:
.ls 1
.sp
.ip "\fIAnnotation Editor\fP"
This is a full-functioned, mouse-oriented, extensible editor with knowledge of
C and
Pascal syntax
for program and other editing.  It is augmented with an annotation window that
allows
arbitrary annotations to be associated with each line of the file.  The user
can create,
remove and query annotations through the editor.  Annotations are used by
FIELD to relate the program source to all other aspects of the
programming
environment.  FIELD allows multiple annotation editors to be active at one
time, allowing multiple files to be viewed and annotated simultaneously.
.ip "\fICross-Referencer\fP"
This program collects a relational database of information about a system.
The system can
be specified either as a set
of source files, a binary file, or as a directory hierarchy.  Access to the
database is
provided through a relational calculus query language.  Current relations
include references (name,file,line,assignment), declarations
(name,scope,file,type,class,line), calls (from,call,file,line), functions
(name,file,line,scope,argct,args), files (name),
and scopes (class,start_line,end_line,file).
.ip "\fICross-Reference Interface\fP"
This offers a menu-oriented interface to the cross-referencer, allowing most
simple
queries to be made by filling in a dialog box.  It also integrates the
cross-referencer into the remainder of the system by allowing the user to
select a listed
reference to look at in an editor and by handling cross-reference queries from
other tools.
Editors can use this facility to provide commands based on the program
contents such as
find and display the declaration of this procedure.  The debugger can use this
to provide
high-level commands such as set breakpoints at all assignments to this
variable.
.ip "\fIData Structure Display\fP"
The data structure display facilities of the GARDEN environment
.[
reiss pato displaying program and data structures
.]
have been incorporated
into FIELD as a pair of tools.  The first tool displays an user data
structure
graphically, allowing the user to pan and zoom over the display and to
selectively show
more or less detail.  The second tool allows users to describe quickly how the
data structure should be displayed by the first tool.  These two tools allow
displays of complex user data structures that are similar to the diagrams that
the
programmer would draw.
.ip "\fIDebugger\fP"
This is an interface to the system debugger (e.g. dbx on a Sun).  It provides
an extended
dbx-like user interface as well as an internal, message-based interface for
other tools in
the environment.  The use of a separate debugger interface allows FIELD to be
more easily
ported to other systems, to provide a consistent debugger language across
systems, and to
allow new commands to be more easily incorporated into the debugger.  The use
of a message
interface allows different, machine-independent debugging languages to be
incorporated
into
the system at a later date.  Multiple debuggers can be run on separate
user processes
simultaneously within a single FIELD environment.
.ip "\fIDebugger Interface\fP"
This is a graphical, button-oriented front end to the debugger.  It allows
new buttons
to be easily created and used to represent common debugger commands.  It
provides a
full transcript of the debugging
session.
Program input and output can be displayed here or in a separate window.
.ip "\fIFlow Graph Viewer\fP"
This is a tool that displays a hierarchical call graph, allowing the user to
interactively select the areas of interest and to setup the display
accordingly.  It
interacts with the rest of the system to allow the call graph to be used to
locate
routines and calls and to highlight execution.  The call graph is obtained from
the
cross-referencer.
.ip "\fIMake Interface\fP"
This is a menu-oriented interface to the UNIX make program.
.[
feldman make maintaining
.]
By building it on top of make, it is possible to offer many of the extensions
that
exist in
different versions of make as
well as incorporating tools such as automatic dependency analysis.  This
interface is
responsible for performing compilations when requested and for informing
editors of
errors.
.ip "\fIProfiler Interface\fP"
This is a graphical interface to a slightly extended version of the Berkeley
UNIX gprof
command.
.[
graham kessler mckusick gprof call graph execution profiler
.]
The extensions to gprof include making it interactive and providing timing
information about files and lines as well as about functions.  The graphical
interface
allows the user to selectively view the large amount of information that the
profiler
normally produces.
.ip "\fIViewer\fP"
This is a general facility that allows viewing different aspects of a system.
Currently,
viewers exist for the run-time stack, for variables and expressions being
traced, and for
debugger events such as breakpoints.
.ls
.pp
An example view of the FIELD environment is shown in figure 1.
.(z
.hl
.sp 6.5i
.lp
Figure 1:  A view of the FIELD environment.
.sp 1
.hl
.)z
The window in the upper left is the control panel.  It contains icons
(currently old
English letters) for the various views and windows that can be defined.  Below
this is the
debugger interface window.  The bulk of this window is a transcript of the
debugging
session.  Below this transcript are buttons for debugger commands.
Underneath the
debugger interface window is an annotation editor displaying the source file.
There are
three annotations displayed for the one line of text, an arrow indicating the
currently
executing line, eyeglasses representing the current debugger focus, and a stop
sign
indicating a breakpoint.  The window in the upper right of the display shows a
view of the
program's data structure.  The sample program here does tree insertion, and
the tree is
displayed in its current state.  The dark triangles represent empty subtrees.
Below this
on the left is a stack viewer.  This displays the current function and line
being executed
as well as the contents of the local variables at this point.  The window next
to this is a
cross-reference viewer.  It is displaying the result of a query asking for all
calls to the
function \fIinsert_tree\fP.  Finally, the window at the bottom right is the
make interface.
This is currently displaying information about building the system being run.
.sh 1 "The FIELD Integration Framework"
.pp
The constraints and goals of FIELD made existing strategies inappropriate for
integrating tools into a programming environment.  The approaches employed
elsewhere
are more complex and require more effort than we wanted to devote to the
project.  These are discussed more fully in section 5.
They make the use of existing UNIX tools difficult and do not
offer the
extensibility we wanted for the introduction of new research-based tools.
We needed a simpler mechanism that would achieve a high degree of integration
while being
easily extensible.
.pp
We established four criteria for integration based on an analysis of the
desired
interactions between the various tools of an integrated programming
environment:
.ba +5
.ls 1
.sp
.ip \(bu
Tools must be able to interact with each other directly;
.ip \(bu
Dynamic information must be shared among the tools;
.ip \(bu
The programmer must access the source though a common editor;
.ip \(bu
Static, specialized information must be available to all tools needing it.
.ls
.ba
.lp
These four criteria were the requirements we imposed in designing the
underlying
integration mechanism.
.pp
The integration mechanism developed for FIELD is a selective broadcast
message
facility, MSG.  Tools register patterns with MSG to describe the messages
that interest
them.  Tools interact by sending messages to MSG.  These messages are
rebroadcast selectively by MSG to
those tools that have expressed interest in them through a previously
registered
pattern.  This simple concept utilizing
a central
message server and
distributed message handling is sufficient to put together an integrated
programming
environment.
.pp
The facility is powerful enough to handle a variety of tools because of the
flexibility
built into it.  All messages and patterns are passed as arbitrary text strings.
String and numeric arguments are incorporated in and extracted by
MSG according to the patterns.  Messages can be sent either asynchronously or
synchronously.  Asynchronous
messages allow the sender to continue immediately.
Synchronous
messages generate a string reply to the sender once all eligible servers have
acknowledged
the message.
.sh 2 "Tool Interaction"
.pp
The first requirement of an integrated environment is that
tools must be able to interact with each other directly.
If the user wants to
set a
breakpoint in the editor, the editor must be able to issue the corresponding
debugger
command.  If the user wants to force a recompilation from the editor, the
editor must
inform the make interface.  If the compiler detects errors, then the current
editor
focus should be changed to the erroneous context.  If the user wants to find
all
occurrences of a variable in his system, a request must be made of a
cross-referencing
utility.  If a variable display needs information about the type or contents
of the
value it is to display, it must be able to query the debugger.
.pp
Such interactions are supported by using the message facility as a command
interface to the tools of the environment.
The most widely used command interface is to the debugger.  The full
functionality
of
the debugger is available through message-based commands.  This allows the
various tools
to
interact appropriately with the execution of the system.  For example, the
editor sends
messages to insert and remove breakpoints, the variable viewers send messages
to turn
tracing on or off for a given expression, the flow graph viewer sends tracing
requests for the functions it is displaying,
and the data structure displays send
messages to
query types and values from the running program.  The current set of
debugger command
messages is shown in figure 2.  Each of these commands has an alternative form
where
the prefix DDT is replaced by DDTR.  The DDTR command form is used when output
to the
user is
not needed, for example when the request is made by a tool other than the
debugger
interface.  Many of these commands serve multiple functions depending on their
arguments.  Unnecessary or omitted arguments are represented by asterisks (*)
for
strings and zeros for numbers.
.(z
.hl
.sp
.nf
.in +3
DDT ACTION system action
.sz -2
        action = INIT | QUIT | KILL | STOP
.sz
DDT ASSIGN system var expr
DDT CALL system rtn args
DDT DUMP system from to length format
DDT EVAL system expr
DDT EVENT ADD system file func line expr cond addr act fgs
.sz -2
        act = TRACE | BREAK | CALL | WATCH | MONITOR | event_name
        fgs = 1:internal, 2:external, 4:event
.sz
DDT EVENT SHOW system file func line expr cond addr act id
.sz -2
        act = TRACE | BREAK | CALL | EVENT | MONITOR | TRIGGER
.sz
DDT EVENT REMOVE system file func line expr cond addr act id
.sz -2
        act = TRACE | BREAK | CALL | EVENT | MONITOR | TRIGGER
.sz
DDT RUN system args in out new
DDT SET system what value
.sz -2
        what = INFILE | OUTFILE | USE | WHERE | NEWSYS | DDTOUT | WD
                 PRINTIGN | PRINTUSE | CATCH | IGNORE
                 PROG | ENDPROG | FORCE_RUN | RUN_ARGS | USER_TTY | ENV
                 STACK_TOP | STACK_BOTTOM | STACK_DUMP | STACK_SHOW |
STOP_UPDATE
.sz
DDT SHOW system what
.sz -2
        what = SIGNAL | RUN | USE | SYSTEM | LOCATION | FOCUS | ENV
.sz
DDT STACK system from to dump
DDT STEP system count sig unit
.sz -2
        unit = STEP | NEXT | CONT | STEPI | NEXTI
.sz
DDT SYMINFO system what file func line name
.sz -2
        what = WHICH | WHAT | WHERE | VARINFO | TYPEINFO | LIST_FILES |
LIST_FCTS
.sz
DDT VIEW system file func line count stack_delta
.fi
.lp
Figure 2:  Debugger command messages.
.sp
.hl
.)z
.pp
Other command interfaces are provided by the make interface, the
cross-referencer,
and the editor.
The make facility command
interface allows any other component of the system to request that a command
be executed
or
a file be compiled.  This is used by the editor to request that a file be
recompiled and
by
the debugger to request that the current system be rebuilt.  The
cross-referencer allows
any other component to issue a query against its database.  The editor allows
another
tool to request that the current file be saved, that selected annotations be
cleared,
or that all annotations be implicitly recreated.  The first two are used to
externally prepare a source file for compilation.  The last is used by the
debugger
to reestablish breakpoints after recompilation.
.pp
Integrating a tool into the environment with so that other tools can invoke it
through the message server is easy when done in conjunction with a new
front end for the
tool.  In both cases, functions representing the various commands exist or are
written
as part of the expanded tool, and it is
straightforward to
register message patterns for message-based commands and to call these
functions as
appropriate when a message occurs.  This is the approach we
have taken in the make interface, the cross-referencer and the profiling front
ends.  Each of these interfaces took about two days of work.
In the debugger interface, we took this a step further and at first provided
only a
message-based interface.  We then developed an independent front end that
generated
message-based commands.  This approach will allow us to develop different
debugger front
ends with additional functionality and sophistication in the future as
appropriate.
.sh 2 "Information Sharing"
.pp
The second requirement for an integration mechanism is that it must allow
dynamic
information to be shared among the tools.  Different components of the
environment need to
know the
current execution context.  For example, the editor wants to highlight
the current
line of execution and the line last selected in cross-referencing.  Different
components
also want to know something about the state of the other components.  For
example, the
editor wants to know where the debugger has set breakpoints so it can inform
the user;
the make interface wants to know when the editor saves a file so it can
initiate
an automatic recompilation if requested; the new values of variables
being traced need to be
broadcast to appropriate displayers whenever they change; error messages
generated by the
compiler need to be associated with the appropriate source code.
.pp
MSG is designed to handle such dynamic
information.  Each tool defines a set of events it deems might be of interest
to
other tools, and then sends messages about these events as they occur.
Other tools register with MSG those
event messages that they want to handle and are duly informed when the events
occur.
.pp
The debugger event messages are shown in figure 3.  The principal messages are
sent
out whenever the debugger knows the current
line of
execution, either from the program stopping or from a trace request, whenever
it a traced function is entered or exited, whenever a traced value changes, and
whenever an event such as a breakpoint is
added or
removed.  It sends out messages describing the content of the stack if
requested
to do so, say by the stack viewer.
It also allows tools to define their own messages to be tied to trace points
in
the user's program, a facility that is used by the algorithm animation
package TANGO,
.[
stasko tango algorithm animation system technical report
.]
being developed separately.
.(z
.hl
.sp
.nf
.in +3
DEBUG VALUE <system> <file> <line> <var> <value>
DEBUG ENTER <system> <file> <func> <line> <value>
DEBUG EXIT <system> <file> <func> <line> <value>
EVENT ADD <system> <id#> <event_type> <file> <line> <text>
EVENT REMOVE <system> <id#> <event_type> <file> <line> <text>
STOP_ERROR <signal> <file> <line>
DEBUG AT <system> <file> <func> <line>
DEBUG FOCUS <system> <file> <func> <line>
IE <type> <system> <file> <line> <value> ...
DEBUG CLEAR <system>
DEBUG RESET <system>
WHERE <system> <level> <file> <func> <line> <addr> <args>
WHERE_DUMP <system> <level> <name> <value>
WHERE_BEGIN <system>
WHERE_END <system> <level>
DEBUG SYSTEM <system>
DEBUG NO SYSTEM <system>
DEBUG FINISH <system>
DEBUG START <system>
DEBUG STOP <system> <signal_name>
DEBUG STOP <system> OK
UPDATE <system> <file> <line>
.in
.fi
.lp
Figure 3:  Informative messages sent by the debugger.
.sp
.hl
.)z
.pp
This facility is used in other tools as well.
The make interface sends out messages for each error or warning detected by a
compiler; these messages allow the editor to associate the errors with the
program source.  The cross-referencer and flow graph view both send out
messages
when the user clicks
on an output
reference; these messages can be caught by an editor to shift focus to the
referenced
location.  The editor sends out a message whenever a file is opened or closed.
.sh 2 "Source Access"
.pp
The third requirement for an integration mechanism is that it must provide
consistent
access to the program's source.  Programmers access the source for many
reasons.  They
edit it either to create it initially or to make changes.  They view it to
correlate error
messages generated by the compiler, to see where they are during execution,
and to see
what
portions of the program have been identified as hot spots by the profiler.
They set
breakpoints at source statements, trace variables and expressions defined in
the source,
and designate source components to cross-reference.  A fully integrated
environment should
provide a single means for accessing the source that can accommodate all these
needs and
any others that arise.
.pp
FIELD provides such a consistent interface through an annotation editor that
is closely
tied to the message facility.  The annotation editor starts with a powerful,
extensible
base editor that provides the programmer with full editing capabilities on the
source
programs.  Each source line is augmented with a set of associated annotations.
These
serve both as commands that the user can invoke for that line and as markers
for
the line.  The current set of annotations includes:
.ba +5
.ls 1
.sp
.ip \(bu
\fIBREAK\fP allows the user to set breakpoints and shows where current
breakpoints are set.
.ip \(bu
\fITRACE\fP allows the user to set tracepoints and shows where current trace
points are set.
.ip \(bu
\fIWATCH\fP allows the user to trace variables and shows where variable trace
points are set.
.ip \(bu
\fIFOCUS\fP shows the line that the debugger is currently looking at.
.ip \(bu
\fICURRENT\fP shows the current line of execution.
.ip \(bu
\fIXREF\fP shows the line last referred to by the cross-referencing tool or the
flow
graph viewer.
.ip \(bu
\fIUPDATE\fP allows the user to set an update point and shows where such
points
exist.  An update point causes various displays such as the stack viewer and
the data
structure displayer to be synchronized with program execution.
.ip \(bu
\fIEVENT\fP inserts an interesting event for program animation.
.ip \(bu
\fIERROR\fP flags a line containing an error detected by the compiler.
.ip \(bu
\fIWARNING\fP flags a line containing a warning message detected by the
compiler.
.ls
.ba
.lp
New annotations are easy to add, since they are defined by a text file that is
read at
startup, not coded as part of the editor.
.pp
Annotations interact with the message system in a variety of ways.  The
interaction
is specified
by string values representing messages and patterns that are associated with
an annotation
type.  For example, figure 4 shows the messages associated with the \fIBREAK\fP
annotation type.  The MSG_ADD string corresponds to a message that is
broadcast when the user adds an annotation; the
MSG_REMOVE string corresponds to one that is sent out when the user deletes
one.  The
MSG_SET string and the
MSG_UNSET string correspond to patterns for messages that will cause the editor
to
add and remove the annotation.
.(z
.hl
.nf
.in +3
MSG_ADD = "DDTR EVENT ADD * %F * %L * * 0 BREAK 3"
MSG_REMOVE = "DDTR EVENT REMOVE * %F * 0 * * 0 BREAK %V"
MSG_SET = "EVENT ADD %s %V BREAK %F %L %T"
MSG_UNSET = "EVENT REMOVE %s %V BREAK %F %L %T"
.in
.fi
.lp
Figure 4:  Messages associated with a BREAK annotation.
.sp
.hl
.)z
.pp
The strings associated with an annotations contain escape sequences that are
filled
in by the editor to form the corresponding message or pattern.  These can refer
to
the
current line (%L), character position (%C), filename (%F), or to strings
associated with
this particular annotation (%V, %T).  These strings are defined by their
occurrences in the \fIset\fP pattern.  Other escape sequences refer to
arbitrary strings (%s) and numbers (%d) in a pattern that are to be scanned and
ignored.
The \fIadd\fP message in figure 4 causes a
breakpoint to be added in the given file at the given line, using the debugger
command shown in figure 2.
The asterisk in the
system field indicates that the breakpoint should apply to all systems that
include
this source file.  The file field is filled in with the name of the file being
edited.
The asterisk in the function field means to ignore the function.  The line
number
field contains the line where the annotation was requested.
The asterisks in the expression and conditional field means the breakpoint is
unconditional whenever execution reaches this line.
The \fIremove\fP message similarly sends a debugger command to remove the
breakpoint
in the given source file.
More complex annotations, for example a breakpoint involving a condition, can
be
defined as well using additional %T arguments (%T1, %T2 and %T3).  In this
case, the
user could be prompted for the condition.  This type of annotation currently is
used
for defining interesting events to drive the algorithm animation package.
.pp
The patterns associated with an annotation contain the same escape sequences as
the
messages.  In this case, however, they refer to arguments that are interpreted
by the
editor.  The file name, if provided by the pattern, must match the file being
edited.
If it doesn't then the message will generally be ignored.  However, the editor
can be
made sensitive to this type of annotation.  In this case, if the filename
differs,
the current file will be closed, the specified file will be opened, and the
message
will be processed.  This is used to keep an editor synchronized with the
debugger and
to provide a viewer to show compiler error messages and cross-reference
locations.
The line number must be present.  It identifies wher the annotation should be
added
or removed.  If the editor is sensitive to the annotation type, then the editor
will
automatically scroll so that this line is visible.  The %V and %T escape
sequences
define values that are associated with the new annotation on a \fIset\fP
message and
are ignored on a \fIremove\fP message.  The %T values contain text information
that
can be later viewed by the user.  For breakpoints, this is a string describing
the
breakpoint; for error messages, it is the text of the message.  The %V field
refers
to a number.  The patterns of figure 4 correspond to the event messages of
figure 3.
.pp
The annotation editor enables different annotations to behave appropriately by
allowing
different annotations to have different properties.  Annotations can be
exclusive over all
source files, over a given line, or not at all.  Annotations that are exclusive
over
all source files are
used to allow
the editor to
remove the annotation indicating the current line of execution when a new
current
line is
broadcast, even if this new
one is for a different source file.  When an
annotation
is exclusive to a given line, previous ones on that line can be either
discarded or
merged.
Only one \fIERROR\fP
annotation occurs per line, for example, but this annotation contains
information
about all
the
passed error
messages for that line.  Annotations can also be set by the user, as with
\fIBREAK\fP annotations, or set only through outside messages, as with
\fIERROR\fP
annotations.  Each annotation also comes with its own icon and color.
.sh 2 "Sharing Static Information"
.pp
The fourth requirement on our integration mechanism is that static,
specialized information be available for the various tools.  This information
includes the
rules
needed for building the system, cross-reference information, profiling
data, and
information about the
program and the execution environment.  Program information includes
information about the
types of variables and descriptions of these types.  Execution information
includes the
current set of breakpoints and other run-time events.  All this information
must be
available to various components of the system on demand, and must be actively
managed so
that requests are satisfied with up-to-date data.
.pp
Rather than storing all the necessary information in a central database,
FIELD uses the concept of active servers to handle this requirement.  An
active
server is a FIELD component that receives requests for information through the
message
server.  It processes and replies to these requests either by dynamically
computing the
necessary information or by caching that information in a local database.  The
message interface allows the various tools to get the necessary information
without
needing
to know how it is stored.  The compartmentalization of the different types of
specialized information simplifies the individual servers and allows the use
of existing or slightly modified tools in many cases.
.pp
Currently four FIELD tools fulfill this function to some extent.
The debugger provides
information about program variables and types and about the current run-time
environment.
The cross-reference server handles arbitrary queries against a relational
database that
represents information about the program.  This database is generated the
first time
cross-referencing is done on a system.  After that, it is generated
incrementally, and
only
source files that have changed since the last use need be rescanned.  The
profiling
interface allows information about functions, files and lines to be returned
and allows
queries about hot spots in the program.  The make interface stores information
about
dependencies and how to build the system.
.sh 1 "MSG: The FIELD Message Facility"
.pp
The message facility underlying FIELD is based on selective broadcasting.
Each tool in
the
FIELD environment registers a set of patterns describing the messages it is
interested
in with the message server.  Any tool in the environment can then send a
message to
the server.
This message is rebroadcast by the server
to all the tools that have registered a pattern matching the message.  The
facility
allows both synchronous and asynchronous broadcasting.
.pp
The implementation of this facility is distributed.  The message facility is
in two parts.
The actual MSG server runs as a separate UNIX process, communicating via
sockets.
Each tool includes a client interface that talks to the server and handles
message
distribution from the server to the tool.
FIELD tools can exist in a single process or in multiple processes.
Whenever a message is sent by a tool, it is passed to the server.  The server
then passes the message back to the client interface for each process with a
pattern
matching the message.  The client interface then scans the message and takes
the
appropriate action to send it to the receiver.  TCP-domain sockets are used so
that the
tools in a FIELD environment can reside on different machines and still share a
common message server.  This permits
the
integrated debugging of a distributed system and allows one machine to be used
for
debugging a program running on a second.  The current implementation consists
of
about 2000 lines of C code, equally divided between the server, the client
interface,
and a common pattern matcher.
.pp
All messages in FIELD are passed as strings.  While this introduces some
inefficiencies,
it
greatly simplifies pattern matching and message decoding, and eliminates
machine
dependencies such as
byte order or floating-point representation.  Similarly, strings are used to
represent the
patterns that determine what messages are desired.
.pp
While encoding a message into a string is easy, decoding a message can be
complex.  The client interface of the MSG package does the decoding of messages
rather than the individual tools.
When a tool registers a pattern for a message, it provides an entry
point to a
routine that will handle the message.  The pattern identifies not only the
message but
also
those portions of the message corresponding to arguments for that routine and
the format of
those arguments.  A side effect of matching a message against a pattern is to
decode
the
arguments from their string form into the proper internal form.  If the
pattern matches
the
message, then the routine associated with the pattern is called and passed the
decoded
arguments.  This allows the message-handling routines in the client tools to
be
simple.  For example, figure 5 shows a message pattern, the associated routine
declaration,
a sample message and the resultant call.
.(z L
.hl
.ba +5
.sp
.ip "\fBMessage Pattern:\fP"
EVENT ADD %s %3d BREAK %1s %2d %4r
.sp
.ip "\fBRoutine Declaration:\fP"
.nf
static void
handle_add_msg(file,line,value,text)
   String file;
   Integer line;
   Integer value;
   String text;
.fi
.sp
.ip "\fBSample Message:\fP"
EVENT ADD tree 4 BREAK ./tree.c 24 [4] BREAK at line 24 of file ./tree.c
.sp
.ip "\fBResultant Call:\fP"
handle_add_msg("./tree.c",24,4,"[4] BREAK at line 24 of file ./tree.c",-1)
.sp 2
.ba
.lp
Figure 5:  Example of a message pattern, message and call.
.sp
.hl
.)z
.pp
Patterns for messages consist of literal characters that must match the
corresponding
characters in the message and
escape sequences that represent either arguments or generic strings.
The format of these patterns is based on the common UNIX scanf facility.
Escape sequences
consist of a percent sign (%), followed by an optional description, followed
by an
alphabetic
character denoting the escape sequence.  Escape sequences representing
arguments have
the
form:
.(l C
% [argument_number] [\fB.\fP length] type_character
.)l
The \fIargument_number\fP allows the arguments to the routine to be given in
any order in
the
message.  The \fIlength\fP allows for fixed-length fields where appropriate.
The
\fItype_character\fP can be one of:
.TS
center box tab(&);
L L .
d&Decimal integer
o&Octal integer
x&Hexadecimal integer
e&Floating point
c&Character
s&String
r&String representing the remainder of the message
q&String in quotes
[\fIcharacters\fP]&String consisting only of given characters
[^\fIcharacters\fP]&String consisting of anything but given characters
.TE
When defining a pattern, the caller can also set default values for arguments
not
directly defined in the pattern.  This allows a common routine to be used to
handle a
variety of different messages.
In figure 5, the sample message is accepted by the message pattern.  The first
escape
sequence, %s, causes the system name \fItree\fP to be discarded.  The second
escape
sequence, %3d, causes the number 4 to become the third parameter to the
function.
The third escape sequence, %1s, matches the filename \fI./tree.c\fP, and causes
the
corresponding string to be passed as the first parameter.  The next escape
sequence,
%2d, causes the line number 24 to be scanned and passed as the second
parameter.
Finally, the last escape sequence, %4r, causes the rest of the breakpoint
message
containing a definition string to be passed to the routine as the fourth
parameter.
.pp
Most of the messages sent in FIELD are asynchronous messages that are
broadcast
to
provide potential clients with information.  Messages that represent commands
must be
synchronous and must provide the caller with a reply.  FIELD clients send such
messages
much
as they send asynchronous messages.  However, once the message is sent, the
client
partially
blocks until a reply is received.  When it receives a synchronous message
request,
the message server first determines the number of receivers that exist for the
given
message,
and then sends the message to all these clients.  Each client is responsible
for telling
the server that is has processed the message by passing back a string reply.
The message
server and the associated client interface return control to the initial
caller only when
replies
have
been received from all recipients of the initial message.  When this occurs,
the first
non-null string reply that was received is passed back to the sender.  While
waiting for
such a reply, MSG will still send new messages to the tool to be processed.
We ignore all but the first reply because it is simpler than accumulating all
replies
and because we haven't found an occasion where more than one reply was expected
or
needed.  The need to be able to accept and process new messages while waiting
for a
reply comes from the debugger.  The update and event messages that the debugger
sends out are synchronous so that the various tools can run in step. However,
the
typical reaction of a data viewer when it gets an update message is to make
requests
of the debugger to get the information it needs to be up to date.
.pp
To allow such synchronous messages, the message server appends an argument to
the end
of the argument list for each message.  This new value either is negative or is
the identity
of the message to reply to.  The recipient of the message will check this
value and, if it
is non-negative, will use it when
issuing a reply.  This allows tools such as the debugger to receive
commands that optionally require replies.
Using a specific reply identifier also
allows many synchronous messages to be
outstanding and be processed by a variety of tools.
.pp
This facility is robust as long as the various tools do not ignore a reply
request
for a message.  The message facility will return control to the caller
immediately if
no pattern was matched and therefore the message was not sent.  The server also
keeps
track of what replies are outstanding by what tools.  If a tool goes away,
normally
or
abnormally, the message server detects this and simulates a null response to
all its
pending messages.  We decided against imposing a timeout feature on message
replies
since the action associated with a synchronous message may require user
interaction
inside another tool and thus can take an arbitrary amount of time.
.sh 1 "Related Research"
.pp
Integrated programming environments have been widely touted as a means for
increasing programmer productivity.  Moreover, the controlled and
understandable
environment they offer the programmer is ideal for instruction.
A wide range of integrated environments have been developed over the past
twenty years.
The tools in these environments have been integrated in a variety of ways.
.pp
Most of today's environments offer integration at the file level.  UNIX is an
example of
such an environment.  In UNIX, programmers edit their source files.  They use
SCCS or RCS
to
check files in and out and to manage versions of files.  They run the
\fImake\fP
program
that takes a file describing how the system is to be built and runs the
appropriate compilers and loaders on the source files to produce object files
and the
resultant systems.  The debugger runs on the binary file and accesses the
source files as
appropriate.  These tools are integrated only in the sense of operating on a
common
set of files.  They each have different interfaces and obey different
conventions.
Programmers are free to choose the set of tools they want to use and ignore
the others.
None of the tools takes advantage of the others or interacts except through
their
eventual outputs in the file system.
.pp
There have been some attempts to extend UNIX's limited degree of integration.
Sun's
dbxtool provides a \fImake\fP command to run the make program and an
\fIedit\fP command
to run an editor on the appropriate source file.
.[
sun microsystems debugging tools
.]
The GNU Emacs editor can parse
the output from the compiler and go to lines containing errors.
.[
stallman gnu emacs manual free software
.]
The default \fImake\fP
rules have been extended to do many SCCS functions automatically.  All these
extensions, however, are
ad hoc and involve simple extensions to one particular tool.  They do not
provide a
common interface nor a general extensible integration mechanism.
.pp
More integration can be found in single-language environments where all the
tools are combined in a single system.  The tools generally share a common
interface and
operate on a single program
representation.
Such environments exist both
with languages such as Lisp and Smalltalk, and with small-scale systems on
personal
computers.
.pp
These systems can achieve a high degree of integration.  The PECAN system,
.[
reiss pecan program development systems multiple view support
.]
for
example, allowed
multiple editors on the source and updated them all as the source changed.  It
used the source views to animate program execution, and provided an
incremental compiler
that ran as the editor detected a source change.  The compiler in turn updated
a
set of semantic views such as the symbol table.  It also detected errors and
highlighted
them in the source views.  Breakpoints could be set in any of the source
views.
.pp
At the same time, these systems tend to be complex and fail to take advantage
of
existing tools.  Languages such as Lisp and Smalltalk allow an extensible
environment and direct access to the execution framework.  This permits new
tools to be
implemented incrementally on top of the system, so that with time, the system
gains
functionality and complexity.  Moreover, integrating a new tool with the rest
of the
system typically means integrating it separately with each of the other tools
already
developed, since there is no guarantee that the interfaces or conventions are
similar.  More traditional languages such as C or Pascal are not amenable to
use for such
an extensible environment.  Such systems are difficult to extend, especially
given
their size and complexity. Most of the environments developed for these
languages
use an interpreter to achieve a high degree of integration between an
executing program
and the rest of the system, a strategy that limits these systems to handling
small
programs.
.pp
An alternative to providing integration by combining all the tools into a
single system is
a program database.  Here a single database system is used to store all the
relevant
information about a system.
Integration within a single system is typically provided by
having the various tools share common data structures that represent the
different aspects
of the program and its execution.  A program database extends this by allowing
independent
tools to access a specific set of common data structures in a controlled way.
In effect,
the shared data structures of the single system are placed under the control
of a separate
database system that provides consistency and integrity between processes, and
the
remaining tools access these structures through this new system.
.pp
There are two approaches to implementing a programming environment focused on
a program
database.  The first is to have all the tools use the database directly.  That
is, the
tools are designed with the database in mind, and use representations that
either are
stored in the database or can easily be derived from the database.  This has
the advantage
of efficiency and consistency, and is the approach being used to develop the
APSE
environments for ADA.  In the APSE environments, an attributed abstract syntax
representation
is stored in a common database.  The compiler, debugger, loader, and other
tools all
access
the program
as DIANA trees by going through the common database system.  The principal
disadvantage of
this approach is that any existing tools must be rewritten to use the
database.  A
secondary disadvantage is that the database representation must be determined
before the
tools are implemented, so that adding tools not initially anticipated
can cause problems.
.pp
The second approach to using a program database is to treat it as a
.q "software backplane" .
Here the tools can use whatever representation is most appropriate:
preexisting tools can
use their current representations; new tools can be written to use whatever
representation
is most efficient for their application.  Here the database system stores a
single
extensible representation of the data.  This representation is mapped by the
database
system back and forth from the form needed for a particular application when
that
application is run.  This approach has the advantage of allowing the use of
existing tools
and of making it easier to write or incorporate new tools in the future.  It
has the
disadvantage that the mappings from the database representation to the
application
representation can be complex and are not necessarily one-to-one.
.pp
The use of a program database in general has disadvantages.  The additional
system
needed to maintain the database adds complexity to the
programming environment. Database
systems are generally large, complex programs and a program database that
deals with
multiple clients and maintaining consistent information about a program will
be no
exception.  Moreover, this strategy requires that the representation of the
program be
well
understood
before most of the tools are written, and adding new tools that do not fit
well with the
original a priori definition can be difficult.
.pp
FIELD provides a third alternative, using a loosely-coupled message facility
to provide
tool integration. This alternative offers several advantages, primarily
simplicity, ease of
reuse of existing tools, and ease of extensibility.  This, combined with the
annotation
editor to provide consistent access to the source throughout the environment,
leads to a
powerful programming environment that can effectively use existing and future
tools.
While this approach cannot provide the complete integration of the other
approaches, our
experience is that the level of integration is high enough for almost all
applications, and
that complete integration is not necessary.
.sh 1 "Current Status and Future Directions"
.pp
FIELD demonstrates a simple but effective mechanism for uniting a wide variety
of
existing tools to form an integrated programming environment.  This facility
is based on a
simple selective-broadcast message-passing mechanism that is used directly to
provide a inter-tool command facility and to broadcast dynamic information to
interested
tools.  It is also used by an annotation editor that provides a consistent
method for
accessing the source for multiple purposes and by a variety of tools that
serve as
specialized program databases.
.pp
The FIELD system is currently being used for both research and instruction
in the Computer Science Department of Brown University.  It is currently
running on
Sun workstations, both Sun 3's and Sun 4's.  Portions of FIELD have also been
ported to a
Microvax and to an Encore Multimax.  Within the Computer Science Department,
it is being used in
undergraduate
Computer Science courses ranging from the algorithms and data structures
course to the
software project course.  In the elementary courses, a restricted form of the
environment is created that only provides a limited complement of tools and
that
automatically selects the tools of interest.  In the advanced courses, the full
environment is made available to the students. It is being used in research as
a
debugging aid and as a testbed for developing additional programming aids.
Experiences to date have been generally positive, but it is too early to
evaluate the
effectiveness of the environment.  We hope to report on this in a latter paper.
.pp
We are continuing to do research with FIELD in a variety of areas.  One
project being
undertaken by John Stasko at Brown involves the development of an algorithm
animation
system that uses FIELD to specify and generate interesting events.  This
system, TANGO, is
designed to provide access to BALSA-like
.[
brown sedgewick techniques for algorithm animation
.]
animations that are easy to create and easy to tie into the user's program.
.pp
Another direction for future research involves the development of additional
tools for
programming-in-the-small.  We are considering variable displays that would
graphically show
variables as dials or gauges; program views that display the program
and allow the user to visualize and control program
execution; a
testing view that would automatically run test cases and display the results;
better
profiling tools to get a finer level of granularity; and better debugging
interfaces based
on new debugging languages.
.pp
A third research direction involves extending FIELD to handle parallel
programming
environments.  FIELD is already capable of debugging multiple-process programs
and has
hooks in it for handling multiple-threaded programs.  To make effective use of
these hooks,
the system-debugger has to understand multiple threads of control.
Additionally, depending
on the model of parallelism that will be used, a variety of monitoring tools
can be added
to the environment.
.pp
While most of the current implementation of FIELD involves
programming-in-the-small, the
concepts and integration mechanisms can easily be extended to tools for
programming-in-the-large.  Another research direction will involve
incorporating new and
existing
UNIX-based tools for programming in the large into the FIELD environment.
These will
include tools for version control, better configuration management, interface
checking,
history recording, bug reporting, etc.
.pp
Our current experiences with the FIELD system show that its performance and
degree of
integration is more that adequate for most users and
most applications.  As such, we feel that the simple mechanisms used by FIELD
offer a
practical alternative for producing a highly integrated programming
environment.
.lp
.ls 1
.[
$LIST$
.]

