/************************************************************************/
/*									*/
/*		dispmain.c						*/
/*									*/
/*	General routines for disping package			       */
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "disp_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	disp_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	DISP_init -- package initialization				*/
/*									*/
/************************************************************************/


void
DISP_init()
{
   PROT_INIT;
   PROTECT;
   if (!disp_inited) {
      disp_inited = TRUE;
      DISP_win_init();
      DISP_ddt_init();
      DISP_apple_init();
      DISP_pear_init();
      DISP_expr_init();
      DISP_db_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	DISPnew_willow_window -- create a new willow window		*/
/*	DISPnew_willow_apple -- create a new willow apple only window	*/
/*	DISPnew_willow_pear -- create a new willow pear only window	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

int
DISPnew_willow_window(w,name)
   ASH_WINDOW w;
   String name;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,NULL,NULL,TRUE,TRUE);

   if (aw == NULL) return FALSE;

   return TRUE;
};





/*ARGSUSED*/

int
DISPnew_willow_apple(w,name)
   ASH_WINDOW w;
   String name;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,NULL,NULL,FALSE,TRUE);

   if (aw == NULL) return FALSE;

   return TRUE;
};





/*ARGSUSED*/

int
DISPnew_willow_pear(w,name)
   ASH_WINDOW w;
   String name;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,NULL,NULL,TRUE,FALSE);

   if (aw == NULL) return FALSE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	DISPnew_window -- create a new display on given variable	*/
/*	DISPnew_window_apple -- create a new apple-only display 	*/
/*	DISPnew_window_pear -- create a new pear-only display		*/
/*									*/
/************************************************************************/


int
DISPnew_window(w,id)
   ASH_WINDOW w;
   String id;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,id,NULL,TRUE,TRUE);

   return (aw != NULL);
};





int
DISPnew_window_apple(w,id)
   ASH_WINDOW w;
   String id;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,NULL,id,FALSE,TRUE);

   return (aw != NULL);
};





int
DISPnew_window_pear(w,id)
   ASH_WINDOW w;
   String id;
{
   register DISP_WIN aw;

   DISP_init();

   aw = DISP_create(w,id,NULL,TRUE,FALSE);

   return (aw != NULL);
};





/* end of dispmain.c */
