/************************************************************************/
/*									*/
/*		dispapple.c						*/
/*									*/
/*	APPLE interface for displaying data structures package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "disp_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	APPLE_GELO_OBJECT	disp_apple_load();
static	void			disp_apple_save();
static	Integer 		disp_apple_fields();
static	void			disp_apple_new();
static	void			disp_apple_string();
static	String			disp_apple_name();
static	void			disp_apple_notify();
static	int			disp_apple_value();
static	Integer 		disp_apple_contents();
static	Integer 		disp_apple_equals();
static	Integer 		disp_apple_condition();
static	Integer 		disp_apple_null();
static	Integer 		disp_apple_pointer();

static	Integer 		get_hex_value();
static	DISP_OBJECT		get_element_value();




/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	DISP_apple_init -- module initialization			*/
/*									*/
/************************************************************************/


void
DISP_apple_init()
{
   APPLEregister_external(disp_apple_load,
			     disp_apple_save,
			     disp_apple_fields,
			     disp_apple_new,
			     disp_apple_string,
			     disp_apple_name,
			     disp_apple_notify,
			     disp_apple_value,
			     disp_apple_contents,
			     disp_apple_equals,
			     disp_apple_condition,
			     disp_apple_null,
			     disp_apple_pointer);
};





/************************************************************************/
/*									*/
/*	DISPpicture_note_new -- tell APPLE there is a new picture	*/
/*									*/
/************************************************************************/


void
DISPpicture_note_new(type)
   DISP_TYPE type;
{
   type->drawinfo = NULL;
   APPLEsave_clear(type);
};





/************************************************************************/
/*									*/
/*	DISP_apple_setup -- setup apple window				*/
/*									*/
/************************************************************************/


void
DISP_apple_setup(dw)
   DISP_WIN dw;
{
   String s;
   AUXD hdl;

   if (dw->type == NULL || dw->apple_win == NULL) return;

   if (dw->apple_id == NULL) {
      dw->apple_id = APPLEdisplay(dw->apple_win,dw);
      APPLEallow_new_fields(dw->apple_id,FALSE);
      hdl = AUXDget_handle(NULL,"DISP");
      if (AUXDget_defined(hdl,"SIMPLE")) s = "on";
      else s = ASHinq_resource("disp.simple");
      if (s == NULL || STREQL(s,"off")) APPLEmenu_quit(dw->apple_id);
    }
   else {
      APPLEforce_restart(dw->apple_id);
    };
};





/************************************************************************/
/*									*/
/*	disp_apple_load -- load picture from database			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static APPLE_GELO_OBJECT
disp_apple_load(dw,t,forcefg)
   DISP_WIN dw;
   DISP_TYPE t;
   Boolean forcefg;
{
   register APPLE_GELO_OBJECT ago;
   DISP_TYPE st;

   ago = NULL;

   if (dw != NULL && t == NULL) t = dw->type;

   if (t != NULL) {
      if (t->drawinfo == NULL && t->usedb) DISP_db_load(t);
      if (t->drawinfo == NULL && t->class == DISP_TYPE_SAME) {
	 for (st = t->base; ; st = st->base) {
	    if (st->drawinfo != NULL) {
	       t = st;
	       break;
	     };
	    if (st->class != DISP_TYPE_SAME) break;
	  };
       };
      ago = APPLEcopy_picture(t->drawinfo);
    };

   return ago;
};





/************************************************************************/
/*									*/
/*	disp_apple_save -- save picture into database			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
disp_apple_save(dw,p)
   DISP_WIN dw;
   APPLE_GELO_OBJECT p;
{
   if (dw != NULL && dw->type != NULL) {
      DISP_clear_type(dw->type);
      dw->type->drawinfo = APPLEcopy_picture(p);
      if (dw->type->usedb) DISP_db_store(dw->type);
    };
};





/************************************************************************/
/*									*/
/*	disp_apple_fields -- return fields for current type		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_fields(dw,t,selectfg,max,flds)
   DISP_WIN dw;
   DISP_TYPE t;
   Boolean selectfg;
   Integer max;
   APPLE_VALUE_B flds[];
{
   register Integer ct;
   Sequence l;
   DISP_FIELD df;

   if (dw != NULL && t == NULL) t = dw->type;

   if (max == 0 || t == NULL) return 0;

   while (t != NULL && t->class != DISP_TYPE_RECORD) {
      switch (t->class) {
	 case DISP_TYPE_RECORD :
	    break;
	 case DISP_TYPE_SAME :
	    t = t->base;
	    break;
	 case DISP_TYPE_POINTER :
	    t = t->base;
	    break;
	 default :
	    t = NULL;
       };
    };

   if (t == NULL) return 0;

   ct = 0;

   if (t->class == DISP_TYPE_RECORD) {
      forin (df,DISP_FIELD,l,t->fields) {
	 flds[ct].name = df->name;
	 flds[ct].value = (int) df;
	 ++ct;
	 if (ct >= max) break;
       };
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	disp_apple_new -- add a new field for type			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
disp_apple_new(da,v)
   DISP_WIN da;
   APPLE_VALUE v;
{
};





/************************************************************************/
/*									*/
/*	disp_apple_string -- build string value 			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
disp_apple_string(v)
   APPLE_VALUE v;
{
   if (v->name == NULL) v->value = NULL;
   else {
      v->value = (int) v->name;
    };
};





/************************************************************************/
/*									*/
/*	disp_apple_name -- return name of this type			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static String
disp_apple_name(dw,t)
   DISP_WIN dw;
   DISP_TYPE t;
{
   register String s;

   if (dw != NULL && t == NULL) t = dw->type;

   if (t != NULL) s = t->name;
   else s = "<Null>";

   return s;
};





/************************************************************************/
/*									*/
/*	disp_apple_notify -- note that picture changed			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
disp_apple_notify(da)
   DISP_WIN da;
{
};





/************************************************************************/
/*									*/
/*	disp_apple_value -- return value for field of type of object	*/
/*									*/
/************************************************************************/


#define TEXT_WIDTH	32
#define BUF_SIZE	512



/*ARGSUSED*/

static int
disp_apple_value(o,typ,v,from,idx,lvl,dp,dtp,sp)
   DISP_OBJECT o;
   DISP_TYPE typ;
   APPLE_VALUE v;
   DISP_OBJECT from;
   Integer idx;
   Integer lvl;
   DISP_OBJECT * dp;
   DISP_TYPE * dtp;
   String * sp;
{
   DISP_OBJECT uo;
   DISP_FIELD df;
   Character vbuf[10240],rbuf[10240],ibuf[32];
   String sys;

   df = NULL;

   o = (DISP_OBJECT) DISP_var_addr(o);
   from = (DISP_OBJECT) DISP_var_addr(from);

   if (v->name != NULL && STREQL(v->name,APPLE_SELF_NAME)) {
      uo = o;
    }
   else if (v->name != NULL && STREQL(v->name,APPLE_DATA_NAME)) {
      uo = from;
    }
   else if (v->name != NULL && STREQL(v->name,APPLE_INDEX_NAME)) {
      if (sp != NULL) {
	 sprintf(ibuf,"%d",idx);
       };
    }
   else if (v->value == NULL) {
      uo = o;
    }
   else if ((int) v->value == (int) v->name) {
      uo = (DISP_OBJECT) v->value;
    }
   else if (o == NULL) {
      uo = NULL;
    }
   else {
      df = (DISP_FIELD) v->value;
      if (typ == NULL) typ = df->base;
    };

   if (df != NULL) sys = df->base->system;
   else if (typ != NULL) sys = typ->system;
   else sys = NULL;

   DISP_expr_value(o,typ,df,-1,vbuf);

   if (sp != NULL) {
      if (df == NULL) {
	 if (v->name == NULL || STREQL(v->name,APPLE_SELF_NAME)) {
	    DISP_get_value(sys,vbuf,rbuf);
	    *sp = SALLOC(rbuf);
	  }
	 else if (STREQL(v->name,APPLE_INDEX_NAME)) {
	    *sp = SALLOC(ibuf);
	  }
	 else *sp = v->name;
       }
      else {
	 DISP_get_value(sys,vbuf,rbuf);
	 *sp = SALLOC(rbuf);
       };
    };

   if (dtp != NULL) {
      if (df == NULL) *dtp = typ;
      else *dtp = df->type;
    };

   if (dp != NULL) {
      if (df == NULL) *dp = uo;
      else {
	 sprintf(rbuf,"& %s",vbuf);
	 strcpy(vbuf,rbuf);
	 DISP_get_value(sys,vbuf,rbuf);
	 uo = (DISP_OBJECT) get_hex_value(rbuf);
	 if (((int) uo) > 0 && ((int) uo) < 1024) uo = 0;	/***********/
	 *dp = uo;
       };
    };

   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_apple_contents -- test/return contents of object		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_contents(obj,dw,typ,max,val,vtyp,base)
   DISP_OBJECT obj;
   DISP_WIN dw;
   DISP_TYPE typ;
   int max;
   DISP_OBJECT val[];
   DISP_TYPE vtyp[];
   Integer * base;
{
   Integer ct,i;

   if (dw != NULL && typ == NULL) typ = dw->type;

   if (typ != NULL) while (typ->class == DISP_TYPE_SAME) typ = typ->base;
   if (typ == NULL) return 0;

   ct = 0;
   if (typ != NULL && typ->class == DISP_TYPE_ARRAY) {
      if (base != NULL) *base = typ->count0;
      ct = typ->count;
      if (max < 0) return 1;
      else if (max == 0) return 0;
      else if (ct > max) ct = max;

      obj = (DISP_OBJECT) DISP_var_addr(obj);

      for (i = 0; i < ct; ++i) {
	 val[i] = get_element_value(obj,typ,i+typ->count0);
	 vtyp[i] = typ->base;
       };
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	disp_apple_equals -- check equality of two items	       */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_equals(o1,o2,t1,t2)
   DISP_OBJECT o1;
   DISP_OBJECT o2;
   DISP_TYPE t1;
   DISP_TYPE t2;
{
   Character buf1[10240],buf2[10240];
   Character buf3[10240],buf4[10240];
   String sys;

   o1 = (DISP_OBJECT) DISP_var_addr(o1);
   o2 = (DISP_OBJECT) DISP_var_addr(o2);

   if (o1 == o2) return TRUE;

   if (o1 == NULL || o2 == NULL) return FALSE;

   if (t1 != NULL) while (t1->class == DISP_TYPE_SAME) t1 = t1->base;
   if (t2 != NULL) while (t2->class == DISP_TYPE_SAME) t2 = t2->base;

   DISP_expr_value(o1,t1,NULL,-1,buf1);
   DISP_expr_value(o2,t2,NULL,-1,buf2);

   if (STREQL(buf1,buf2)) return TRUE;

   if (t1->system != NULL) sys = t1->system;
   else if (t2->system != NULL) sys = t2->system;
   else sys = NULL;

   DISP_get_value(sys,buf1,buf3);
   DISP_get_value(sys,buf2,buf4);

   if (buf3[0] == 0 && buf4[0] == 0) return FALSE;

   return STREQL(buf3,buf4);
};





/************************************************************************/
/*									*/
/*	disp_apple_condition -- get condition from user 	       */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_condition(v,a,vp,valfg)
   DISP_OBJECT v,a;
   DISP_OBJECT *vp;
   Boolean valfg;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_apple_null -- check for null value 			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_null(o,typ)
   DISP_OBJECT o;
   DISP_TYPE typ;
{
   Character buf[10240],rslt[10240];
   Integer i,ln;

   o = (DISP_OBJECT) DISP_var_addr(o);

   if (typ != NULL) while (typ->class == DISP_TYPE_SAME) typ = typ->base;
   if (typ != NULL && typ->class == DISP_TYPE_ARRAY) return FALSE;

   if (o == NULL) return TRUE;
   if (typ == NULL) return FALSE;

   if (typ->class != DISP_TYPE_POINTER && typ->class != DISP_TYPE_PRIMITIVE &&
	  typ->class != DISP_TYPE_ENUM)
      return FALSE;

   DISP_expr_value(o,typ,NULL,-1,buf);
   DISP_get_value(typ->system,buf,rslt);

   if (typ->class == DISP_TYPE_ENUM) {
      if (typ->enumbase == NULL) i = 1;
      else {
	 ln = strlen(rslt);
	 if (strncmp(rslt,typ->enumbase,ln) == 0 &&
		(typ->enumbase[ln] == ' ' || typ->enumbase[ln] == 0)) i = 0;
	 else i = 1;
       };
    }
   else if (typ->class == DISP_TYPE_POINTER) i = get_hex_value(rslt);
   else if (STREQL(rslt,"0") || STREQL(rslt,"0.0")) i = 0;
   else i = 1;

   return (i == 0);
};





/************************************************************************/
/*									*/
/*	disp_apple_pointer -- check for pointer field			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Integer
disp_apple_pointer(obj,dw,typ,fld)
   DISP_OBJECT obj;
   DISP_WIN dw ;
   DISP_TYPE typ;
   APPLE_VALUE fld;
{
   DISP_FIELD df;
   DISP_TYPE t;

   if (dw != NULL && typ == NULL) typ = dw->type;
   if (typ != NULL && typ->nested) return FALSE;

   df = (DISP_FIELD) fld->value;

   t = df->type;
   while (t != NULL && t->class == DISP_TYPE_SAME) t = t->base;
   if (t != NULL && t->class == DISP_TYPE_POINTER) return TRUE;

   return FALSE;
};





/************************************************************************/
/*									*/
/*	get_hex_value -- get hex value from a string			*/
/*									*/
/************************************************************************/


static Integer
get_hex_value(s)
   String s;
{
   Integer v;

   while (*s != 0 && (*s != '0' || s[1] != 'x')) ++s;

   v = 0;
   if (*s != 0) sscanf(s,"0x%x",&v);

   return v;
};





/********************************************************************************/
/*										*/
/*	get_element_value -- get value for array element			*/
/*										*/
/********************************************************************************/


static DISP_OBJECT
get_element_value(o,typ,i)
   DISP_OBJECT o;
   DISP_TYPE typ;
   Integer i;
{
   Character tbuf[10240],buf[10240];
   String tnm;
   Integer m,r;
   DISP_TYPE t;

   if (o == NULL) return NULL;

   if (typ->class != DISP_TYPE_ARRAY) {
      tnm = DISP_expr_type_name(typ,tbuf);

      sprintf(buf,"& ((%s) 0x%x)[%d]",tnm,o,i-typ->count0);
    }
   else {
      m = (i - typ->count0);
      for (t = typ->base; t->class == DISP_TYPE_ARRAY; t = t->base) {
	 if (t->count > 0) m *= t->count;
       };
      tnm = DISP_expr_type_name(t,tbuf);
      sprintf(buf,"& ((%s *) 0x%x)[%d]",tnm,o,m);
    };

   DISP_get_value(typ->system,buf,tbuf);
   r = get_hex_value(tbuf);

   return (DISP_OBJECT) r;
};





/* end of dispapple.c */

