/************************************************************************/
/*									*/
/*		ddtfilter.c						*/
/*									*/
/*	This is a little filter to use our name demangler		*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/

#define NO_THREADS

#include "ddt_local.h"
#include "ddt_names.h"





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	Integer 	space_char;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		scanner();





/************************************************************************/
/*									*/
/*	main -- main program						*/
/*									*/
/************************************************************************/


main(argc,argv)
   Integer argc;
   String argv[];
{
   Integer i,j;

   space_char = ' ';
   j = 0;

   for (i = 1; i < argc; ++i) {
      if (argv[i][0] == '-' && argv[i][1] != 0) {
	 switch (argv[i][1]) {
	    case 'c' :
	       if (argv[i][2] == 0) space_char = ' ';
	       else space_char = argv[i][2];
	       break;
	    default :
	       fprintf(stderr,"ddtfilter [-cX] [infile [outfile]]\n");
	       exit(1);
	  };
       }
      else if (j == 0) {
	 if (argv[i][0] != '-') {
	    if (freopen(argv[i],"r",stdin) == NULL) {
	       fprintf(stderr,"Can't open input file %s\n",argv[i]);
	       exit(2);
	     };
	  };
	 ++j;
       }
      else if (j == 1) {
	 if (argv[i][0] != '-') {
	    if (freopen(argv[i],"w",stdout) == NULL) {
	       fprintf(stderr,"Can't open output file %s\n",argv[i]);
	       exit(3);
	     };
	  };
	 ++j;
       }
      else {
	 fprintf(stderr,"ddtfilter [-cX] [infile [outfile]]\n");
	 exit(4);
       };
    };

   scanner();
}






/************************************************************************/
/*									*/
/*	scanner -- scan words and demangle				*/
/*									*/
/************************************************************************/


static void
scanner()
{
   Character wbuf[10240];
   Integer ch;
   String p;
   DDT_MANGLE dm;
   Integer fg;

   p = NULL;
   fg = 0;

   while ((ch = getchar()) != EOF) {
      if (isalnum(ch) || ch == '$' || ch == '_') {
	 if (p == NULL) {
	    p = wbuf;
	    fg = 0;
	  };
	 *p++ = ch;
	 if (fg < 2) {
	    if (ch == '_') ++fg;
	    else fg = 0;
	  };
       }
      else {
	 if (p != NULL) {
	    *p = 0;
	    if (fg >= 2) {
	       dm = DDT_demangle_name(wbuf);
	       DDT_mangle_output(dm,wbuf);
	       free(dm);
	     };
	    if (space_char != ' ' && space_char != 0) {
	       for (p = wbuf; *p != 0; ++p) if (*p == ' ') *p = space_char;
	     };
	    fputs(wbuf,stdout);
	    p = NULL;
	    fg = 0;
	  };
	 putc(ch,stdout);
       };
    };

   if (p != NULL) {
      *p = 0;
      if (fg >= 2) {
	 dm = DDT_demangle_name(wbuf);
	 DDT_mangle_output(dm,wbuf);
       };
      fputs(wbuf,stdout);
    };
};





