/************************************************************************/
/*									*/
/*		ddtcplus12.c						*/
/*									*/
/*	C++ 1.2 mapping routines for the ddt debugger interface 	*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "ddt_local.h"
#include "ddt_names.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/






/************************************************************************/
/*									*/
/*	DDT_cplus12_init -- module initialization			*/
/*									*/
/************************************************************************/


void
DDT_cplus12_init()
{
};






/************************************************************************/
/*									*/
/*	DDT_cplus12_fix_function -- convert user function name to C++ name*/
/*									*/
/************************************************************************/


String
DDT_cplus12_fix_function(f,buf)
   String f;
   String buf;
{
   String s,t,p;
   Integer i,j;
   Character buf1[1024];
   String pfx;

   s = rindex(f,'`');
   if (s != NULL) {
      pfx = f;
      f = ++s;
    }
   else pfx = NULL;

   if ((t = index(f,':')) != NULL) {
      t = buf;
      *t++ = '_';
      for (s = f; *s != 0; ++s) {
	 if (*s != ':') *t++ = *s;
	 else {
	    if (s[1] == ':') ++s;            /* :: maps to :         */
	    *t++ = '_';
	  };
       };
      *t = 0;
      f = buf;
    };

   p = DDT_symbol_find_function(f);
   if (p == NULL && *f == '~') {
      sprintf(buf1,"_%s__dtor",&f[1]);
      p = DDT_symbol_find_function(buf1);
    }
   else if (p == NULL) {
      sprintf(buf1,"_%s__ctor",f);
      p = DDT_symbol_find_function(buf1);
    };

   if (p == NULL) {
      j = strlen(f);
      for (t = f; *t != 0; ++t) {
	 if (*t == '_') {
	    i = strlen(t);
	    if ((i&1) == 0 && strncmp(t,&t[i/2],i/2) == 0) {
	       strcpy(buf1,f);
	       strcpy(&buf1[j-i/2+1],"_ctor");
	     }
	    else if ((i&1) != 0 && t[i/2] == '_' && t[i/2+1] == '~' &&
			strncmp(&t[1],&t[i/2+2],i/2-1) == 0) {
	       strcpy(buf1,f);
	       strcpy(&buf1[j-i/2],"_dtor");
	     }
	    else continue;
	    p = DDT_symbol_find_function(buf1);
	    if (p != NULL) break;
	  };
       };
    };

   if (p != NULL) f = p;

   if (pfx != NULL) {
      strcpy(buf1,pfx);
      s = rindex(buf1,'`');
      ++s;
      *s = 0;
      strcat(buf1,f);
      strcpy(buf,buf1);
      f = buf;
    };

   return f;
};





/************************************************************************/
/*									*/
/*	DDT_cplus12_unfix_function -- convert C++ name to source name	*/
/*									*/
/************************************************************************/


String
DDT_cplus12_unfix_function(s)
   String s;
{
   String t,sp;
   Integer ct,fct;
   Boolean fg;

   if (s[0] == '_') {
      sp = &s[1];
      fg = FALSE;
      for ( ; ; ) {
	 ct = 0;
	 fct = 0;
	 for (t = sp; *t != 0; ++t) {
	    if (*t == '_' && t[1] != 0 && ct > 0 && DDT_symbol_inq_sue_name(sp,ct))
	       fct = ct;
	    ++ct;
	  };
	 if (fct == 0) break;
	 t = &sp[fct];
	 *t++ = ':';
	 sp = t;
	 fg = TRUE;
       };
      if (fg) s = &s[1];
    };

   if (strlen(s) > 6) {
      t = &s[strlen(s)-6];
      if (STREQL(t,":_ctor")) *t = 0;
      else if (STREQL(t,":_dtor")) {
	 t[1] = 0;
	 while (t > s) {
	    --t;
	    t[1] = t[0];
	    if (*t == ':') {
	       *t = '~';
	       break;
	     };
	  };
	 if (t == s) *t = '~';
       };
    };

   return s;
};





/************************************************************************/
/*									*/
/*	DDT_cplus12_fix_variable -- map user var to C++ name		*/
/*									*/
/************************************************************************/


String
DDT_cplus12_fix_variable(v,buf)
   String v;
   String buf;
{
   String t,p,f1,f2;
   Integer i;
   LOCATION cloc;
   Character fbuf[1024],hbuf[1024],vbuf[1024];
   Boolean colfg,lclfg;

   if (v[0] == '`') return v;

   if (DDT_symbol_inq_type_name(v)) return v;

   DDT_model_inq_location(&cloc);

   if (cloc.file == NULL) f1 = f2 = NULL;
   else {
      i = strlen(cloc.file);
      f1 = cloc.file;
      if (cloc.file[i-2] == '.' && cloc.file[i-1] == 'C') {
	 strncpy(fbuf,cloc.file,i-1);
	 fbuf[i-1] = '.';
	 fbuf[i] = 'c';
	 fbuf[i+1] = 0;
	 f2 = fbuf;
       }
      else f2 = NULL;
    };

   colfg = FALSE;
   if ((t = index(v,':')) != NULL) {
      colfg = TRUE;
      sprintf(buf,"_%s",v);
      for (t = buf; *t != 0; ++t) if (*t == ':') *t = '_';
      v = buf;
    };

   lclfg = FALSE;
   if (!colfg && cloc.func != NULL) {
      t = DDT_cplus12_fix_function(cloc.func,hbuf);
      p = DDT_symbol_find_fct_local(t,v,vbuf);
      if (strncmp(p,"_au",3) == 0 && isdigit(p[3])) {
	 lclfg = TRUE;
	 v = p;
       }
      else {
	 p = DDT_symbol_find_fct_local(t,"this",vbuf);
	 if (p[0] == '_') {
	    if (p != vbuf) strcpy(vbuf,p);
	    t = DDT_cplus12_fix_field(v,p,hbuf);
	    strcat(vbuf,"->");
	    strcat(vbuf,t);
	    if (DDT_x_valid_name(vbuf)) {
	       strcpy(hbuf,vbuf);
	       sprintf(vbuf,"(%s)",hbuf);
	       v = vbuf;
	       lclfg = TRUE;
	     };
	  };
       };
    };

   if (!lclfg) p = DDT_symbol_find_variable(v,f1,f2);

   t = rindex(v,'`');
   if (!lclfg && p == NULL && t != NULL) {
      strcpy(hbuf,v);
      p = rindex(hbuf,'`');
      *p = 0;
      p = DDT_cplus12_fix_function(hbuf,fbuf);
      ++t;
      v = DDT_symbol_find_fct_local(p,t,fbuf);
    }
   else if (p != NULL) v = p;

   return v;
};





/************************************************************************/
/*									*/
/*	DDT_cplus12_unfix_variable - convert name from C++ to user	*/
/*									*/
/************************************************************************/


String
DDT_cplus12_unfix_variable(v)
   String v;
{
   String u;

   if (strncmp(v,"_au",3) == 0 && isdigit(v[3])) {
      u = index(&v[1],'_');
      if (u != NULL) v = ++u;
    };

   return v;
};





/************************************************************************/
/*									*/
/*	DDT_cplus12_fix_field -- map a field name from user to C++	*/
/*									*/
/************************************************************************/


String
DDT_cplus12_fix_field(fld,lhs,buf)
   String fld;
   String lhs;
   String buf;
{
   String s,t,u,v,w;
   Integer i,j,k;
   Character ybuf[1024];

   if (lhs == NULL) return fld;

   if (!DDT_map_field_var_info(lhs,ybuf,TRUE)) return fld;
   s = ybuf;

   i = strlen(fld);

   s = index(s,'{');
   if (s == NULL) return fld;

   k = -1;
   w = NULL;

   while ((t = index(s,';')) != NULL) {
      s = t;
      *s++ = 0;
      j = 0;

      v = &t[-1];
      while (*v == ']') {
	 while (*v != '[') --v;
	 t = v;
	 *v-- = 0;
       };

      for ( ; isalnum(*v) || *v == '_' || *v == '$'; --v) ++j;
      ++v;
      u = &t[-i];
      if (j > i && u[-1] == '_' && strncmp(u,fld,i) == 0) {
	 if (i == j) return fld;
	 if (k < 0 || j-i < k) {
	    k = j-i;
	    w = v;
	  };
       };
    };

   if (w != NULL) {
      strcpy(buf,w);
      fld = buf;
    };

   return fld;
};





/************************************************************************/
/*									*/
/*	DDT_cplus12_unfix_field -- convert C++ field name to user name	*/
/*									*/
/************************************************************************/


String
DDT_cplus12_unfix_field(fld,lhs)
   String fld;
   String lhs;
{
   String s,t;
   Integer i;
   Character ybuf[1024];

   if (!DDT_map_field_var_info(lhs,ybuf,FALSE)) return fld;
   s = ybuf;

   s = index(s,' ');
   if (s == NULL) return fld;
   ++s;
   t = index(s,' ');
   if (t == NULL) return fld;
   *t = 0;
   i = strlen(s);

   if (*fld == '_' && strncmp(&fld[1],s,i) == 0 && fld[i+1] == '_') fld = &fld[i+2];

   return fld;
};






/************************************************************************/
/*									*/
/*	DDT_cplus12_find_fct_local -- find var as local in fct		*/
/*									*/
/************************************************************************/


String
DDT_cplus12_find_fct_local(var,lcls,buf)
   String var;
   Sequence lcls;
   String buf;
{
   String s,t;
   Sequence l;

   if (lcls != NULL) {
      if (strncmp(var,"_au",3) == 0 && isdigit(var[3])) {
	 s = &var[3];
	 while (isdigit(*s)) ++s;
	 if (*s == '_') lcls = NULL;
       };
    };

   forin (s,String,l,lcls) {
      if (strncmp(s,"_au",3) == 0 && isdigit(s[3])) {
	 t = &s[3];
	 while (isdigit(*t)) ++t;
	 if (*t++ == '_' && STREQL(t,var)) {
	    strcpy(buf,s);
	    var = buf;
	    break;
	  };
       };
    };

   return var;
};







/************************************************************************/
/*									*/
/*	DDT_cplus12_local_level -- return level number of local (or -1) */
/*									*/
/************************************************************************/


Boolean
DDT_cplus12_test_save_local(var)
   String var;
{
   if (strncmp(var,"_au",3) == 0 && isdigit(var[3])) {
      var = &var[3];
      while (isdigit(*var)) ++var;
      if (*var == '_') return TRUE;
    };

   return FALSE;
};






/* end of ddtcplus12.c */
