/************************************************************************/
/*									*/
/*		ddt_local.h						*/
/*									*/
/*	Local definitions for debugger interface			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	DDT__sema

#include <datatypes.h>
#include <sequence.h>

#include <auxd.h>
#include <msg.h>
#include <pmat.h>

#include <ddt.h>




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


extern	String		DDT__system_name;

extern	Boolean 	DDT__standalone;
extern	Boolean 	DDT__norun;
extern	Integer 	DDT__cplusplus;
extern	Boolean 	DDT__stdpascal;
extern	Boolean 	DDT__use_gdb;
extern	Integer 	DDT__picklevel;





/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/


#define NOCPLUSPLUS	0
#define CPLUSPLUS12	1
#define CPLUSPLUS20	2




typedef enum {
   EVENT_NONE,

   EVENT_TRACE,
   EVENT_BREAK,
   EVENT_TBREAK,
   EVENT_WATCH,
   EVENT_CALL,
   EVENT_EVENT,
   EVENT_TRIGGER,
   EVENT_STEPSTEP,
   EVENT_NEXTNEXT,
   EVENT_MONITOR,
   EVENT_UPDATE,
   EVENT_WHEN,
   EVENT_DISPLAY,
   EVENT_STOPEXIT,

} EVENT_ACTION;




typedef struct _LOCATION {
   String file;
   String func;
   Integer line;
} LOCATION;




typedef enum {
   STOP_UNDEFINED,

   STOP_CONTINUE,
   STOP_NEXT,
   STOP_STEP,
   STOP_STOP,
} STOP_ACTION;




/************************************************************************/
/*									*/
/*	Machine-dependent globals					*/
/*									*/
/************************************************************************/


#define SIGNAL_STOP		0x1
#define SIGNAL_PRINT		0x2
#define SIGNAL_PASS		0x4

#define SIGNAL_IGNORE		(SIGNAL_PASS)
#define SIGNAL_CATCH		(SIGNAL_STOP|SIGNAL_PRINT)
#define SIGNAL_PRINTIGN 	(SIGNAL_PRINT)
#define SIGNAL_PRINTUSE 	(SIGNAL_PASS|SIGNAL_PRINT)


typedef struct _SIGNAL_TABLE {
   String name;
   String desc;
   Integer flags;
} SIGNAL_TABLE;


extern	SIGNAL_TABLE	DDT__signal_table[];






/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* ddtmain.c			*/
extern	void		DDT_init();


					/* ddtrun.c			*/
extern	void		DDT_run_init();
extern	Boolean 	DDT_start_debug();
extern	Boolean 	DDT_stop_debug();
extern	Integer 	DDT_printf();
extern	void		DDT_send_interrupt();
extern	void		DDT_send_eof();
extern	Integer 	DDT_ddt_input();
extern	Integer 	DDT_user_input();
extern	void		DDT_user_eof();
extern	void		DDT_wait_debugger();



					/* ddtmonitor.c 		*/
extern	void		DDT_monitor_init();
extern	Boolean 	DDT_command_process();
extern	void		DDT_command_abort();


					/* ddtstate.c			*/
extern	void		DDT_state_init();
extern	void		DDT_state_loop();
extern	void		DDT_state_next();
extern	Boolean 	DDT_state_prompt();
extern	void		DDT_state_abort();
extern	void		DDT_state_stop_expected();
extern	void		DDT_state_user_level();
extern	void		DDT_state_stop_action();
extern	void		DDT_state_stop_signal();
extern	void		DDT_state_cmd_begin();
extern	void		DDT_state_cmd_end();
extern	void		DDT_state_cmd_abort();
extern	void		DDT_state_cmd_event();
extern	Boolean 	DDT_state_cmd_quiet();
extern	String		DDT_debug_command();
extern	String		DDT_debug_call_command();
extern	void		DDT_state_run_command();
extern	void		DDT_state_step_command();
extern	void		DDT_state_stop_run();
extern	Boolean 	DDT_state_user_reply();
extern	Boolean 	DDT_state_inq_run();
extern	void		DDT_state_msg();



					/* ddtmodel.c			*/
extern	void		DDT_model_init();
extern	void		DDT_model_clear();
extern	void		DDT_model_newsys();
extern	void		DDT_model_show_system();
extern	void		DDT_model_user_tty();
extern	void		DDT_model_default_tty();
extern	void		DDT_model_in_file();
extern	void		DDT_model_out_file();
extern	String		DDT_model_run_args();
extern	String		DDT_model_inq_in_file();
extern	String		DDT_model_inq_out_file();
extern	String		DDT_model_show_in_file();
extern	String		DDT_model_show_out_file();
extern	void		DDT_model_show_run();
extern	void		DDT_model_show_env();
extern	void		DDT_model_set_env();
extern	Integer 	DDT_model_signal_name();
extern	void		DDT_model_sigset();
extern	void		DDT_model_sig_status();
extern	void		DDT_model_use();
extern	void		DDT_model_show_use();
extern	String		DDT_model_real_name();
extern	String		DDT_model_default_file();
extern	void		DDT_model_set_location();
extern	void		DDT_model_inq_location();
extern	void		DDT_model_set_exec_location();
extern	void		DDT_model_inq_exec_location();
extern	Boolean 	DDT_valid_string();
extern	void		DDT_print_current_position();
extern	void		DDT_print_exec_position();
extern	void		DDT_print_position();
extern	void		DDT_position();
extern	Boolean 	DDT_model_check_file();
extern	void		DDT_model_list_files();
extern	void		DDT_model_list_functions();
extern	void		DDT_model_list_variables();
extern	void		DDT_model_list_types();



				/* ddtevent.c				*/
extern	void		DDT_event_init();
extern	void		DDT_event_clear();
extern	Boolean 	DDT_event_add();
extern	void		DDT_for_each_event();
extern	void		DDT_event_remove();
extern	void		DDT_event_change();
extern	void		DDT_event_disable();
extern	void		DDT_event_show();
extern	void		DDT_event_handle();
extern	String		DDT_event_name();
extern	EVENT_ACTION	DDT_event_type();
extern	Boolean 	DDT_event_process();
extern	void		DDT_event_stop();



				/* ddttrace.c				*/
extern	void		DDT_trace_init();
extern	Boolean 	DDT_trace_set_where();
extern	void		DDT_trace_print_where();
extern	void		DDT_trace_where();
extern	void		DDT_trace_where_top();
extern	void		DDT_trace_dump();
extern	void		DDT_trace_process();
extern	Boolean 	DDT_trace_check_if_in();




				/* ddtmsg.c				*/
extern	void		DDT_msg_init();
extern	void		DDT_output_define();
extern	void		DDT_output_set();
extern	void		DDT_msg_user_out();
extern	void		DDT_msg_debug_out();
extern	void		DDT_mprint();
extern	void		DDT_msg_focus();
extern	void		DDT_msg_at_line();
extern	void		DDT_msg_event();
extern	void		DDT_msg_value();
extern	void		DDT_msg_call();
extern	void		DDT_msg_return();
extern	void		DDT_msg_ie();
extern	void		DDT_msg_update();
extern	void		DDT_msg_when();
extern	void		DDT_msg_clear();
extern	void		DDT_msg_reset();
extern	void		DDT_msg_start_run();
extern	void		DDT_msg_stop_run();
extern	void		DDT_msg_where();
extern	void		DDT_msg_where_dump();
extern	void		DDT_msg_where_begin();
extern	void		DDT_msg_where_end();
extern	void		DDT_msg_system();
extern	void		DDT_msg_exit();


				/* ddtexpr.c				*/
extern	void		DDT_expr_init();
extern	String		DDT_expr_parse();



				/* ddtsyms.c				*/
extern	void		DDT_symbol_init();
extern	Boolean 	DDT_symbol_setup();
extern	void		DDT_symbol_free_info();
extern	Boolean 	DDT_symbol_funct_info();
extern	Integer 	DDT_symbol_funct_table();
extern	void		DDT_symbol_main_program();
extern	Boolean 	DDT_symbol_check_dates();
extern	Integer 	DDT_symbol_files();
extern	Integer 	DDT_symbol_functions();
extern	Integer 	DDT_symbol_funnames();
extern	Integer 	DDT_symbol_variables();
extern	Integer 	DDT_symbol_variable_count();
extern	Integer 	DDT_symbol_types();
extern	Boolean 	DDT_symbol_inq_type_name();
extern	String		DDT_symbol_fix_file_name();
extern	String		DDT_symbol_fct_from_file();
extern	String		DDT_symbol_find_function();
extern	Boolean 	DDT_symbol_inq_sue_name();
extern	String		DDT_symbol_find_variable();
extern	String		DDT_symbol_find_fct_local();
extern	Boolean 	DDT_symbol_type_data();
extern	Boolean 	DDT_symbol_var_data();
extern	void		DDT_symbol_dump_globals();
extern	String		DDT_symbol_dynamic_type();


				/* ddtcplus.c				*/
extern	void		DDT_map_init();
extern	String		DDT_map_fix_function();
extern	String		DDT_map_member_function();
extern	String		DDT_map_unfix_function();
extern	String		DDT_map_fix_variable();
extern	String		DDT_map_unfix_variable();
extern	String		DDT_map_fix_field();
extern	String		DDT_map_unfix_field();
extern	String		DDT_map_fix_outexpr();
extern	String		DDT_map_find_fct_local();
extern	Boolean 	DDT_map_test_save_local();


				/* ddt<machine>.c			*/
extern	void		DDT_x_init();
extern	String		DDT_x_debugger_name();
extern	String		DDT_x_debugger_path();
extern	Boolean 	DDT_x_check_prompt();
extern	Boolean 	DDT_x_check_query();
extern	void		DDT_x_startup();
extern	Boolean 	DDT_x_system_info();
extern	Boolean 	DDT_x_run_monitor();
extern	Boolean 	DDT_x_add_event();
extern	Boolean 	DDT_x_remove_event();
extern	Boolean 	DDT_x_assign();
extern	Boolean 	DDT_x_call();
extern	Boolean 	DDT_x_continue();
extern	Boolean 	DDT_x_current_line();
extern	Boolean 	DDT_x_current_addr();
extern	Boolean 	DDT_x_dump();
extern	Boolean 	DDT_x_kill();
extern	Boolean 	DDT_x_list();
extern	Boolean 	DDT_x_print();
extern	Boolean 	DDT_x_eval();
extern	Boolean 	DDT_x_quit();
extern	Boolean 	DDT_x_reinit();
extern	Boolean 	DDT_x_run();
extern	Boolean 	DDT_x_search();
extern	Boolean 	DDT_x_set_context();
extern	void		DDT_x_set_env();
extern	void		DDT_x_set_option();
extern	Boolean 	DDT_x_set_view();
extern	void		DDT_x_show();
extern	Boolean 	DDT_x_sigset();
extern	Boolean 	DDT_x_step();
extern	void		DDT_x_stop();
extern	Boolean 	DDT_x_updown();
extern	Boolean 	DDT_x_use();
extern	Boolean 	DDT_x_valid_name();
extern	Boolean 	DDT_x_var_info();
extern	Boolean 	DDT_x_where();

extern	void		DDT_lang_init();
extern	void		DDT_lang_loop();
extern	void		DDT_lang_startup();

extern	void		DDT_input_initialize();
extern	void		DDT_input_set_function();
extern	void		DDT_input_set_delimiter();
extern	void		DDT_input_set_literal();
extern	void		DDT_input_set_prompt();
extern	void		DDT_input_set_alias();
extern	void		DDT_input_set_var();
extern	void		DDT_input_source();
extern	void		DDT_input_enqueue();
extern	void		DDT_input_flush();
extern	String		DDT_input_line();





/* end of ddt_local.h */
