/************************************************************************/
/*									*/
/*		dbgmain.c						*/
/*									*/
/*	General routines for debugger interface 			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "dbg_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	dbg_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	DBG_init -- package initialization				*/
/*									*/
/************************************************************************/


void
DBG_init()
{
   PROT_INIT;
   PROTECT;
   if (!dbg_inited) {
      dbg_inited = TRUE;
      DBG_win_init();
      DBG_btn_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	DBGnew_willow_window -- create a new willow window		*/
/*									*/
/************************************************************************/


int
DBGnew_willow_window(w,name)
   ASH_WINDOW w;
   String name;
{
   register DBG_WIN dw;
   Character buf[1024];
   String file,cfile;

   DBG_init();

   if (name != NULL) {
      strcpy(buf,name);
      name = buf;
      file = index(buf,' ');
      if (file != NULL) {
	 *file++ = 0;
	 while (isspace(*file)) ++file;
	 cfile = index(file,' ');
	 if (cfile != NULL) {
	    *cfile++ = 0;
	    while (isspace(*cfile)) ++cfile;
	  }
	 else if (*file == 0) file = NULL;
       }
      else if (*name == 0) name = NULL;
    };

   dw = DBG_create(w,name,file,cfile);

   return (dw != NULL);
};





/************************************************************************/
/*									*/
/*	DBGnew_window -- create a new debugging window			*/
/*									*/
/************************************************************************/


int
DBGnew_window(w,typ,file,core)
   ASH_WINDOW w;
   String typ;
   String file;
   String core;
{
   register DBG_WIN dw;

   DBG_init();

   dw = DBG_create(w,typ,file,core);

   return (dw != NULL);
};





/************************************************************************/
/*									*/
/*	DBG_exit -- handle exit requests				*/
/*									*/
/************************************************************************/


void
DBG_exit(dw)
   DBG_WIN dw;
{
   if (dw->window == ASHinq_top()) exit(0);

   ASHremove(dw->window);
};





/* end of dbgmain.c */
