/************************************************************************/
/*									*/
/*		cbrowmenu.c						*/
/*									*/
/*	Menu and button routines for class browser			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "cbrow_local.h"




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	int		cbrow_menu_browse();
static	int		cbrow_menu_display();
static	int		cbrow_menu_layout();
static	int		cbrow_menu_info();
static	int		cbrow_menu_select();
static	int		cbrow_menu_regex();
static	int		cbrow_menu_membs();
static	int		cbrow_btn_handler();
static	Boolean 	cbrow_class_handler();
static	Boolean 	cbrow_memb_handler();
static	Boolean 	cbrow_hier_handler();
static	void		show_class_info();
static	void		show_memb_info();
static	void		show_hier_info();
static	Integer 	add_field();
static	void		query_member();
static	void		reset_btns();
static	String		fix_dialog();





/************************************************************************/
/*									*/
/*	Tables -- menu definitions					*/
/*									*/
/************************************************************************/


static STEM_PDM_DATA	cbrow_menus[] = {
   { STEM_PSTATE_MENU,	"Browse",       NULL },
      { STEM_PSTATE_BTN,   "Info Window",  cbrow_menu_info },
      { STEM_PSTATE_BTN,   "Restart",   cbrow_menu_browse },
      { STEM_PSTATE_BTN,   "Update",    cbrow_menu_browse },
      { STEM_PSTATE_BTN,   "Set System",  cbrow_menu_browse },
      { STEM_PSTATE_BTN,   "Quit",      cbrow_menu_browse },

   { STEM_PSTATE_MENU, "Selection",      NULL },
      { STEM_PSTATE_BTN,   "Set Class", cbrow_menu_browse },
      { STEM_PSTATE_BTN,   "Clear Class", cbrow_menu_browse },
      { STEM_PSTATE_BTN,   "Select Class",  cbrow_menu_select },
      { STEM_PSTATE_BTN,   "Class Patterns",  cbrow_menu_regex },
      { STEM_PSTATE_BTN,   "Member Patterns",  cbrow_menu_membs },

   { STEM_PSTATE_MENU|STEM_PSTATE_COMPLEX,  "Display",      NULL },
      { STEM_PSTATE_BTN,   "Options",   cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Show All",  cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Show Friends", cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Public Only", cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Show Data", cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Show Functions", cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Show Inherited", cbrow_menu_display },
      { STEM_PSTATE_BTN,   "Layout",    cbrow_menu_layout },

   { STEM_PSTATE_END }
};





/************************************************************************/
/*									*/
/*	CBROW_menu_init -- module initialization			*/
/*									*/
/************************************************************************/


void
CBROW_menu_init()
{
};





/************************************************************************/
/*									*/
/*	CBROW_menu_setup -- setup button handling			*/
/*									*/
/************************************************************************/


void
CBROW_menu_setup(cw)
   CBROW_WIN cw;
{
   if (cw->menu_win != NULL) {
      STEMpdm_define(cw->menu_win,cw,cbrow_menus);
    };

   cw->region = RIPdefine_region(cw->disp_win,0,0,0,0,RIP_ALL_CHARS,
				    RIP_BTN_ANY_EITHER,
				    cbrow_btn_handler,
				    ASH_SENSE_NO_CHANGE);
   RIPuse_local_window(cw->region);
   RIPset_data(cw->region,cw);

   reset_btns(cw);
};





/************************************************************************/
/*									*/
/*	cbrow_menu_browse -- handle browse menu options 		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_browse(cw,menu,btn)
   CBROW_WIN cw;
   String menu;
   String btn;
{
   String s;
   Character cls[256];
   CBROW_CLASS cc;

   if (STREQL(btn,"Reset")) {
      CBROW_disp_reset(cw);
      CBROW_disp_redraw(cw);
    }
   else if (STREQL(btn,"Update")) {
      ASHinput_lock_makelong(cw->window);
      MSGcalla("XREF RELOAD %s",cw->system);
      CBROW_class_setup(cw);
      CBROW_disp_redraw(cw);
    }
   else if (STREQL(btn,"Reload")) {
      ASHinput_lock_makelong(cw->window);
      CBROW_class_setup(cw);
      CBROW_disp_redraw(cw);
    }
   else if (STREQL(btn,"Set Class")) {
      cc = NULL;
      s = "%CClass Browser\n\nShow Class: %0.48t\n\n   %a%M   %c";
      if (cw->display == NULL) cls[0] = 0;
      else strcpy(cls,cw->display->name);
      while (cc == NULL) {
	 if (!STEMdialog1(cw->window,s,cls)) return FALSE;
	 cc = CBROW_class_find(cw,cls);
       };
      cc->ignore = FALSE;
      CBROW_disp_current(cw,cc,NULL,NULL,TRUE);
    }
   else if (STREQL(btn,"Clear Class")) {
      CBROW_disp_current(cw,NULL,NULL,NULL,FALSE);
    }
   else if (STREQL(btn,"Set System")) {
      if (cw->system == NULL) strcpy(cls,"");
      else strcpy(cls,cw->system);
      if (!FIELDsystem_request(cw->window,"Class Browser",cls)) return FALSE;
      if (cls[0] == 0 || STREQL(cls,"*")) return FALSE;
      cw->system = SALLOC(cls);
      ASHinput_lock_makelong(cw->window);
      sprintf(cls,"cbrowse: %s",cls);
      ASHset_window_name(cw->window,cls);
      CBROW_class_setup(cw);
      CBROW_disp_redraw(cw);
    }
   else if (STREQL(btn,"Quit")) {
      ASHremove(cw->window);
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_display -- handle display options			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_display(cw,mnm,bnm)
   CBROW_WIN cw;
   String mnm;
   String bnm;
{
   String menu[10240],buf[1024];
   Integer v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17;

   if (STREQL(bnm,"Show All")) {
      cw->display_all = !cw->display_all;
    }
   else if (STREQL(bnm,"Show Friends")) {
      cw->dclass_friend = !cw->dclass_friend;
    }
   else if (STREQL(bnm,"Public Only")) {
      cw->dmemb_public = !cw->dmemb_public;
    }
   else if (STREQL(bnm,"Show Data")) {
      cw->dmemb_data = !cw->dmemb_data;
    }
   else if (STREQL(bnm,"Show Functions")) {
      cw->dmemb_method = !cw->dmemb_method;
    }
   else if (STREQL(bnm,"Show Inherited")) {
      cw->dmemb_inher = !cw->dmemb_inher;
    }
   else {
      strcpy(menu,"%CClass Browser Display Options\n\n");

      strcat(menu,"Class Selection\n\n");

      strcat(menu,"   %0o Show all classes\n\n");
      v0 = cw->display_all;

      strcat(menu,"   %15o Force redisplay on selection\n\n");
      v15 = cw->display_force;

      strcat(menu,"   %1o Show superclasses\n   %2o Show subclasses\n");
      v1 = cw->display_super;
      v2 = cw->display_sub;

      sprintf(buf,"      Levels: %%3.%uo All   %%3.0o None   %%3.1o Single   %%3.6d\n\n",-1);
      strcat(menu,buf);
      v3 = cw->display_levels;

      strcat(menu,"   %14o Expand size of selected class\n\n");
      v14 = cw->dclass_fixcur;

      strcat(menu,"   %4o Show friends%M%5o Show hierarchy\n\n");
      v4 = cw->dclass_friend;
      v5 = cw->dclass_hier;

      strcat(menu,"   Show selection:  %6.0o Normal   %6.2o Emphasize   Factor: %6.6d\n\n");
      v6 = cw->dclass_zoom;

      strcat(menu,"Member Selection\n\n");

      strcat(menu,"   %12o Show member details%M%13o Show member links\n");
      v12 = cw->dclass_detail;
      v13 = cw->dmemb_links;

      strcat(menu,"   %16o Show member state information\n");
      v16 = cw->dmemb_state;

      strcat(menu,"   %17o Show full member names\n");
      v17 = cw->dmemb_fullnames;

      strcat(menu,"   %7o Show no members\n");
      v7 = cw->dclass_simple;

      strcat(menu,"   %8o Only show public members\n");
      v8 = cw->dmemb_public;

      strcat(menu,"   %9o Show data members%M%10o Show function members\n");
      v9 = cw->dmemb_data;
      v10 = cw->dmemb_method;

      strcat(menu,"   %11o Show inherited members\n\n");
      v11 = cw->dmemb_inher;

      strcat(menu,"   %a%M   %c");

      if (!STEMdialog1(cw->window,menu,&v0,&v1,&v2,&v3,&v4,&v5,&v6,
			  &v7,&v8,&v9,&v10,&v11,&v12,&v13,&v14,&v15,&v16,&v17))
	 return FALSE;

      if (v6 <= 0) v6 = 1;

      cw->display_all = v0;
      cw->display_super = v1;
      cw->display_sub = v2;
      cw->display_levels = v3;
      cw->dclass_friend = v4;
      cw->dclass_hier = v5;
      cw->dclass_zoom = v6;
      cw->dclass_simple = v7;
      cw->dmemb_public = v8;
      cw->dmemb_data = v9;
      cw->dmemb_method = v10;
      cw->dmemb_inher = v11;
      cw->dclass_detail = v12;
      cw->dmemb_links = v13;
      cw->dclass_fixcur = v14;
      cw->display_force = v15;
      cw->dmemb_state = v16;
      cw->dmemb_fullnames = v17;
    };

   CBROW_disp_redraw(cw);

   reset_btns(cw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_layout -- handle display layout options menu 	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_layout(cw,mnm,btn)
   CBROW_WIN cw;
   String mnm;
   String btn;
{
   Integer fix,std,cen,mthd,cmthd,white;

   fix = cw->fixed;
   std = cw->standard;
   cen = cw->centered;

   if (!GELOrequest_layout_methods(cw->window,&cw->method,&cw->connmethod,
				      &fix,&std,&cen,&cw->whitespace))
      return FALSE;

   cw->fixed = fix;
   cw->standard = std;
   cw->centered = cen;

   CBROW_disp_redraw(cw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_info -- handle request for information window	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_info(cw,mnm,bnm)
   CBROW_WIN cw;
   String mnm;
   String bnm;
{
   ASH_WINDOW w;

   if (cw->text_win == NULL) {
      CBROW_info_setup(cw);
    }
   else {
      for (w = cw->text_win; ASHinq_parent(w) != NULL; w = ASHinq_parent(w));
      ASHvisible(w,TRUE);
      ASHpop(w);
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_select -- handle select class menu			*/
/*									*/
/************************************************************************/

#define MAX_CLASS		32



static int
cbrow_menu_select(cw,mnm,bnm)
   CBROW_WIN cw;
   String mnm;
   String bnm;
{
   Character menu[20480],buf[1024];
   Integer i,j,k,st,ct;
   CBROW_CLASS cc;
   Integer ignfg[(MAX_CLASS+16)/16],cur,show;
   CBROW_CLASS * cls;

   ct = 0;
   for (cc = cw->classes; cc != NULL; cc = cc->next) ++ct;
   cls = (CBROW_CLASS *) alloca(sizeof(CBROW_CLASS)*(ct+2));
   ct = 0;
   for (cc = cw->classes; cc != NULL; cc = cc->next) cls[ct++] = cc;
   qsort(cls,ct,sizeof(CBROW_CLASS),CBROW_class_compare);

   if (STREQL(bnm,"Select Class")) st = 0;
   else if (isdigit(bnm[0])) st = atol(bnm);

   if (ct == 0) return FALSE;

   strcpy(menu,"%CView Classes\n\nIgnore   Class%MIgnore   Class");

   for (i = 0; i < (MAX_CLASS+16)/16; ++i) ignfg[i] = 0;
   cur = -1;

   for (i = st; i < ct && i-st < MAX_CLASS; ++i) {
      cc = cls[i];
      j = (i-st) % 16;
      k = (i-st) / 16;
      if (i & 1) strcat(menu,"   %M");
      else strcat(menu,"\n   ");
      sprintf(buf,"%%%d.%df   %%0.%d\"%s\"b",k+2,(1 << j),i,cc->name);
      strcat(menu,buf);
      if (cc->ignore) ignfg[k] |= (1 << j);
      if (cw->display == cc) cur = i;
    };

   strcat(menu,"\n\n");
   show = 0;
   if (st != 0 || i < ct) {
      if (st != 0) strcat(menu,"   %1.1\"Previous Classes\"a");
      if (i < ct) strcat(menu,"%M%1.2\"More Classes\"a");
      strcat(menu,"\n\n");
    };

   strcat(menu,"      %a%M   %c");

   if (!STEMdialog1(cw->window,menu,&cur,&show,&ignfg[0],&ignfg[1],&ignfg[2],&ignfg[3]))
      return FALSE;

   for (i = st; i < ct && i-st < MAX_CLASS; ++i) {
      cc = cls[i];
      j = (i-st) % 16;
      k = (i-st) / 16;
      if ((ignfg[k] & (1 << j)) != 0) cc->ignore = TRUE;
      else cc->ignore = FALSE;
    };
   if (cur >= 0) cw->display = cls[cur];

   if (show != 0) {
      if (show == 1) {
	 st -= MAX_CLASS;
	 if (st < 0) st = 0;
       }
      else {
	 st += MAX_CLASS;
	 if (st >= ct) st = ct-2;
       };
      sprintf(buf,"%d",st);
      if (cbrow_menu_select(cw,mnm,buf)) return TRUE;
    };

   CBROW_disp_redraw(cw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_regex -- regular expression selection		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_regex(cw,mnm,bnm)
   CBROW_WIN cw;
   String mnm;
   String bnm;
{
   Character menu[20480];
   Character ibuf[128],ebuf[128];
   Integer exfg,infg;
   CBROW_CLASS cc;

   strcpy(menu,"%CRegular Expression Class Selection\n\n");

   strcat(menu,"Include classes: %0.48.128t\n");
   strcat(menu,"   %2o Exclude all others\n\n");

   strcat(menu,"Exclude classes: %1.48.128t\n");
   strcat(menu,"   %3o Include all others\n\n");

   strcat(menu,"   %a%M   %c");

   ebuf[0] = 0;
   ibuf[0] = 0;
   exfg = FALSE;
   infg = FALSE;

   if (!STEMdialog1(cw->window,menu,ibuf,ebuf,&exfg,&infg)) return FALSE;

   CBROW_disp_class_regex(cw,ibuf,exfg,ebuf,infg);

   CBROW_disp_redraw(cw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_menu_membs -- regular expression selection of members	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_menu_membs(cw,mnm,bnm)
   CBROW_WIN cw;
   String mnm;
   String bnm;
{
   Character menu[20480];
   Character ibuf[128],ebuf[128],cbuf[128];
   Integer exfg,infg,alfg;
   CBROW_CLASS cc;
   CBROW_MEMB cm;

   strcpy(menu,"%CRegular Expression Member Selection\n\n");

   strcat(menu,"Include members: %0.48.128t\n");
   strcat(menu,"   %2o Exclude all others\n\n");

   strcat(menu,"Exclude members: %1.48.128t\n");
   strcat(menu,"   %3o Include all others\n\n");

   strcat(menu,"For classes:     %5.48.128t\n");
   strcat(menu,"   %4o For all classes\n\n");

   strcat(menu,"   %a%M   %c");

   ebuf[0] = 0;
   ibuf[0] = 0;
   exfg = FALSE;
   infg = FALSE;
   cbuf[0] = 0;
   alfg = TRUE;

   if (!STEMdialog1(cw->window,menu,ibuf,ebuf,&exfg,&infg,&alfg,cbuf)) return FALSE;

   CBROW_disp_member_regex(cw,cbuf,ibuf,exfg,ebuf,infg);

   CBROW_disp_redraw(cw);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_btn_handler -- handle hits in cbrow window		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
cbrow_btn_handler(x,y,ch,btn,rgn)
   Integer x,y;
   Integer ch;
   Integer btn;
   RIP_REGION rgn;
{
   CBROW_WIN cw;
   GELO_OBJECT go;
   Boolean fg;
   static Integer xtrinfo = 0;
   static GELO_OBJECT downobj = NULL;

   cw = (CBROW_WIN) RIPinq_data(rgn);
   if (cw == NULL || cw->window == NULL) return FALSE;

   if (btn & RIP_BTN_NONE) {
      xtrinfo = 0;
      downobj = NULL;
      switch (ch) {
	 case 'r' :
	    CBROW_disp_redraw(cw);
	    break;
	 case 'R' :
	    CBROW_disp_reset(cw);
	    CBROW_disp_redraw(cw);
	    break;
	 case 'c' :
	 case 'C' :
	    CBROW_disp_current(cw,NULL,NULL,NULL,FALSE);
	    break;
	 case 'a' :
	 case 'A' :
	    cw->display_all = !cw->display_all;
	    CBROW_disp_redraw(cw);
	    break;
	 default :
	    return FALSE;
       };

      return TRUE;
    };

   if (btn & RIP_BTN_TAP) {
      xtrinfo = 0;
      downobj = NULL;
    }
   else if (btn & RIP_BTN_DOWN) {
      downobj = GELOcorrelate(cw->disp_win,x,y);
      xtrinfo = btn & RIP_BTN_EXTRA;
      return FALSE;
    }
   else if (btn & RIP_BTN_UP) {
      btn |= xtrinfo;
    };

   go = GELOcorrelate(cw->disp_win,x,y);

   if (go == NULL || (downobj != NULL && downobj != go)) return FALSE;

   switch (GELOinq_contents(go)) {
      case 0 :
	 fg = cbrow_class_handler(cw,go,btn);
	 break;
      case 1 :
	 fg = cbrow_memb_handler(cw,go,btn);
	 break;
      case 2 :
	 fg = cbrow_hier_handler(cw,go,btn);
	 break;
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	cbrow_class_handler -- handle hits on class object		*/
/*									*/
/************************************************************************/


static Boolean
cbrow_class_handler(cw,go,btn)
   CBROW_WIN cw;
   GELO_OBJECT go;
   Integer btn;
{
   CBROW_CLASS cc;
   String s;

   cc = (CBROW_CLASS) GELOinq_user_structure(go);
   if (cc == NULL) return FALSE;

   if ((btn & RIP_BTN_EXTRA) == 0) {
      if (btn & RIP_BTN_RIGHT) s = "RIGHT";
      else if (btn & RIP_BTN_LEFT) s = "LEFT";
      else s = "MID";
    }
   else s = NULL;

   if ((btn & RIP_BTN_EXTRA) != 0 && (btn & RIP_BTN_LEFT) != 0) {
      cc->ignore = TRUE;
      CBROW_disp_redraw(cw);
    }
   else {
      if (s != NULL) MSGsenda("XREF SET %s %d %s",cc->file,cc->line,s);
      if ((btn & RIP_BTN_MID) != 0) {
	 show_class_info(cw,cc);
       }
      else CBROW_disp_current(cw,cc,NULL,NULL,TRUE);
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	cbrow_memb_handler -- handle hits on class member		*/
/*									*/
/************************************************************************/


static Boolean
cbrow_memb_handler(cw,go,btn)
   CBROW_WIN cw;
   GELO_OBJECT go;
   Integer btn;
{
   CBROW_MEMB cm;
   String s;
   String file;
   Integer line;

   cm = (CBROW_MEMB) GELOinq_user_structure(go);
   if (cm == NULL) return FALSE;

   if (cm->line != 0 && cm->file != NULL && (btn & RIP_BTN_EXTRA) == 0) {
      file = cm->file;
      line = cm->line;
      if (btn & RIP_BTN_RIGHT) {
	 s = "RIGHT";
	 if (cm->deffile != NULL && cm->defline > 0) {
	    file = cm->deffile;
	    line = cm->defline;
	  };
       }
      else if (btn & RIP_BTN_LEFT) s = "LEFT";
      else s = "MID";

      MSGsenda("XREF SET %s %d %s",file,line,s);
    };

   if ((btn & RIP_BTN_MID) != 0) {
      show_memb_info(cw,cm);
    }
   else if ((btn & RIP_BTN_LEFT) != 0) {
      CBROW_disp_current(cw,cm->cls,cm,NULL,TRUE);
    }
   else {
      CBROW_disp_member(cw,cm);
    };

   return TRUE;
};






/************************************************************************/
/*									*/
/*	cbrow_hier_handler -- handle hits on class hierarchy arc	*/
/*									*/
/************************************************************************/


static Boolean
cbrow_hier_handler(cw,go,btn)
   CBROW_WIN cw;
   GELO_OBJECT go;
   Integer btn;
{
   CBROW_HIER ch;
   CBROW_CLASS cc;
   String s;

   ch = (CBROW_HIER) GELOinq_user_structure(go);
   if (ch == NULL) return FALSE;

   if (ch->line != 0 && ch->file != NULL && (btn & RIP_BTN_EXTRA) == 0) {
      if (btn & RIP_BTN_LEFT) s = "LEFT";
      else if (btn & RIP_BTN_MID) s = "MID";
      else s = "RIGHT";
      MSGsenda("XREF SET %s %d %s",ch->file,ch->line,s);
    };

   if ((btn & RIP_BTN_MID) != 0) {
      show_hier_info(cw,ch);
    }
   else {
      if ((btn & RIP_BTN_LEFT) != 0) cc = ch->sub;
      else cc = ch->super;
      CBROW_disp_current(cw,cc,NULL,NULL,TRUE);
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	show_class_info -- show information about a class		*/
/*									*/
/************************************************************************/


#define MAX_INFO	25

static void
show_class_info(cw,cc)
   CBROW_WIN cw;
   CBROW_CLASS cc;
{
   Character menu[20480],buf[1024],xbuf[1024];
   Universal ptrs[MAX_INFO];
   Integer typ[MAX_INFO];
   Integer i,j,k,ct,mct;
   Integer more,cur,ign;
   CBROW_HIER ch;
   CBROW_MEMB cm;
   CBROW_CLASS occ;
   CBROW_MEMB dmem[MAX_INFO];

   if (cc == NULL) return;
   MSGsenda("XREF SET %s %d MID",cc->file,cc->line);

   ct = 1;
   ptrs[0] = NULL;
   typ[0] = -1;
   more = 0;

   if (cc->isabstract) {
      sprintf(menu,"%%CAbstract Class %s\n\n",cc->name);
    }
   else {
      sprintf(menu,"%%CClass %s\n\n",cc->name);
    };

   if (cc->line > 0) {
      sprintf(buf,"Defined at line %d",cc->line);
      if (cc->file != NULL) {
	 strcat(buf," of file ");
	 strcat(buf,cc->file);
       };
      strcat(menu,buf);
      strcat(menu,"\n");
    };

   cur = FALSE;
   ign = cc->ignore;
   if (cw->display != cc) {
      occ = cw->display;
      strcat(menu,"   %1\"Make current\"b%M%2\"No Display\"b\n");
    };
   strcat(menu,"\n");

   i = 0;
   for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
      if (!ch->isfriend && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Supertypes:\n");
	 ptrs[ct] = (Universal) ch->super;
	 typ[ct] = 0;
	 sprintf(buf,"   %%0.%do %s",ct,ch->super->name);
	 j = add_field(buf,ch->ispublic,"PUBLIC",0);
	 j = add_field(buf,ch->isvirtual,"VIRTUAL",j);
	 j = add_field(buf,ch->super->isabstract,"ABSTRACT",j);
	 add_field(buf,TRUE,NULL,j);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   i = 0;
   for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
      if (!ch->isfriend && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Subtypes:\n");
	 ptrs[ct] = (Universal) ch->sub;
	 typ[ct] = 0;
	 sprintf(buf,"   %%0.%do %s",ct,ch->sub->name);
	 j = add_field(buf,ch->ispublic,"PUBLIC",0);
	 j = add_field(buf,ch->isvirtual,"VIRTUAL",j);
	 add_field(buf,TRUE,NULL,j);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   i = 0;
   for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
      if (ch->isfriend && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Friends:\n");
	 ptrs[ct] = (Universal) ch->super;
	 typ[ct] = 0;
	 sprintf(buf,"   %%0.%do %s\n",ct,ch->super->name);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   i = 0;
   for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
      if (ch->isfriend && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Friends of:\n");
	 ptrs[ct] = (Universal) ch->sub;
	 typ[ct] = 0;
	 sprintf(buf,"   %%0.%do %s\n",ct,ch->sub->name);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   mct = 0;
   for (cm = cc->members; cm != NULL; cm = cm->next) {
      if (mct < MAX_INFO) dmem[mct++] = cm;
    };

   qsort(dmem,mct,sizeof(CBROW_MEMB),CBROW_member_compare);

   i = 0;
   for (k = 0; k < mct; ++k) {
      cm = dmem[k];
      if (cm->isdata && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Data members:\n");
	 ptrs[ct] = (Universal) cm;
	 typ[ct] = 1;
	 sprintf(buf,"   %%0.%do %s",ct,fix_dialog(cm->defpname,xbuf));
	 j = add_field(buf,cm->isprivate,"PRIVATE",0);
	 j = add_field(buf,cm->isprotected,"PROTECTED",j);
	 j = add_field(buf,cm->isstatic,"STATIC",j);
	 j = add_field(buf,cm->isconst,"CONST",j);
	 add_field(buf,TRUE,NULL,j);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   i = 0;
   for (k = 0; k < mct; ++k) {
      cm = dmem[k];
      if (!cm->isdata && ct < MAX_INFO) {
	 if (i++ == 0) strcat(menu,"Function members:\n");
	 ptrs[ct] = (Universal) cm;
	 typ[ct] = 1;
	 sprintf(buf,"   %%0.%do %s",ct,fix_dialog(cm->defpname,xbuf));
	 j = add_field(buf,cm->isprivate,"PRIVATE",0);
	 j = add_field(buf,cm->isprotected,"PROTECTED",j);
	 j = add_field(buf,cm->isinline,"INLINE",j);
	 j = add_field(buf,cm->isfriend,"FRIEND",j);
	 j = add_field(buf,cm->isvirtual,"VIRTUAL",j);
	 j = add_field(buf,cm->isstatic,"STATIC",j);
	 j = add_field(buf,cm->ispure,"PURE",j);
	 j = add_field(buf,cm->isconst,"CONST",j);
	 add_field(buf,TRUE,NULL,j);
	 strcat(menu,buf);
	 ++ct;
       };
    };
   if (i > 0) strcat(menu,"\n");

   strcat(menu,"   %a%M   %c");

   if (!STEMdialog1(cw->window,menu,&more,&cur,&ign)) return;

   if (more > 0) {
      if (typ[more] == 0) show_class_info(cw,ptrs[more]);
      else if (typ[more] == 1) {
	 CBROW_disp_member(cw,ptrs[more]);
	 show_memb_info(cw,ptrs[more]);
       };
    };

   if (cur && cw->display == occ) {
      CBROW_disp_current(cw,cc,NULL,NULL,TRUE);
    };

   if (ign) {
      cc->ignore = TRUE;
      CBROW_disp_redraw(cw);
    };
};






/************************************************************************/
/*									*/
/*	show_memb_info -- show information about a class member 	*/
/*									*/
/************************************************************************/


static void
show_memb_info(cw,cm)
   CBROW_WIN cw;
   CBROW_MEMB cm;
{
   Character menu[10240],buf[1024],xbuf[1024];
   String s;
   Integer show,showdef;

   if (cm == NULL) return;
   MSGsenda("XREF SET %s %d MID",cm->file,cm->line);

   if (cm->isdata && cm->isstatic) s = "Static data member";
   else if (cm->isdata) s = "Data member";
   else if (cm->isfriend) s = "Friend function";
   else if (cm->ispure) s= "Pure virtual function";
   else s = "Function member";

   sprintf(menu,"%%C%s %s of class %s\n\n",s,fix_dialog(cm->pname,xbuf),cm->cls->name);

   if (cm->line > 0) {
      sprintf(buf,"Declared at line %d",cm->line);
      if (cm->file != NULL) {
	 strcat(buf," of file ");
	 strcat(buf,cm->file);
       };
      strcat(menu,buf);
      strcat(menu,"\n\n");
    };

   showdef = FALSE;
   query_member(cw,cm,buf);
   if (buf[0] != 0) {
      strcat(menu,buf);
      strcat(menu,"\n");
      showdef = (cm->deffile != NULL && cm->defline > 0);
    };

   if (cm->isprivate) s = "private";
   else if (cm->isprotected) s = "protected";
   else s = "public";
   if (cm->isdata || !cm->isfriend) {
      sprintf(buf,"Access Level:  %s\n\n",s);
      strcat(menu,buf);
    };

   strcat(menu,"Properties:  ");
   if (cm->isinline) strcat(menu,"inline ");
   if (cm->ispure) strcat(menu,"pure ");
   if (cm->isvirtual) strcat(menu,"virtual ");
   if (cm->isstatic) strcat(menu,"static ");
   if (cm->isconst) strcat(menu,"const ");
   strcat(menu,"\n\n");

   strcat(menu,"%0.1\"Show Class\"b\n");
   if (cm->defcls != NULL) strcat(menu,"%0.2\"Show Type\"b\n");

   show = 0;

   strcat(menu,"\n   %a%M   %c");

   if (!STEMdialog1(cw->window,menu,&show)) return;

   if (show == 1) show_class_info(cw,cm->cls);
   else if (show == 2) show_class_info(cw,cm->defcls);
   if (showdef) {
      MSGsenda("XREF SET %s %d MID",cm->deffile,cm->defline);
    };

   return;
};





/************************************************************************/
/*									*/
/*	show_hier_info -- show information about class hierarchy	*/
/*									*/
/************************************************************************/


static void
show_hier_info(cw,ch)
   CBROW_WIN cw;
   CBROW_HIER ch;
{
   show_class_info(cw,ch->sub);
};





/************************************************************************/
/*									*/
/*	add_field -- add field information to menu			*/
/*									*/
/************************************************************************/


static Integer
add_field(menu,flag,id,ct)
   String menu;
   Boolean flag;
   String id;
   Integer ct;
{
   if (id == NULL) {
      if (ct > 0) strcat(menu,")");
      strcat(menu,"\n");
    }
   else if (flag) {
      if (ct == 0) strcat(menu,"   (");
      else strcat(menu,",");
      strcat(menu,id);
      ++ct;
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	query_member -- get information about a member			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
query_member(cw,cm,buf)
   CBROW_WIN cw;
   CBROW_MEMB cm;
   String buf;
{
   Integer i;
   Character xbuf[1024];

   buf[0] = 0;

   if (cm->defname == NULL) return;

   if (cm->deffile != NULL &&
	  (cm->file == NULL || STRNEQ(cm->deffile,cm->file) || cm->line == 0 ||
	      abs(cm->line - cm->defline) > 4)) {
      i = cm->defline;
      if (i > 0) sprintf(buf,"Defined at line %d in file %s\n",i,cm->deffile);
      else sprintf(buf,"Defined in file %s\n",cm->deffile);
      strcat(buf,"   ");
    };

   if (cm->isdata) strcat(buf,"Type:  ");
   else strcat(buf,"Signature:  ");

   if (cm->deftype != 0) {
      strcat(buf,fix_dialog(cm->deftype,xbuf));
      strcat(buf,"  ");
    };

   strcat(buf,fix_dialog(cm->defname,xbuf));
   strcat(buf,"\n");
};







/************************************************************************/
/*									*/
/*	reset_btns -- handle setting conditions on menu btns		*/
/*									*/
/************************************************************************/


static void
reset_btns(cw)
   CBROW_WIN cw;
{
   STEMpdm_btn_select(cw->menu_win,"Display","Show All",cw->display_all);
   STEMpdm_btn_select(cw->menu_win,"Display","Show Friends",cw->dclass_friend);
   STEMpdm_btn_select(cw->menu_win,"Display","Public Only",cw->dmemb_public);
   STEMpdm_btn_select(cw->menu_win,"Display","Show Data",cw->dmemb_data);
   STEMpdm_btn_select(cw->menu_win,"Display","Show Functions",cw->dmemb_method);
   STEMpdm_btn_select(cw->menu_win,"Display","Show Inherited",cw->dmemb_inher);
};





/************************************************************************/
/*									*/
/*	fix_dialog -- fix name for dialog box				*/
/*									*/
/************************************************************************/


static String
fix_dialog(nm,buf)
   String nm;
   String buf;
{
   String s,t;

   s = nm;
   t = buf;

   while (*s != 0) {
      if (*s == '%') *t++ = '%';
      *t++ = *s++;
    };

   *t = 0;

   return buf;
};





/* end of cbrowmenu.c */

