/************************************************************************/
/*									*/
/*		cbrowmain.c						*/
/*									*/
/*	General routines for class browser package			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "cbrow_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	cbrow_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	CBROW_init -- package initialization				*/
/*									*/
/************************************************************************/


void
CBROW_init()
{
   PROT_INIT;
   PROTECT;
   if (!cbrow_inited) {
      cbrow_inited = TRUE;
      MSGinit(FALSE);
      MSGservice_start("XREF",XREFinit,NULL,NULL);
      CBROW_win_init();
      CBROW_class_init();
      CBROW_disp_init();
      CBROW_menu_init();
      CBROW_info_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	CBROWnew_window -- create a new cbrow window			*/
/*	CBROWnew_wind_window -- create a window from wind		*/
/*									*/
/************************************************************************/


int
CBROWnew_window(w,name)
   ASH_WINDOW w;
   String name;
{
   CBROW_WIN aw;

   CBROW_init();

   aw = CBROW_create(w,name);

   return (aw != NULL);
};





int
CBROWnew_wind_window(w)
   ASH_WINDOW w;
{
   CBROW_WIN aw;

   CBROW_init();

   aw = CBROW_create(w,NULL);

   return (aw != NULL);
};





/* end of cbrowmain.c */
