/************************************************************************/
/*									*/
/*		cbrowinfo.c						*/
/*									*/
/*	Routines to manage information window for class browser 	*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "cbrow_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_MEMBS	512




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	int		cbrow_info_control();
static	void		cbrow_info_mouse();
static	Integer 	info_add_field();
static	Boolean 	prefix();





/************************************************************************/
/*									*/
/*	CBROW_info_init -- module initialization			*/
/*									*/
/************************************************************************/


void
CBROW_info_init()
{
};





/************************************************************************/
/*									*/
/*	CBROW_info_setup -- setup information window for browser	*/
/*									*/
/************************************************************************/


void
CBROW_info_setup(cw)
   CBROW_WIN cw;
{
   ASH_WINDOW w;

   w = ASHroot_window(ASHinq_display_name(cw->window),"cbrow_info");
   w = WINDsetup(w);

   if (w == NULL) return;

   cw->text_win = w;
   ASHset_control(cw->text_win,cbrow_info_control);

   cw->edit_info = EDTedit_output(cw->text_win,cw);
   if (cw->edit_info == NULL) {
      cw->text_win = NULL;
      if (ASHinq_valid_window(w)) ASHremove(w);
      return;
    };

   EDTset_mouse_rtn(cw->edit_info,cbrow_info_mouse);
   EDTenable(cw->edit_info,FALSE);
   EDTprohibit_close(cw->edit_info);

   ASHvisible(w,TRUE);

   if (cw->display != NULL) CBROW_info_class(cw,cw->display);
};





/************************************************************************/
/*									*/
/*	CBROW_info_class -- output information on a class		*/
/*									*/
/************************************************************************/


void
CBROW_info_class(cw,cc)
   CBROW_WIN cw;
   CBROW_CLASS cc;
{
   Character info[20480],buf[1024];
   Integer i,j,k,ct;
   CBROW_HIER ch;
   CBROW_MEMB cm;
   CBROW_MEMB dmem[MAX_MEMBS];

   if (cw->text_win == NULL || cw->edit_info == NULL) return;
   if (cc == NULL) return;
   if (cc->infoline > 0) {
      EDTgoto_top(cw->edit_info,cc->infoline);
      return;
    };

   if (cc->isabstract) {
      sprintf(info,"Abstract Class:  %s\n",cc->name);
    }
   else {
      sprintf(info,"Class:  %s\n",cc->name);
    };

   if (cc->line > 0) {
      sprintf(buf,"   Defined at line %d",cc->line);
      if (cc->file != NULL) {
	 strcat(buf," in file ");
	 strcat(buf,cc->file);
       };
      strcat(info,buf);
      strcat(info,"\n");
    };

   strcat(info,"\n");

   i = 0;
   for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
      if (!ch->isfriend) {
	 if (i++ == 0) {
	    sprintf(buf,"Supertypes of %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"   %s",ch->super->name);
	 j = info_add_field(buf,ch->ispublic,"PUBLIC",0);
	 j = info_add_field(buf,ch->isvirtual,"VIRTUAL",j);
	 info_add_field(buf,TRUE,NULL,j);
	 strcat(info,buf);
       };
    };
   if (i > 0) strcat(info,"\n");

   i = 0;
   for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
      if (!ch->isfriend) {
	 if (i++ == 0) {
	    sprintf(buf,"Subtypes of %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"   %s",ch->sub->name);
	 j = info_add_field(buf,ch->ispublic,"PUBLIC",0);
	 j = info_add_field(buf,ch->isvirtual,"VIRTUAL",j);
	 info_add_field(buf,TRUE,NULL,j);
	 strcat(info,buf);
       };
    };
   if (i > 0) strcat(info,"\n");

   i = 0;
   for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
      if (ch->isfriend) {
	 if (i++ == 0) {
	    sprintf(buf,"Friends for %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"   %s\n",ch->super->name);
	 strcat(info,buf);
       };
    };
   if (i > 0) strcat(info,"\n");

   i = 0;
   for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
      if (ch->isfriend) {
	 if (i++ == 0) {
	    sprintf(buf,"Friends of %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"   %s\n",ch->sub->name);
	 strcat(info,buf);
       };
    };
   if (i > 0) strcat(info,"\n");

   ct = 0;
   for (cm = cc->members; cm != NULL; cm = cm->next) {
      if (ct < MAX_MEMBS) dmem[ct++] = cm;
    };

   qsort(dmem,ct,sizeof(CBROW_MEMB),CBROW_member_compare);

   i = 0;
   for (k = 0; k < ct; ++k) {
      cm = dmem[k];
      if (cm->isdata) {
	 if (i++ == 0) {
	    sprintf(buf,"Data members of %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"    %s",cm->defpname);
	 j = info_add_field(buf,cm->isprivate,"PRIVATE",0);
	 j = info_add_field(buf,cm->isprotected,"PROTECTED",j);
	 j = info_add_field(buf,cm->isstatic,"STATIC",j);
	 j = info_add_field(buf,cm->isconst,"CONST",j);
	 info_add_field(buf,TRUE,NULL,j);
	 strcat(info,buf);
	 if (cm->deffile != NULL &&
		(cm->file == NULL || STRNEQ(cm->deffile,cm->file) || cm->line == 0 ||
		    abs(cm->line - cm->defline) > 4)) {
	    if (cm->defline > 0)
	       sprintf(buf,"        Defined at line %d in file %s\n",cm->defline,cm->deffile);
	    else
	       sprintf(buf,"        Defined in file %s\n",cm->deffile);
	    strcat(info,buf);
	  };
	 if (cm->deftype != NULL) {
	    sprintf(buf,"        Type: %s\n",cm->deftype);
	    strcat(info,buf);
	  };
       };
    };
   if (i > 0) strcat(info,"\n");

   i = 0;
   for (k = 0; k < ct; ++k) {
      cm = dmem[k];
      if (!cm->isdata) {
	 if (i++ == 0) {
	    sprintf(buf,"Function members of %s:\n",cc->name);
	    strcat(info,buf);
	  };
	 sprintf(buf,"    %s",cm->defpname);
	 j = info_add_field(buf,cm->isprivate,"PRIVATE",0);
	 j = info_add_field(buf,cm->isprotected,"PROTECTED",j);
	 j = info_add_field(buf,cm->isinline,"INLINE",j);
	 j = info_add_field(buf,cm->isfriend,"FRIEND",j);
	 j = info_add_field(buf,cm->isvirtual,"VIRTUAL",j);
	 j = info_add_field(buf,cm->isstatic,"STATIC",j);
	 j = info_add_field(buf,cm->ispure,"PURE",j);
	 j = info_add_field(buf,cm->isconst,"CONST",j);
	 info_add_field(buf,TRUE,NULL,j);
	 strcat(info,buf);
	 if (cm->deffile != NULL &&
		(cm->file == NULL || STRNEQ(cm->deffile,cm->file) || cm->line == 0 ||
		    abs(cm->line - cm->defline) > 4)) {
	    if (cm->defline > 0)
	       sprintf(buf,"        Defined at line %d in file %s\n",cm->defline,cm->deffile);
	    else
	       sprintf(buf,"        Defined in file %s\n",cm->deffile);
	    strcat(info,buf);
	  };
	 if (cm->deftype != NULL) {
	    sprintf(buf,"        Returns: %s\n",cm->deftype);
	    strcat(info,buf);
	  };
       };
    };
   if (i > 0) strcat(info,"\n");

   strcat(info,"\n\n------------------------------------------------------\n");

   i = EDTlast_line(cw->edit_info);
   cc->infoline = i;
   EDTenable(cw->edit_info,TRUE);
   EDTinsert_line(cw->edit_info,i,info);
   EDTgoto_top(cw->edit_info,i);
   EDTenable(cw->edit_info,FALSE);
};





/************************************************************************/
/*									*/
/*	cbrow_info_control -- handle control messages on window 	*/
/*									*/
/************************************************************************/


static int
cbrow_info_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   CBROW_WIN cw;
   CBROW_CLASS cc;

   cw = CBROW_find_window(w);
   if (cw == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      cw->text_win = NULL;
      cw->edit_info = NULL;
      for (cc = cw->classes; cc != NULL; cc = cc->next) cc->infoline = -1;
    };

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	cbrow_info_mouse -- handle mouse hits in information window	*/
/*									*/
/************************************************************************/



static void
cbrow_info_mouse(cw,btn,l,c,fl,fc,tl,tc)
   CBROW_WIN cw;
   Integer btn;
   Integer l,c;
   Integer fl,fc;
   Integer tl,tc;
{
   String b;
   Character lbuf[10240];
   String s,t;
   Integer spct,lno,i;
   Character fbuf[1024];
   CBROW_CLASS cc,mcc;
   CBROW_MEMB cm;

   if (btn & RIP_BTN_LEFT) b = "LEFT";
   else if (btn & RIP_BTN_MID) b = "MID";
   else if (btn & RIP_BTN_RIGHT) b = "RIGHT";
   else b = "NONE";

   if (l == 0) {
      l = EDTcur_line(cw->edit_info);
      c = EDTcur_char(cw->edit_info);
    };

   EDTinq_line_text(cw->edit_info,l,lbuf);
   i = strlen(lbuf);
   if (lbuf[i-1] == '\n') lbuf[--i] = 0;

   spct = 0;
   for (s = lbuf; isspace(*s); ++s) ++spct;

   if (prefix(s,"Defined at line")) {
      if (sscanf(s,"Defined at line %d in file %s",&lno,fbuf) == 2) {
	 MSGsenda("XREF SET %s %d %s",fbuf,lno,b);
       };
    }
   else if (prefix(s,"Class:  ") || prefix(s,"Abstract Class: ")) {
      s = index(s,'C');
      if (sscanf(s,"Class:  %s",fbuf) == 1) {
	 cc = CBROW_class_find(cw,fbuf);
	 if (cc != NULL) CBROW_disp_current(cw,cc,NULL,b,FALSE);
       };
    }
   else if (prefix(s,"Type: ") || prefix(s,"Returns: ")) {
      s = index(s,':');
      ++s;
      while (isspace(*s)) ++s;
      if (prefix(s,"struct ")) s += 7;
      else if (prefix(s,"class ")) s += 6;
      else if (prefix(s,"union ")) s += 6;
      for (t = s; isidchar(*t); ++t);
      if (t != s) {
	 *t = 0;
	 cc = CBROW_class_find(cw,s);
	 if (cc != NULL) CBROW_disp_current(cw,cc,NULL,b,TRUE);
       };
    }
   else if (spct == 3) {
      t = s;
      while (*t != 0 && !isspace(*t)) ++t;
      *t = 0;
      cc = CBROW_class_find(cw,s);
      if (cc != NULL) CBROW_disp_current(cw,cc,NULL,b,TRUE);
    }
   else if (spct == 4) {
      i = 0;
      for (cc = cw->classes; cc != NULL; cc = cc->next) {
	 if (cc->infoline > 0 && cc->infoline > i && cc->infoline < l) {
	    mcc = cc;
	    i = cc->infoline;
	  };
       };
      if (i > 0) {
	 for (cm = mcc->members; cm != NULL; cm = cm->next) {
	    i = strlen(cm->defpname);
	    if (strncmp(s,cm->defpname,i) == 0 && s[i] == ' ') break;
	  };
	 if (cm != NULL) {
	    CBROW_disp_member(cw,cm);
	    if (STREQL(b,"RIGHT") && cm->deffile != NULL && cm->defline > 0) {
	       MSGsenda("XREF SET %s %d %s",cm->deffile,cm->defline,b);
	     }
	    else if (cm->file != NULL && cm->line > 0) {
	       MSGsenda("XREF SET %s %d %s",cm->file,cm->line,b);
	     };
	  };
       };
    };
};






/************************************************************************/
/*									*/
/*	info_add_field -- add field information to menu 		*/
/*									*/
/************************************************************************/


static Integer
info_add_field(info,flag,id,ct)
   String info;
   Boolean flag;
   String id;
   Integer ct;
{
   Integer i;

   if (id == NULL) {
      if (ct > 0) strcat(info,")");
      strcat(info,"\n");
    }
   else if (flag) {
      if (ct == 0) {
	 i = strlen(info);
	 if (i < 40) {
	    while (i < 40) {
	       strcat(info," ");
	       ++i;
	     };
	  }
	 else strcat(info,"  ");
	 strcat(info,"(");
       }
      else strcat(info,",");
      strcat(info,id);
      ++ct;
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	prefix -- check for string prefix				*/
/*									*/
/************************************************************************/


static Boolean
prefix(s,pfx)
   String s;
   String pfx;
{
   Integer i;

   i = strlen(pfx);

   return (strncmp(s,pfx,i) == 0);
};





/* end of cbrowinfo.c */
