/************************************************************************/
/*									*/
/*		cbrow_local.h						*/
/*									*/
/*	Local definitions for class browser package			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	CBROW__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <leaf.h>
#include <stem.h>
#include <edt.h>
#include <wind.h>

#include <auxd.h>
#include <gelo.h>
#include <msg.h>
#include <field.h>

#include <cbrow.h>
#include <xref.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Macros								*/
/*									*/
/************************************************************************/


#define isidchar(ch)	(isalnum(ch) || ch == '_' || ch == '$')





/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _CBROW_WIN *		CBROW_WIN;
typedef struct _CBROW_CLASS *		CBROW_CLASS;
typedef struct _CBROW_HIER *		CBROW_HIER;
typedef struct _CBROW_MEMB *		CBROW_MEMB;


typedef struct _CBROW_WIN {
   ASH_WINDOW window;
   String system;
   ASH_WINDOW menu_win;
   ASH_WINDOW disp_win;
   ASH_WINDOW text_win;
   RIP_REGION region;
   CBROW_CLASS classes;
   Sequence strings;
   EDT_ID edit_info;
   GELO_OBJECT gid;
   CBROW_CLASS display;
   CBROW_MEMB curmemb;
   CBROW_MEMB cureval;
   Boolean memb_select;
   Boolean eval_select;
   Boolean display_all;
   Boolean display_super;
   Boolean display_sub;
   Boolean display_force;
   Boolean dclass_simple;
   Boolean dclass_detail;
   Boolean dclass_friend;
   Boolean dclass_hier;
   Boolean dclass_fixcur;
   Boolean dmemb_public;
   Boolean dmemb_data;
   Boolean dmemb_method;
   Boolean dmemb_inher;
   Boolean dmemb_links;
   Boolean dmemb_state;
   Boolean dmemb_fullnames;
   Integer display_levels;
   Integer dclass_zoom;
   GELO_METHOD method;
   GELO_CONN_METHOD connmethod;
   Boolean fixed;
   Boolean standard;
   Boolean centered;
   Integer whitespace;
} CBROW_WIN_INFO;




typedef struct _CBROW_CLASS {
   String name;
   String file;
   Integer line;
   CBROW_HIER supers;
   CBROW_HIER subs;
   CBROW_MEMB members;
   CBROW_CLASS next;
   GELO_OBJECT gid;
   Boolean ignore;
   Boolean isabstract;
   Boolean done;
   Integer infoline;
} CBROW_CLASS_INFO;




typedef struct _CBROW_HIER {
   CBROW_CLASS super;
   CBROW_CLASS sub;
   CBROW_HIER next_super;
   CBROW_HIER next_sub;
   String file;
   Integer line;
   Boolean ispublic;
   Boolean isvirtual;
   Boolean isfriend;
   GELO_OBJECT gid;
} CBROW_HIER_INFO;




typedef struct _CBROW_MEMB {
   CBROW_CLASS cls;
   CBROW_CLASS real_cls;
   CBROW_MEMB next;
   String name;
   String file;
   Integer line;
   String deffile;
   Integer defline;
   String defname;
   String defpname;
   String deftype;
   String pname;
   String dname;
   CBROW_CLASS defcls;
   Boolean isprivate;
   Boolean isprotected;
   Boolean isdata;
   Boolean isinline;
   Boolean isfriend;
   Boolean isvirtual;
   Boolean isstatic;
   Boolean ispure;
   Boolean isconst;
   Boolean ignore;
   GELO_OBJECT gid;
} CBROW_MEMB_INFO;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* cbrowmain.c		       */
extern	void		CBROW_init();



					/* cbrowwin.c		       */
extern	void		CBROW_win_init();
extern	CBROW_WIN	CBROW_create();
extern	CBROW_WIN	CBROW_find_window();
extern	CBROW_WIN	CBROW_find_system();



					/* cbrowclass.c 		*/
extern	void		CBROW_class_init();
extern	void		CBROW_class_setup();
extern	CBROW_CLASS	CBROW_class_find();
extern	CBROW_MEMB	CBROW_class_find_member();
extern	Boolean 	CBROW_class_test_super();
extern	int		CBROW_class_compare();
extern	int		CBROW_member_compare();
extern	String		CBROW_find_string();



					/* cbrowdisp.c			*/
extern	void		CBROW_disp_init();
extern	void		CBROW_disp_setup();
extern	void		CBROW_disp_reset();
extern	void		CBROW_disp_redraw();
extern	void		CBROW_disp_member();
extern	void		CBROW_disp_eval();
extern	void		CBROW_disp_free();
extern	void		CBROW_disp_class_regex();
extern	void		CBROW_disp_member_regex();



					/* cbrowmenu.c			*/
extern	void		CBROW_menu_init();
extern	void		CBROW_menu_setup();



					/* cbrowinfo.c			*/
extern	void		CBROW_info_init();
extern	void		CBROW_info_setup();
extern	void		CBROW_info_class();






/* end of cbrow_local.h */
