/*	Copyright 1988 Brown University -- Steven P. Reiss		*/

%{

/************************************************************************/
/*									*/
/*		buildsyn.y						*/
/*									*/
/*	DDT syntax for makefile interpreter				*/
/*									*/
/************************************************************************/

#include "build_local.h"




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	BUILD_PROJ	cur_proj;
static	Boolean 	cur_lib;
static	String		cur_file;
static	Boolean 	cur_auto;




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/

static	void		set_file_info();
static	void		set_macro_info();
static	void		set_proj_info();



%}



%union {
   String	string;
   Integer	intval;
   BUILD_FILE	bfile;
   BUILD_MACRO	bmacro;
   Sequence	list;
}



%token	<string>	LX_ID LX_TEXT LX_STRING
%token			LX_EOL LX_SEOL LX_COLCOL
%token			LX_FILEINFO LX_MACROINFO LX_PROJECTINFO
%token			LX_AUTODEPEND
%token	<string>	LX_INT

%type	<list>		id_list dep_list cmd_list


%start	lines


%%


lines	:	/* empty */
	|	lines line
	;


line	:	macro_line
	|	cmd_line
	|	depend_line
	|	prag_line
	|	LX_AUTODEPEND
			{ cur_auto = TRUE; }
	|	LX_EOL
	;


macro_line :	LX_ID '=' LX_TEXT LX_EOL
			{ BUILD_data_macro_define(cur_proj,$1,$3,FALSE,cur_lib);
			  SFREE($1);
			  SFREE($3);
			}
	|	LX_ID '=' LX_EOL
			{ BUILD_data_macro_define(cur_proj,$1,NULL,FALSE,cur_lib);
			  SFREE($1);
			}
	;


cmd_line :	id_list ':' dep_list ';' cmd_list LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,$5,cur_auto); }
	|	id_list ':' dep_list ';' LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,NULL,cur_auto); }
	|	id_list LX_COLCOL dep_list ';' cmd_list LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,$5,cur_auto); }
	|	id_list LX_COLCOL dep_list ';' LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,NULL,cur_auto); }
	;


depend_line :	id_list ':' dep_list LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,NULL,cur_auto); }
	|	id_list LX_COLCOL dep_list LX_EOL
			{ BUILD_data_command(cur_proj,$1,$3,NULL,cur_auto); }
	;


id_list :	LX_ID
			{ $$ = NEW1(BUILD_data_file(cur_proj,$1,cur_lib));
			  SFREE($1);
			}
	|	id_list LX_ID
			{ $$ = APPEND(BUILD_data_file(cur_proj,$2,cur_lib),$1);
			  SFREE($2);
			}
	;


dep_list :	/* empty */
			{ $$ = NULL; }
	|	dep_list LX_ID
			{ $$ = APPEND(BUILD_data_file(cur_proj,$2,cur_lib),$1);
			  SFREE($2);
			}
	;

cmd_list :	LX_TEXT
			{ $$ = NEW1($1); }
	|	cmd_list LX_SEOL LX_TEXT
			{ $$ = APPEND($3,$1); }
	;


prag_line :	LX_FILEINFO LX_ID LX_INT LX_INT LX_INT LX_EOL
			{ set_file_info($2,atol($3),atol($4),atol($5)); }
	|	LX_FILEINFO LX_INT LX_INT LX_INT LX_INT LX_EOL
			{ set_file_info($2,atol($3),atol($4),atol($5)); }
	|	LX_MACROINFO LX_ID LX_INT LX_INT LX_STRING LX_EOL
			{ set_macro_info($2,atol($3),atol($4),$5); }
	|	LX_MACROINFO LX_INT LX_INT LX_INT LX_STRING LX_EOL
			{ set_macro_info($2,atol($3),atol($4),$5); }
	|	LX_PROJECTINFO LX_ID LX_INT LX_INT LX_INT LX_EOL
			{ set_proj_info($2,atol($3),atol($4),atol($5)); }
	|	LX_PROJECTINFO LX_INT LX_INT LX_INT LX_INT LX_EOL
			{ set_proj_info($2,atol($3),atol($4),atol($5)); }
	;


%%


#include "buildlex.c"




/************************************************************************/
/*									*/
/*	DDT_lang_init -- module initialization				*/
/*									*/
/************************************************************************/


void
BUILD_syn_init()
{
};





/************************************************************************/
/*									*/
/*	BUILD_read_file -- read a Makefile				*/
/*									*/
/************************************************************************/


Boolean
BUILD_read_file(bp,file,lib)
   BUILD_PROJ bp;
   String file;
   Boolean lib;
{
   yyin = fopen(file,"r");
   if (yyin == NULL) {
      fprintf(stderr,"BUILD: Can't open file %s\n",file);
      return FALSE;
    };

   PROTECT;

   cur_proj = bp;
   cur_lib = lib;
   cur_file = file;
   cur_auto = FALSE;

   yylineno = 1;
   start_read();

   yyparse();

   UNPROTECT;

   fclose(yyin);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	yyerror -- handle parsing errors				*/
/*									*/
/************************************************************************/


yyerror(msg)
   String msg;
{
   fprintf(stderr,"BUILD: line %d of %s: %s\n",yylineno,cur_file,msg);
};




/************************************************************************/
/*									*/
/*	set_file_info -- set info on file				*/
/*	set_macro_info -- set info on macro				*/
/*	set_proj_info -- set info on project				*/
/*									*/
/************************************************************************/


static void
set_file_info(name,typ,mat,dep)
   String name;
   BUILD_TYPE typ;
   Integer mat;
   Integer dep;
{
   BUILD_FILE bf;

   bf = BUILD_data_file(cur_proj,name,cur_lib);
   bf->type = typ|BUILD_TYPE_GET_DFLT;
   bf->match_bits = mat;
   bf->autodepend = dep;
};





static void
set_macro_info(name,typ,mat,opt)
   String name;
   Integer typ;
   Integer mat;
   String opt;
{
   BUILD_MACRO bm;

   bm = BUILD_find_macro(cur_proj,name);
   if (bm == NULL) {
      BUILD_data_macro_define(cur_proj,name,NULL,TRUE,cur_lib);
      bm = BUILD_find_macro(cur_proj,name);
    };

   bm->dflt_type = typ;
   bm->bit_value = mat;
   cur_proj->match_bits |= mat;
   bm->option_name = opt;
};





static void
set_proj_info(name,cont,ign,dep)
   String name;
   Boolean cont;
   Boolean ign;
   Boolean dep;
{
   if (cur_proj->system_name == NULL ||
	  STRNEQ(cur_proj->system_name,name)) {
      cur_proj->system_name = name;
    };

   cur_proj->continue_opt = cont;
   cur_proj->ignore_opt = ign;
   cur_proj->autodepend = dep;
};





/* end of buildsyn.y */
