/************************************************************************/
/*									*/
/*		buildmain.c						*/
/*									*/
/*	General routines for building package				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "build_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	build_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	BUILDinit -- package initialization				*/
/*									*/
/************************************************************************/


void
BUILDinit()
{
   PROT_INIT;
   PROTECT;
   if (!build_inited) {
      build_inited = TRUE;
      BUILD_win_init();
      BUILD_menu_init();
      BUILD_disp_init();
      BUILD_graph_init();
      BUILD_cmd_init();
      BUILD_data_init();
      BUILD_file_init();
      BUILD_syn_init();
      BUILD_mon_init();
      BUILD_flag_init();

      BUILD_mon_setup();
      BUILD_find_project(MSGinq_wd());
      MSGservice_register("BUILD");
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	BUILDnew_willow_window -- create a new willow window		*/
/*									*/
/************************************************************************/


int
BUILDnew_willow_window(w)
   ASH_WINDOW w;
{
   register BUILD_WIN aw;

   BUILDinit();

   aw = BUILD_create(w,NULL,FALSE);

   if (aw == NULL) return FALSE;

   aw->willow_fg = TRUE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	BUILDnew_window -- create a new building window of given type	*/
/*									*/
/************************************************************************/


int
BUILDnew_window(w,proj)
   ASH_WINDOW w;
   String proj;
{
   register BUILD_WIN aw;

   BUILDinit();

   aw = BUILD_create(w,proj,FALSE);

   return (aw != NULL);
};





/************************************************************************/
/*									*/
/*	BUILDnew_willow_transcript -- set up transcript window		*/
/*									*/
/************************************************************************/


int
BUILDnew_willow_transcript(w)
   ASH_WINDOW w;
{
   register BUILD_WIN aw;

   BUILDinit();

   aw = BUILD_create(w,NULL,TRUE);

   if (aw == NULL) return FALSE;

   aw->willow_fg = TRUE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	BUILDnew_transcript -- set up a new transcript-only window	*/
/*									*/
/************************************************************************/


int
BUILDnew_transcript(w,proj)
   ASH_WINDOW w;
   String proj;
{
   register BUILD_WIN aw;

   BUILDinit();

   aw = BUILD_create(w,proj,TRUE);

   return (aw != NULL);
};





/************************************************************************/
/*									*/
/*	BUILD_error -- handle error conditions				*/
/*									*/
/************************************************************************/


/*VARARGS2*/

void
BUILD_error(bw,pat,a1,a2,a3,a4,a5,a6,a7,a8)
   BUILD_WIN bw;
   String pat;
   Universal a1,a2,a3,a4,a5,a6,a7,a8;
{
   Character buf[512],msg[128];

   sprintf(msg,pat,a1,a2,a3,a4,a5,a6,a7,a8);

   sprintf(buf,"\n%s\n%%R%%a",msg);

   if (bw != NULL) STEMdialog1(bw->window,buf);
   else {
      fprintf(stderr,"%s",msg);
    };
};





/* end of buildmain.c */
