/************************************************************************/
/*									*/
/*		buildflag.c						*/
/*									*/
/*	BUILD flag option routines					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "build_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_FIELDS	64





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_flags;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Universal	init_value_field();
static	String		scan_value_field();
static	void		set_value_field();
static	void		add_text();
static	Boolean 	display_options();





/************************************************************************/
/*									*/
/*	BUILD_flag_init -- module initialization			*/
/*									*/
/************************************************************************/


void
BUILD_flag_init()
{
   AUXD hdl,hdlf,hdlv;
   BUILD_FLAG bf;
   BUILD_FDEF bfd;
   BUILD_FVAL_INFO vals[64];
   Integer ct;
   String s;

   all_flags = NULL;

   hdl = AUXDget_handle(NULL,"BUILD");
   for (hdl = AUXDget_handle(hdl,"FLAG"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      bf = PALLOC(BUILD_FLAG_INFO);
      bf->defs = NULL;
      bf->name = AUXDget_info(hdl,"NAME");
      for (hdlf = AUXDget_handle(hdl,"OPTION");
	   hdlf != NULL;
	   hdlf = AUXDnext_handle(hdlf)) {
	 ct = 0;
	 s = NULL;
	 for (hdlv = AUXDget_handle(hdlf,"VALUE");
	      hdlv != NULL;
	      hdlv = AUXDnext_handle(hdlv)) {
	    vals[ct].option = AUXDget_info(hdlv,"NAME");
	    vals[ct].show = AUXDget_info(hdlv,"OUTPUT");
	    if (s == NULL) s = vals[ct].show;
	    ++ct;
	  };
	 if (s == NULL) continue;
	 bfd = PALLOC(BUILD_FDEF_INFO);
	 bf->defs = APPEND(bfd,bf->defs);
	 if (index(s,'%') != NULL) {
	    if (AUXDget_defined(hdlf,"MULTIPLE")) bfd->type = FDEF_MULTIPLE;
	    else bfd->type = FDEF_STRING;
	  }
	 else bfd->type = FDEF_CHOICE;
	 bfd->values = (BUILD_FVAL) calloc(ct,sizeof(BUILD_FVAL_INFO));
	 bcopy(vals,bfd->values,ct*sizeof(BUILD_FVAL_INFO));
	 bfd->numvalues = ct;
       };
      all_flags = APPEND(bf,all_flags);
    };
};





/************************************************************************/
/*									*/
/*	BUILD_set_flags -- set flags for a macro			*/
/*									*/
/************************************************************************/


Boolean
BUILD_set_flags(bw)
   BUILD_WIN bw;
{
   BUILD_MACRO bm;
   BUILD_FLAG bf;
   BUILD_FDEF bfd;
   Integer i;
   Sequence l;
   Universal vals[MAX_FIELDS];
   String s,t;
   Boolean fg;
   Character buf[10240];
   Integer noopt;

   bm = bw->macro;
   if (bm == NULL) return FALSE;

   forin (bf,BUILD_FLAG,l,all_flags) {
      if (STREQL(bm->name,bf->name)) break;
    };
   if (bf == NULL) return FALSE;

   i = 0;
   forin (bfd,BUILD_FDEF,l,bf->defs) {
      vals[i] = init_value_field(bfd);
      ++i;
    };

   BUILD_disp_update(bw,TRUE,FALSE);

   s = bm->body;
   if (s == NULL) s = "";

   while (*s != 0) {
      if (isspace(*s)) ++s;
      else {
	 i = 0;
	 forin (bfd,BUILD_FDEF,l,bf->defs) {
	    t = scan_value_field(s,bfd,&vals[i]);
	    if (t != NULL) {
	       s = t;
	       break;
	     };
	    ++i;
	  };
	 if (bfd == NULL) ++s;
       };
    };

   fg = display_options(bw,bf,vals,&noopt);

   if (fg) {
      buf[0] = 0;
      i = 0;
      forin (bfd,BUILD_FDEF,l,bf->defs) {
	 set_value_field(bfd,vals[i],buf);
	 ++i;
       };
      s = (buf[0] == 0 ? NULL : buf);
      BUILD_data_macro_define(bw->project,bm->name,s,TRUE,FALSE);
      BUILD_disp_update(bw,FALSE,TRUE);
    };

   if (noopt) return FALSE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	init_value_field -- return default value for a flag field	*/
/*									*/
/************************************************************************/


static Universal
init_value_field(bfd)
   BUILD_FDEF bfd;
{
   Universal v;
   Integer i;

   switch (bfd->type) {
      case FDEF_STRING :
      case FDEF_MULTIPLE :
	 v = (Universal) NULL;
	 break;
      case FDEF_CHOICE :
	 for (i = 0; i < bfd->numvalues; ++i) {
	    if (bfd->values[i].show == NULL ||
		   bfd->values[i].show[0] == 0) break;
	  };
	 if (i >= bfd->numvalues) i = -1;
	 v = (Universal) i;
	 break;
    };

   return v;
};





/************************************************************************/
/*									*/
/*	scan_value_field -- scan current body string for a value	*/
/*									*/
/************************************************************************/


static String
scan_value_field(s,bfd,vp)
   String s;
   BUILD_FDEF bfd;
   Universal * vp;
{
   String p,q,r;
   Character buf[1024];
   Integer i,qch;
   Sequence l;

   if (*s == '"' || *s == '\'') qch = *s++;
   else qch = 0;

   for (i = 0; i < bfd->numvalues; ++i) {
      p = s;
      q = bfd->values[i].show;
      buf[0] = 0;
      if (q == NULL || *q == 0) continue;
      while (*q != 0) {
	 if (*q == '%' && q[1] == 's') {
	    r = buf;
	    while (*p != 0 && ((qch == 0 && !isspace(*p)) ||
				  (qch != 0 && *p != qch))) {
	       *r++ = *p++;
	     };
	    *r = 0;
	    q += 2;
	  }
	 else {
	    if (*p++ != *q) break;
	    ++q;
	  };
       };
      if (*q == 0) break;
    };

   if (i >= bfd->numvalues) return NULL;

   if (qch != 0 && *p == qch) ++p;

   switch (bfd->type) {
      case FDEF_CHOICE :
	 *vp = (Universal) i;
	 break;
      case FDEF_STRING :
	 *vp = (Universal) SALLOC(buf);
	 break;
      case FDEF_MULTIPLE :
	 l = (Sequence) *vp;
	 *vp = (Universal) APPEND(SALLOC(buf),l);
	 break;
    };

   return p;
};





/************************************************************************/
/*									*/
/*	set_value_field -- add result to item				*/
/*	add_text -- concatentate to string				*/
/*									*/
/************************************************************************/


static void
set_value_field(bfd,val,out)
   BUILD_FDEF bfd;
   Universal val;
   String out;
{
   Integer i;
   Character buf[1024];
   Sequence l;
   String s;

   switch (bfd->type) {
      case FDEF_CHOICE :
	 i = (Integer) val;
	 if (i < 0 || i >= bfd->numvalues) return;
	 if (bfd->values[i].show != NULL) add_text(out,bfd->values[i].show);
	 break;
      case FDEF_STRING :
	 sprintf(buf,bfd->values[0].show,val);
	 add_text(out,buf);
	 break;
      case FDEF_MULTIPLE :
	 forin (s,String,l,(Sequence) val) {
	    sprintf(buf,bfd->values[0].show,s);
	    add_text(out,buf);
	  };
	 break;
    };
};





static void
add_text(out,txt)
   String out;
   String txt;
{
   String s;
   String qfg;

   if (out[0] != 0) strcat(out," ");

   qfg = NULL;
   for (s = txt; *s != 0; ++s) {
      if (isspace(*s)) qfg = "\"";
    };

   if (qfg != NULL) strcat(out,qfg);
   strcat(out,txt);
   if (qfg != NULL) strcat(out,qfg);
};




/************************************************************************/
/*									*/
/*	display_options -- provide option menu				*/
/*									*/
/************************************************************************/


static Boolean
display_options(bw,bf,vals,nop)
   BUILD_WIN bw;
   BUILD_FLAG bf;
   Universal vals[];
   Integer * nop;
{
   String menus[64];
   Integer ct,mct,sct;
   Character mbuf[64][64];
   Character sval[64][64];
   Integer ival[64];
   Universal * pval[64];
   Integer i,j,k;
   BUILD_FDEF bfd;
   Sequence l,la;
   String s;
   Integer noopt;

   ct = 0;
   mct = 0;
   sct = 0;

   sprintf(mbuf[mct],"%%COptions for %s\n",bf->name);
   menus[ct++] = mbuf[mct++];

   i = 0;
   k = 1;
   forin (bfd,BUILD_FDEF,l,bf->defs) {
      switch (bfd->type) {
	 case FDEF_CHOICE :
	    if (bfd->numvalues == 1) {
	       sprintf(mbuf[mct],"%%%do %s\n",k,bfd->values[0].option);
	       menus[ct++] = mbuf[mct++];
	       ival[k] = (vals[i] == 0);
	       pval[k] = (Universal *) &ival[k];
	       ++k;
	     }
	    else {
	       for (j = 0; j < bfd->numvalues; j += 2) {
		  if (bfd->numvalues != j+1) {
		     sprintf(mbuf[mct],"%%%d.%do %s%%M%%%d.%do %s",
				k,j,bfd->values[j].option,
				k,j+1,bfd->values[j+1].option);
		   }
		  else {
		     sprintf(mbuf[mct],"%%%d.%do %s",k,j,bfd->values[j].option);
		   };
		  menus[ct++] = mbuf[mct++];
		};
	       ival[k] = vals[i];
	       pval[k] = (Universal *) &ival[k];
	       ++k;
	       menus[ct++] = "";
	     };
	    break;
	 case FDEF_STRING :
	    sprintf(mbuf[mct],"%s %%%d.32t\n",bfd->values[0].option,k);
	    menus[ct++] = mbuf[mct++];
	    if (vals[i] == NULL) sval[sct][0] = 0;
	    else strcpy(sval[sct],vals[i]);
	    pval[k++] = (Universal *) sval[sct++];
	    break;
	 case FDEF_MULTIPLE :
	    sprintf(mbuf[mct],"%s:",bfd->values[0].option);
	    menus[ct++] = mbuf[mct++];
	    forin (s,String,la,(Sequence) vals[i]) {
	       sprintf(mbuf[mct],"    %%%d.32t",k);
	       menus[ct++] = mbuf[mct++];
	       strcpy(sval[sct],s);
	       pval[k++] = (Universal *) sval[sct++];
	     };
	    sprintf(mbuf[mct],"    %%%d.32t\n    %%%d.32t\n",k,k+1);
	    menus[ct++] = mbuf[mct++];
	    sval[sct][0] = 0;
	    sval[sct+1][0] = 0;
	    pval[k++] = (Universal *) sval[sct++];
	    pval[k++] = (Universal *) sval[sct++];
	    break;
       };
      ++i;
    };

   menus[ct++] = "   %0o Other Macro options\n";
   pval[0] = (Universal *) &noopt;
   noopt = 0;

   menus[ct++] = "   %a%M   %c";
   menus[ct] = 0;

   if (!STEMdialog(bw->window,menus,
		      pval[0],pval[1],pval[2],pval[3],pval[4],
		      pval[5],pval[6],pval[7],pval[8],pval[9],
		      pval[10],pval[11],pval[12],pval[13],pval[14],
		      pval[15],pval[16],pval[17],pval[18],pval[19],
		      pval[20],pval[21],pval[22],pval[23],pval[24],
		      pval[25],pval[26],pval[27],pval[28],pval[29]))
      return FALSE;

   i = 0;
   k = 1;
   sct = 0;
   forin (bfd,BUILD_FDEF,l,bf->defs) {
      switch (bfd->type) {
	 case FDEF_CHOICE :
	    if (bfd->numvalues == 1) {
	       vals[i] = (ival[k++] ? 0 : -1);
	     }
	    else {
	       vals[i] = ival[k++];
	     };
	    break;
	 case FDEF_STRING :
	    if (vals[i] == NULL || STRNEQ(vals[i],pval[k])) {
	       if (vals[i] != NULL) SFREE(vals[i]);
	       vals[i] = (Universal) SALLOC(pval[k]);
	     };
	    ++k;
	    break;
	 case FDEF_MULTIPLE :
	    ct = 0;
	    forin (s,String,la,(Sequence) vals[i]) {
	       SFREE(s);
	       ++ct;
	     };
	    if (vals[i] != NULL) LFREE(vals[i]);
	    la = NULL;
	    for (j = 0; j < ct+2; ++j) {
	       s = (String) pval[k];
	       while (isspace(*s)) ++s;
	       if (*s != 0) {
		  la = APPEND(SALLOC(s),la);
		};
	       ++k;
	     };
	    vals[i] = (Universal) la;
	    break;
       };
      ++i;
    };

   *nop = noopt;

   return TRUE;
};





/* end of buildflag.c */

