/************************************************************************/
/*									*/
/*		annotmsg.c						*/
/*									*/
/*	Message send/receive package for annotations			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "annot_local.h"





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Integer 	btn_wait_fct();
static	void		setup_add_msg();
static	void		setup_remove_msg();
static	void		format_register();
static	void		handle_add_msg();
static	void		handle_remove_msg();
static	void		handle_save_msg();
static	void		save_msg_rtn();
static	void		handle_clear_msg();
static	void		clear_msg_rtn();
static	void		send_message();
static	String		call_message();
static	String		send_message_any();
static	String		format_message();
static	Boolean 	valid_file();
static	void		display_finish();
static	void		check_reload();





/************************************************************************/
/*									*/
/*	ANNOT_msg_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
ANNOT_msg_init()
{
   AUXD ad;
   String s;

   ad = AUXDget_handle(NULL,"ANNOT");

   s = AUXDget_info(ad,"SAVE_MSG");
   if (s != NULL) MSGregister(s,handle_save_msg,1,NULL);
   s = AUXDget_info(ad,"CLEAR_MSG");
   if (s != NULL) MSGregister(s,handle_clear_msg,2,NULL);
};




/********************************************************************************/
/*										*/
/*	ANNOTbutton_handler -- handle button requests				*/
/*	btn_wait_fct -- dialog wait function for button handling		*/
/*										*/
/********************************************************************************/


int
ANNOTbutton_handler(w,btn)
   ASH_WINDOW w;
   String btn;
{
   ANNOT_WIN aw;
   ANNOT_BDESC bd;
   ANNOT_DESC ad;
   Sequence l;
   String f;
   Character buf[1024];

   aw = ANNOT_find_window(w);
   if (aw == NULL) return FALSE;

   bd = ANNOT_find_button_desc(aw,btn);
   if (bd == NULL) bd = ANNOT_find_button_desc(NULL,btn);

   if (bd != NULL) {
      if (bd->save) {
	 if (aw->edit_info == NULL) return FALSE;
	 if (!EDTsecure(aw->edit_info,NULL)) return FALSE;
	 ANNOT_send_close(aw,TRUE);
       }
      else if (aw->edit_info != NULL) EDTsynch(aw->edit_info);

      forin (ad,ANNOT_DESC,l,bd->remove) {
	 ANNOT_remove_all(aw,ad);
       };

      if (!bd->wait) {
	 send_message(bd->msg,aw->filename,1,0,aw->system,NULL,NULL,NULL,aw->wd);
       }
      else {
	 if (aw->edit_info != NULL) EDTenable(aw->edit_info,FALSE);
	 aw->exec_btn = bd;
	 if (bd->waitmsg) {
	    aw->exec_return = NULL;
	    format_message(buf,bd->waitmsg,aw->filename,1,0,aw->system,
			      NULL,NULL,NULL,aw->wd);
	    STEMdialog1_wait(aw->window,btn_wait_fct,buf);
	    f = aw->exec_return;
	  }
	 else f = call_message(bd->msg,aw->filename,1,0,aw->system,NULL,NULL,NULL,aw->wd);
	 display_finish(aw,bd,f);
	 aw->exec_btn = NULL;
	 if (aw->edit_info != NULL) EDTenable(aw->edit_info,TRUE);
       }
    };

   return TRUE;
};





static Integer
btn_wait_fct(w)
   ASH_WINDOW w;
{
   ANNOT_WIN aw;
   ANNOT_BDESC bd;
   String f;

   aw = ANNOT_find_window(w);
   if (aw == NULL || aw->exec_btn == NULL) return -1;

   bd = aw->exec_btn;
   f = call_message(bd->msg,aw->filename,1,0,aw->system,NULL,NULL,NULL,aw->wd);

   aw->exec_return = f;

   return 1;
};





/************************************************************************/
/*									*/
/*	ANNOT_msg_setup -- setup message routines			*/
/*									*/
/************************************************************************/


void
ANNOT_msg_setup(aw)
   ANNOT_WIN aw;
{
   ANNOT_DESC typ[64];
   ANNOT_DESC ad;
   Integer ct,i;
   Character buf[1024];
   Universal args[10];

   ct = ANNOT_inq_types(NULL,64,typ);

   for (i = 0; i < ct; ++i) {
      ad = typ[i];
      setup_add_msg(aw,ad);
      setup_remove_msg(aw,ad);
    };
};





/************************************************************************/
/*									*/
/*	ANNOT_msg_menu -- handle buttons on action menu 		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

Integer
ANNOT_msg_menu(aw,mnm,btn)
   ANNOT_WIN aw;
   String mnm;
   String btn;
{
   return ANNOTbutton_handler(aw->window,btn);
};





/************************************************************************/
/*									*/
/*	ANNOT_send_open -- handle opening an annotation window		*/
/*									*/
/************************************************************************/


void
ANNOT_send_open(aw)
   ANNOT_WIN aw;
{
   Sequence l;
   String s;

   if (aw->filename != NULL) {
      MSGsenda("ANNOT EDIT %s",aw->filename);
    };

   forin (s,String,l,aw->desc->msg_open) {
      send_message(s,aw->filename,1,0,aw->system,NULL,NULL,NULL,aw->wd);
    };
};





/************************************************************************/
/*									*/
/*	ANNOT_send_close -- handle closing an annotation window 	*/
/*									*/
/************************************************************************/


void
ANNOT_send_close(aw,save)
   ANNOT_WIN aw;
   Boolean save;
{
   if (aw->filename != NULL) {
      MSGsenda("ANNOT %s %s", (save ? "SAVE" : "ABORT"), aw->filename);
    };

   if (aw->desc->msg_close != NULL) {
      send_message(aw->desc->msg_close,aw->filename,1,0,aw->system,
		      NULL,NULL,NULL,aw->wd);
    };
};





/************************************************************************/
/*									*/
/*	ANNOT_send_add -- add an annotation				*/
/*									*/
/************************************************************************/


void
ANNOT_send_add(aw,ad,line,val,txt0,txt1,txt2)
   ANNOT_WIN aw;
   ANNOT_DESC ad;
   Integer line;
   Integer val;
   String txt0,txt1,txt2;
{
   if (ad->msg_add != NULL) {
      send_message(ad->msg_add,aw->filename,line,val,aw->system,txt0,txt1,txt2,aw->wd);
    };
};






/************************************************************************/
/*									*/
/*	ANNOT_send_remove -- remove an annotation			*/
/*									*/
/************************************************************************/


void
ANNOT_send_remove(an)
   ANNOTATION an;
{
   ANNOT_DESC ad;
   ANNOT_WIN aw;

   aw = an->window;
   ad = an->desc;

   if (ad->msg_remove != NULL) {
      send_message(ad->msg_remove,aw->filename,ANNOT_inq_line(an),
		  an->value,aw->system,an->text[0],an->text[1],an->text[2],aw->wd);
    };
};






/************************************************************************/
/*									*/
/*	ANNOT_send_update -- update an annotation			*/
/*									*/
/************************************************************************/


void
ANNOT_send_update(an)
   ANNOTATION an;
{
   ANNOT_DESC ad;
   ANNOT_WIN aw;

   aw = an->window;
   ad = an->desc;

   if (ad->msg_update != NULL) {
      send_message(ad->msg_update,aw->filename,ANNOT_inq_line(an),
		  an->value,aw->system,an->text[0],an->text[1],an->text[2],aw->wd);
    };
};






/************************************************************************/
/*									*/
/*	setup_add_msg -- setup message to add annotation		*/
/*	setup_remove_msg -- setup message to remove annotation		*/
/*									*/
/************************************************************************/


static void
setup_add_msg(aw,ad)
   ANNOT_WIN aw;
   ANNOT_DESC ad;
{
   Character buf[1024];
   Universal args[10];

   if (ad->msg_set == NULL) return;

   format_register(ad->msg_set,buf);

   args[0] = NULL;
   args[1] = 1;
   args[2] = 0;
   args[3] = NULL;
   args[4] = NULL;
   args[5] = NULL;
   args[6] = NULL;
   args[7] = (Universal) aw;
   args[8] = (Universal) ad;

   MSGregister(buf,handle_add_msg,9,args);
};





static void
setup_remove_msg(aw,ad)
   ANNOT_WIN aw;
   ANNOT_DESC ad;
{
   Character buf[1024];
   Universal args[10];

   if (ad->msg_unset == NULL) return;

   format_register(ad->msg_unset,buf);

   args[0] = NULL;
   args[1] = 1;
   args[2] = 0;
   args[3] = NULL;
   args[4] = NULL;
   args[5] = NULL;
   args[6] = NULL;
   args[7] = (Universal) aw;
   args[8] = (Universal) ad;

   MSGregister(buf,handle_remove_msg,9,args);
};





/************************************************************************/
/*									*/
/*	format_register -- format message for registration		*/
/*									*/
/************************************************************************/


static void
format_register(msg,buf)
   String msg;
   String buf;
{
   String s;

   while (*msg != 0) {
      if (*msg != '%') *buf++ = *msg++;
      else {
	 *buf++ = *msg++;
	 switch (*msg) {
	    case 'F' :
	       s = "1s";
	       break;
	    case 'L' :
	       s = "2d";
	       break;
	    case 'V' :
	       s = "3d";
	       break;
	    case 'S' :
	       s = "4s";
	       break;
	    case 'T' :
	       if (msg[1] >= '1' && msg[1] <= '3') {
		  ++msg;
		  if (*msg == '1') s = "5s";
		  else if (*msg == '2') s = "6s";
		  else if (*msg == '3') s = "7s";
		}
	       else s = "5s";
	       break;
	    default :
	       s = "";
	       *buf++ = *msg;
	       break;
	  };
	 while (*s != 0) *buf++ = *s++;
	 ++msg;
       };
    };

   *buf = 0;
};





/************************************************************************/
/*									*/
/*	handle_add_msg -- handle message to add annotation		*/
/*	handle_remove_msg -- handle message to remove annotation	*/
/*									*/
/************************************************************************/


static void
handle_add_msg(file,line,value,sys,text0,text1,text2,aw,ad,rid)
   String file;
   Integer line;
   Integer value;
   String sys;
   String text0,text1,text2;
   ANNOT_WIN aw;
   ANNOT_DESC ad;
   Integer rid;
{
   ANNOTATION an;
   Character buf[10240];
   String text[3];
   Integer i;
   Boolean chng,rld;

   if (rid >= 0) MSGreply(rid,NULL);

   if (!valid_file(aw,file,sys)) {
      if (ad->unique) {
	 an = ANNOT_search(aw,ad->unique_with,0,1);
	 if (an != NULL) ANNOT_remove(an);
       };
      return;
    };

   chng = MEMQ(ad,aw->set_on);
   rld = chng;

   if (aw->filename == NULL) {
      if (!chng) return;
      if (!ANNOT_setup_windows(aw,file)) return;
      if (aw->filename == NULL) return;
      rld = FALSE;
    };

   if (aw->edit_info == NULL || !MEMQ(ad,aw->allowed)) return;

   if (line == 0) return;

   if (aw->filename == NULL || !MSGfile_compare(file,aw->filename)) {
      if (chng && !ad->alternate) {
	 if (!ANNOT_change_file(aw,file,line,ad->alternate,ad->join)) return;
       }
      else {
	 if (ad->unique) {
	    an = ANNOT_search(aw,ad->unique_with,0,1);
	    if (an != NULL) ANNOT_remove(an);
	  };
	 return;
       };
    }
   else if (chng) {
      if (rld) check_reload(aw);
      if (ad->splitonly && EDTinq_bounds(aw->edit_info,NULL,NULL,NULL,2) <= 1) return;
      else if (ad->unique) ANNOT_change_file(aw,NULL,line,ad->alternate,ad->join);
      else {
	 an = ANNOT_search(aw,ad,0,1);
	 if (an == NULL) ANNOT_change_file(aw,NULL,line,ad->alternate,ad->join);
       };
    };

   i = EDTlast_line(aw->edit_info);
   if (line > i && i > 0) line = i;

   if (aw->edit_info == NULL || !MEMQ(ad,aw->allowed)) return;

   EDTsynch(aw->edit_info);

   an = ANNOT_add(aw,ad,line,1);
   if (an == NULL) return;

   an->value = value;

   text[0] = text0;
   text[1] = text1;
   text[2] = text2;

   for (i = 0; i < 3; ++i) {
      if (text[i] != NULL) {
	 if (an->text[i] != NULL) {
	    if (ad->accumulate) {
	       if (strlen(an->text[i]) + strlen(text[i]) < 1024)
		  sprintf(buf,"%s\n%s",an->text[i],text[i]);
	       else strcpy(buf,an->text[i]);
	       text[i] = buf;
	     };
	    SFREE(an->text[i]);
	  };
	 an->text[i] = SALLOC(text[i]);
       };
    };
};





/*ARGSUSED*/

static void
handle_remove_msg(file,line,value,sys,txt0,txt1,txt2,aw,ad,rid)
   String file;
   Integer line;
   Integer value;
   String sys;
   String txt0,txt1,txt2;
   ANNOT_WIN aw;
   ANNOT_DESC ad;
   Integer rid;
{
   ANNOTATION an;

   if (rid >= 0) MSGreply(rid,NULL);

   if (!valid_file(aw,file,sys) || aw->filename == NULL || line == 0 ||
	  !MSGfile_compare(file,aw->filename)) {
      if (ad->unique) {
	 an = ANNOT_search(aw,ad->unique_with,0,1);
	 if (an != NULL) ANNOT_remove(an);
       };
      return;
    };

   if (aw->edit_info != NULL) EDTsynch(aw->edit_info);

   an = ANNOT_find_value(aw,ad,line,value);
   if (an != NULL) ANNOT_remove(an);
};





/********************************************************************************/
/*										*/
/*	handle_save_msg -- handle save requests 				*/
/*	save_msg_rtn -- routine to handle save requests 			*/
/*	handle_clear_msg -- handle clear requests				*/
/*	clear_msg_rtn -- routine to handle clear requests			*/
/*										*/
/********************************************************************************/


static void
handle_save_msg(file,rid)
   String file;
   Integer rid;
{
   ANNOT_for_all_windows(save_msg_rtn,file,NULL);

   if (rid >= 0) MSGreply(rid,NULL);
};




static void
save_msg_rtn(aw,file)
   ANNOT_WIN aw;
   String file;
{
   if (valid_file(aw,file,NULL)) {
      if (aw->filename == NULL || STRNEQ(aw->filename,file)) return;
    };

   if (aw->edit_info != NULL) {
      EDTsecure(aw->edit_info,NULL);
      ANNOT_send_close(aw,TRUE);
    };
};





static void
handle_clear_msg(file,type,rid)
   String file;
   String type;
   Integer rid;
{
   ANNOT_DESC ad;

   ad = ANNOT_find_desc(NULL,type);

   if (ad != NULL) {
      ANNOT_for_all_windows(clear_msg_rtn,file,ad);
    };

   if (rid >= 0) MSGreply(rid,NULL);
};





static void
clear_msg_rtn(aw,file,ad)
   ANNOT_WIN aw;
   String file;
   ANNOT_DESC ad;
{
   if (valid_file(aw,file,NULL)) {
      if (aw->filename == NULL || STRNEQ(aw->filename,file)) return;
    };

   if (aw->edit_info != NULL) EDTsynch(aw->edit_info);

   if (ad != NULL) ANNOT_remove_all(aw,ad);
};






/************************************************************************/
/*									*/
/*	send_message -- send message					*/
/*	call_message -- send a call-type message			*/
/*									*/
/************************************************************************/


static void
send_message(msg,file,line,value,sys,text0,text1,text2,wd)
   String msg;
   String file;
   Integer line;
   Integer value;
   String sys;
   String text0,text1,text2;
   String wd;
{
   send_message_any(FALSE,msg,file,line,value,sys,text0,text1,text2,wd);
};





static String
call_message(msg,file,line,value,sys,text0,text1,text2,wd)
   String msg;
   String file;
   Integer line;
   Integer value;
   String sys;
   String text0,text1,text2;
   String wd;
{
   return send_message_any(TRUE,msg,file,line,value,sys,text0,text1,text2,wd);
};





static String
send_message_any(fg,msg,file,line,value,sys,text0,text1,text2,wd)
   Boolean fg;
   String msg;
   String file;
   Integer line;
   Integer value;
   String sys;
   String text0,text1,text2;
   String wd;
{
   Character buf[1024];
   String s;

   format_message(buf,msg,file,line,value,sys,text0,text1,text2,wd);

   if (!fg) {
      MSGsend(buf);
      s = NULL;
    }
   else s = MSGcall(buf);

   return s;
};





/********************************************************************************/
/*										*/
/*	format_message -- format message with included items			*/
/*										*/
/********************************************************************************/


static String
format_message(buf,msg,file,line,value,sys,text0,text1,text2,wd)
   Character buf[];
   String msg;
   String file;
   Integer line;
   Integer value;
   String sys;
   String text0,text1,text2;
   String wd;
{
   Character lbuf[256];
   String s,t;

   t = buf;

   while (*msg != 0) {
      if (*msg != '%') *t++ = *msg++;
      else {
	 ++msg;
	 switch (*msg) {
	    case 'F' :
	       if (file == NULL) s = "*";
	       else if (file[0] == '/') s = file;
	       else {
		  if (wd == NULL) wd = MSGinq_wd();
		  sprintf(lbuf,"%s/%s",wd,file);
		  s = lbuf;
		};
	       break;
	    case 'L' :
	       sprintf(lbuf,"%d",line);
	       s = lbuf;
	       break;
	    case 'V' :
	       sprintf(lbuf,"%d",value);
	       s = lbuf;
	       break;
	    case 'S' :
	       if (sys == NULL) s = "*";
	       else s = sys;
	       break;
	    case 'T' :
	       if (msg[1] >= '1' && msg[1] <= '3') {
		  ++msg;
		  if (*msg == '1') s = text0;
		  else if (*msg == '2') s = text1;
		  else if (*msg == '3') s = text2;
		}
	       else s = text0;
	       if (s == NULL) s = "";
	       *t++ = LIT_STRING;
	       while (*s != 0) *t++ = *s++;
	       *t++ = LIT_STRING;
	       s = "";
	       break;
	    default :
	       s = "";
	       *t++ = '%';
	       *t++ = *msg;
	       break;
	  };
	 while (*s != 0) *t++ = *s++;
	 ++msg;
       };
    };

   *t = 0;

   return buf;
};






/************************************************************************/
/*									*/
/*	valid_file -- check for valid filename				*/
/*									*/
/************************************************************************/


static Boolean
valid_file(aw,file,sys)
   ANNOT_WIN aw;
   String file;
   String sys;
{
   if (aw->window == NULL) return FALSE;

   if (aw->system != NULL && sys != NULL && !FIELDsystem_match(aw->system,sys))
      return FALSE;

   if (file == NULL || *file == 0 ||
	  STREQL(file,"<NONE>") || STREQL(file,"?") || STREQL(file,"*"))
      return FALSE;

   return TRUE;
};





/********************************************************************************/
/*										*/
/*	display_finish -- show that a command has finished			*/
/*										*/
/********************************************************************************/


static void
display_finish(aw,bd,rslt)
   ANNOT_WIN aw;
   ANNOT_BDESC bd;
   String rslt;
{
   String menu[10];
   Integer ct,inf,ln,lct,cct;
   Character buf[256],fbuf[10241],ffbf[10240];
   String s,t;

   ct = 0;
   if (rslt == NULL || *rslt == 0 ||
	  (bd->file && (STREQL(rslt,"*") || (inf = open(rslt,0)) < 0))) {
      sprintf(buf,"%%CCommand %s has finished",bd->name);
      menu[ct++] = buf;
    }
   else {
      sprintf(buf,"%%CResult of %s\n",bd->name);
      menu[ct++] = buf;
      if (bd->file) {
	 ln = read(inf,fbuf,10240);
	 fbuf[ln] = 0;
	 s = fbuf;
	 t = ffbf;
	 lct = 0;
	 cct = 0;
	 while (*s != 0) {
	    if (cct < 80 || *s == '\n') {
	       *t++ = *s;
	       if (*s == '%') *t++ = '%';
	       ++cct;
	     };
	    if (*s == '\n') {
	       cct = 0;
	       if (++lct >= 10) break;
	     };
	    ++s;
	  };
	 *t = 0;
	 if (*s != 0) strcat(ffbf," ...\n");
	 menu[ct++] = ffbf;
	 close(inf);
	 unlink(rslt);
       }
      else {
	 menu[ct++] = rslt;
       };
    };

   menu[ct++] = "\n%M   %a";
   menu[ct] = 0;

   STEMdialog(aw->window,menu);
};





/************************************************************************/
/*									*/
/*	check_reload -- check if we should reload the current file	*/
/*									*/
/************************************************************************/


static void
check_reload(aw)
   ANNOT_WIN aw;
{
   struct stat sbuf;

   if (aw->mod_time == 0) return;
   if (stat(aw->filename,&sbuf) < 0) return;

   if (sbuf.st_mtime > aw->mod_time) {
      ANNOT_change_file(aw,aw->filename,EDTcur_line(aw->edit_info),FALSE,FALSE);
    };
};





/* end of annotmsg.c */
