/************************************************************************/
/*									*/
/*		annotmain.c						*/
/*									*/
/*	General routines for annotation package 			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "annot_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	annot_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	ANNOT_init -- package initialization				*/
/*									*/
/************************************************************************/


void
ANNOT_init()
{
   PROT_INIT;
   PROTECT;
   if (!annot_inited) {
      annot_inited = TRUE;
      ANNOT_win_init();
      ANNOT_edit_init();
      ANNOT_act_init();
      ANNOT_data_init();
      ANNOT_def_init();
      ANNOT_msg_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	ANNOTnew_willow_window -- create a new willow window		*/
/*	ANNOTnew_edit_window -- create a new window for editing 	*/
/*									*/
/************************************************************************/


int
ANNOTnew_willow_window(w,name)
   ASH_WINDOW w;
   String name;
{
   register ANNOT_WIN aw;

   ANNOT_init();

   aw = ANNOT_create(w,name,NULL);

   if (aw == NULL) return FALSE;

   aw->willow_fg = TRUE;

   return TRUE;
};





int
ANNOTnew_edit_window(w,name)
   ASH_WINDOW w;
   String name;
{
   register ANNOT_WIN aw;
   String s;
   Character buf[1024];

   ANNOT_init();

   strcpy(buf,name);
   name = buf;
   s = index(name,'@');
   if (s != NULL) *s++ = 0;

   if (s == NULL) s = getenv("ANNOT_EDIT");
   if (s == NULL) s = "annotedit";

   aw = ANNOT_create(w,s,name);

   if (aw == NULL) return FALSE;

   aw->willow_fg = TRUE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	ANNOTnew_window -- create a new annotation window		*/
/*									*/
/************************************************************************/


int
ANNOTnew_window(w,type,file)
   ASH_WINDOW w;
   String type;
   String file;
{
   register ANNOT_WIN aw;

   ANNOT_init();

   aw = ANNOT_create(w,type,file);

   return (aw != NULL);
};





/* end of annotmain.c */
