/************************************************************************/
/*									*/
/*		annot_local.h						*/
/*									*/
/*	Local definitions for annotations package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	ANNOT__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <leaf.h>
#include <stem.h>

#include <auxd.h>
#include <editor.h>
#include <edt.h>
#include <msg.h>
#include <pmat.h>
#include <field.h>

#include <annot.h>

#include <sys/types.h>
#include <sys/stat.h>




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define MAX_PANES	8		/* max editor panes supported	*/

#define NUM_TEXT	3

#define SELECTION_MENU	"Select"

#define FIX_ANNOTATIONS "fixannot"




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _ANNOT_DESC *	ANNOT_DESC;
typedef struct _ANNOTATION *	ANNOTATION;
typedef struct _ANNOT_WDESC *	ANNOT_WDESC;
typedef struct _ANNOT_WIN *	ANNOT_WIN;
typedef struct _ANNOT_BDESC *	ANNOT_BDESC;
typedef struct _ANNOT_NEW *	ANNOT_NEW;



typedef enum {
   POS_LINE_BEGIN,
   POS_LINE_END,
   POS_USER_POS,
   POS_WORD_BEGIN,
   POS_SEMICOLON,
   POS_TEXT_BEGIN,
} ANNOT_POS;




typedef struct _ANNOT_DESC {
   String	name;
   String	display_text;
   Integer	display_font;
   Integer	display_level;
   Integer	color;
   ANNOT_POS	position;
   String	msg_add;
   String	msg_remove;
   String	msg_set;
   String	msg_unset;
   String	msg_update;
   String	textinfo[NUM_TEXT];
   Boolean	unique;
   Boolean	display;
   Boolean	force;
   Boolean	save;
   Boolean	private;
   Boolean	accumulate;
   Boolean	query;
   Boolean	multiple;
   Boolean	hilite;
   Boolean	alternate;
   Boolean	join;
   Boolean	splitonly;
   ANNOT_DESC	unique_with;
} ANNOT_DESC_INFO;





typedef struct _ANNOTATION {
   ANNOT_DESC	desc;
   EDT_MARK	mark;
   ANNOTATION	next;
   ANNOT_WIN	window;
   Integer	line;
   Integer	column;
   Integer	value;
   String	text[NUM_TEXT];
   Integer	frozen;
} ANNOTATION_INFO;




typedef struct _ANNOT_WDESC {
   String	name;
   Sequence	allowed;
   Sequence	set_on;
   Sequence	buttons;
   Sequence	msg_open;
   Sequence	search_for;
   String	msg_close;
   String	title;
   String	mode;
   Integer	sensitive;
   Integer	level;
   Boolean	parse;
   Boolean	readonly;
   Boolean	create;
   Boolean	savectl;
   Boolean	autofile;
   Boolean	choicepdm;
   Boolean	nopdm;
   Boolean	nowindow;
   Boolean	disable;
} ANNOT_WDESC_INFO;




typedef enum _ANNOT_STATE_TYPE {
   STATE_MENU,
   STATE_PDM,
   STATE_NONE,
} ANNOT_STATE_TYPE;



typedef struct _ANNOT_WIN {
   ASH_WINDOW	window;
   String	filename;
   String	system;
   String	wd;
   ANNOT_WDESC	desc;
   Integer	level;
   ANNOTATION	first_annot;
   ANNOTATION	last_display;
   ASH_WINDOW	edit_win;
   ASH_WINDOW	menu_win;
   ASH_WINDOW	annot_win;
   ASH_WINDOW	mesg_win;
   ASH_WINDOW	state_win;
   EDT_ID	edit_info;
   ANNOT_DESC	cur_annot;
   ANNOT_DESC	alt_annot;
   Sequence	set_on;
   Sequence	allowed;
   Integer	top_line[MAX_PANES];
   Integer	bot_line[MAX_PANES];
   Boolean	willow_fg;
   Boolean	remove_fg;
   Boolean	state_setup;
   Boolean	linevalid;
   ANNOT_STATE_TYPE state_pdm;
   ANNOT_DESC	search_type;
   Integer	search_line;
   Integer	search_dir;
   ANNOT_NEW	new_annot;
   ANNOT_BDESC	exec_btn;
   String	exec_return;
   Boolean	changing_file;
   String	new_file;
   Integer	new_line;
   time_t	mod_time;
} ANNOT_WIN_INFO;





typedef struct _ANNOT_BDESC {
   String	name;
   String	msg;
   String	waitmsg;
   Sequence	remove;
   Boolean	save;
   Boolean	wait;
   Boolean	file;
} ANNOT_BDESC_INFO;





typedef struct _ANNOT_NEW {
   ANNOT_NEW next;
   ANNOT_DESC ad;
   Integer line;
   Integer col;
   String str[NUM_TEXT];
} ANNOT_NEW_INFO;




/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* annotmain.c			*/
extern	void		ANNOT_init();



					/* annotwin.c			*/
extern	void		ANNOT_win_init();
extern	ANNOT_WIN	ANNOT_create();
extern	Boolean 	ANNOT_setup_windows();
extern	ANNOT_WIN	ANNOT_find_window();
extern	void		ANNOT_set_window_name();
extern	void		ANNOT_for_all_windows();



					/* annotedit.c			*/
extern	void		ANNOT_edit_init();
extern	void		ANNOT_edit_setup();
extern	Boolean 	ANNOT_change_file();
extern	Integer 	ANNOT_edit_quit();



					/* annotdata.c			*/
extern	void		ANNOT_data_init();
extern	ANNOTATION	ANNOT_add();
extern	void		ANNOT_remove();
extern	void		ANNOT_user_remove();
extern	void		ANNOT_remove_all();
extern	void		ANNOT_clear();
extern	void		ANNOT_rotate();
extern	void		ANNOT_rotate();
extern	ANNOTATION	ANNOT_search();
extern	ANNOTATION	ANNOT_find();
extern	ANNOTATION	ANNOT_find_value();
extern	void		ANNOT_display();
extern	void		ANNOT_iterate();
extern	void		ANNOT_update();
extern	Integer 	ANNOT_inq_line();
extern	Integer 	ANNOT_inq_line();
extern	Integer 	ANNOT_get_line();




					/* annotact.c			*/
extern	void		ANNOT_act_init();
extern	void		ANNOT_annot_setup();
extern	Integer 	ANNOT_annot_btn();
extern	Integer 	ANNOT_act_search();
extern	Integer 	ANNOT_act_search_for();
extern	Integer 	ANNOT_act_search_again();
extern	Integer 	ANNOT_act_remove();
extern	Integer 	ANNOT_act_rotate();
extern	Integer 	ANNOT_act_monitor();
extern	Integer 	ANNOT_act_display();
extern	Integer 	ANNOT_act_update();
extern	Integer 	ANNOT_edit_mouse();
extern	void		ANNOT_do_add();



					/* annotdef.c			*/
extern	void		ANNOT_def_init();
extern	ANNOT_WDESC	ANNOT_find_window_desc();
extern	ANNOT_DESC	ANNOT_find_desc();
extern	ANNOT_BDESC	ANNOT_find_button_desc();
extern	Integer 	ANNOT_inq_window_types();
extern	Integer 	ANNOT_inq_types();



					/* annotmsg.c			*/
extern	void		ANNOT_msg_init();
extern	void		ANNOT_msg_setup();
extern	Integer 	ANNOT_msg_menu();
extern	void		ANNOT_send_open();
extern	void		ANNOT_send_close();
extern	void		ANNOT_send_add();
extern	void		ANNOT_send_remove();
extern	void		ANNOT_send_update();






/* end of annot_local.h */
