/*
 *  Copyright (C) 1993 Michael Tiller
 *
 *  Permission is hereby granted by the author to use, copy, modify,
 *  and distribute this code for any purpose provided this copyright
 *  notice is included in all copies.  This code is provided "as is"
 *  without any expressed or implied warranty.
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	"expr.h"
#include	"sub.h"

/* String to return for a zero result */
static	char	zero_res[] = "0.0";

/* External symbols needed here */
extern	void	deriv_setpos(char *);
extern	void	deriv_reset();
extern	ExprPtr	expr_result;

char*
parse_expr(char *string)
{
	ExprPtr	res;
	char	*exp;

	deriv_setpos(string);
	deriv_parse();

	if (expr_result==NULL)
		return NULL;

	res = expr_result;
	
	deriv_reset();
	expr_result = NULL;

	return StringExpr(res);
}

char*
eval_expr(char *string)
{
	ExprPtr	res;
	char	*exp;

	deriv_setpos(string);
	deriv_parse();

	if (expr_result==NULL)
		return NULL;

	res = EvalExpr(expr_result);
	
	deriv_reset();
	expr_result = NULL;

	if (res==NULL)
		return NULL;
	else
		return StringExpr(res);
}

char*
take_deriv(char *string, char *var, int total)
{
	ExprPtr	res;
	char	*exp;

	deriv_setpos(string);
	deriv_parse();

	if (expr_result==NULL)
		return NULL;

	res = Derivative(expr_result, var, total);
	
	deriv_reset();
	expr_result = NULL;

	if (res==NULL)
		return strdup(zero_res);
	else
		return StringExpr(res);
}



