/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _xview.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <math.h>
#include <string.h>
#include <stdio.h>
#include <values.h>

#include <X11/X.h>
#include <X11/Xlib.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/scrollbar.h>
#include <xview/xv_xrect.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/openmenu.h>
#include <xview/icon.h>


#undef TRACE 

#ifdef TRACE
#define DPRINT(x) printf x
#else
#define DPRINT(x)
#endif


#define XPIX(coord) (int)(xorigin + (coord)*x_draw_scale)
#define YPIX(coord) (int)(yorigin - (coord)*x_draw_scale)

#define XREAL(pix)  ((double)(pix-xorigin)/x_draw_scale)
#define YREAL(pix)  ((double)(yorigin-pix)/x_draw_scale)


extern Notify_error notify_dispatch();



static short icon_image[] = {

#include "leda.icon"

};

static mpr_static(leda_icon_pixrect,64,64,1,icon_image);

static char default_frame_label[128];
static int  repaint_count;

/* pr_tex_dashed */
static unsigned char dotted[2] = { 2,6 };
static unsigned char dashed[2] = { 4,4 };

static char frame_label[80];

static char read_frame_format[] = "%8.2f %8.2f      %s";

static Frame	frame;
static Canvas	canvas;
static Pixwin  *pw = 0;

static Pixmap   buffer_pixmap[8];
static int      buffer_width[8];
static int      buffer_height[8];

static int              pixel_table[8];
static Xv_cmsdata	cms_data;	
static unsigned char	red[8], green[8], blue[8];


static char     text_panel_answer[256];

static Frame   panel_frame;
static Panel   panel;
static Icon    icon;

static void panel_input_notify();
static void init_panel_frame();
static void panel_input_text_notify();
static void init_panel_text_frame();
static void text_panel_menu_proc();


typedef void (*PRD)();
typedef void (*PMA)();

static void x_draw_mouse_default_action(x,y) 
double x,y;
{ /* do nothing */}

static PRD x_draw_redraw = 0;
static PMA x_draw_mouse_action = x_draw_mouse_default_action;

static int x_draw_done;

static Xv_Font text_font,bold_font,message_font;
static Display *display;
static Drawable drawable;
static int screen;

static GC  gc;

static int xpix_mode_op;

static int draw_init_done = FALSE;

static int xdots,ydots, xorigin,yorigin;  /* pixels          */

static int mouse_key,mouse_xpix, mouse_ypix; 
static int mouse_last_xpix, mouse_last_ypix;
static int mouse_start_xpix, mouse_start_ypix;  /* start for segments  ... */
static int mouse_read_kind;


static double mouse_xreal,mouse_yreal;
static double mouse_last_xreal,mouse_last_yreal;
static double mouse_start_xreal,mouse_start_yreal;

static char* mesg_list[32];
static int   mesg_count;




static int  screen_width, screen_height;
static int Line_style = 0;


static Xv_singlecolor x_draw_color_map[] = {

 {  255,  255,  255 },  /* white  */
 {    0,    0,    0 },  /* black  */
 {  255,    0,    0 },  /* red    */
 {    0,  255,    0 },  /* green  */
 {    0,  100,  255 },  /* blue   */
 {  128,  128,    0 },  /* yellow */
 {  128,    0,  178 },  /* violet */
 {  192,   64,    0 }   /* orange */

};


/* external variables */

/*
SCREEN_WIDTH = 1152;
SCREEN_HEIGHT = 900;
*/

int x_draw_window_xpos = 0;
int x_draw_window_ypos = 0;
int x_draw_window_width = 0;
int x_draw_window_height = 0;
   
double x_draw_xmax,x_draw_xmin,x_draw_ymax,x_draw_ymin,x_draw_scale;   

int    x_draw_grid_mode;
int    x_draw_depth;

int    x_draw_line_width, x_draw_node_width, x_draw_line_style, x_draw_color,
       x_draw_text_mode, x_draw_drawing_mode, x_draw_screen_flush;






x_draw_flush() { XFlush(display); }

x_draw_set_redraw(f)
PRD f;
{ x_draw_redraw = f; }

x_draw_set_frame_label(message)
char* message;
{ /* strcpy(frame_label,message);  */
  window_set(frame,FRAME_LABEL,message,0);
}


x_draw_reset_frame_label() 
{ /* strcpy(frame_label,default_frame_label); } */
  window_set(frame,FRAME_LABEL,default_frame_label,0);
 }


x_draw_set_gc_read_mouse()
{ XGCValues gc_val;
  gc_val.function = GXxor; 
  gc_val.foreground = pixel_table[1];
  gc_val.line_style = LineSolid;
  gc_val.line_width = 1;
  XChangeGC(display,gc,GCForeground|GCFunction|GCLineStyle|GCLineWidth,&gc_val);
  XFlush(display);
}

x_draw_reset_gc()
{ XGCValues gc_val;
  gc_val.function   = xpix_mode_op; 
  gc_val.foreground = pixel_table[x_draw_color];
  gc_val.line_style = Line_style;
  gc_val.line_width = x_draw_line_width;
  XChangeGC(display,gc,GCForeground|GCFunction|GCLineStyle|GCLineWidth,&gc_val);
  XFlush(display);
}

void x_draw_mouse_segment_action(x,y)
double x,y;
{
  XDrawLine(display,drawable,gc,mouse_start_xpix,mouse_start_ypix,XPIX(x),YPIX(y));

}

void x_draw_mouse_rect_action(x,y)
double x,y;
{ 
    x_draw_rectangle(mouse_start_xreal,mouse_start_yreal,x,y,1,1);
 } 

void x_draw_mouse_circle_action(x,y)
double x,y;
{   double r = hypot(x - mouse_start_xreal, y - mouse_start_yreal);
    x_draw_circle(mouse_start_xreal, mouse_start_yreal, r, 1, 1);    
}


x_draw_init_fonts()
{ /* initialize fonts: text_font, bold_font, message_font */

  XGCValues gc_val;

 text_font = (Xv_Font)xv_find(frame, FONT,
                         FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
                         FONT_STYLE,  FONT_STYLE_NORMAL,
                         FONT_SIZE,   14,
                         0);

 bold_font = (Xv_Font)xv_find(frame, FONT,
                         FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
                         FONT_STYLE,  FONT_STYLE_BOLD,
                         FONT_SIZE,   14,
                         0);

 message_font = (Xv_Font)xv_find(frame, FONT,
                         FONT_FAMILY, FONT_FAMILY_LUCIDA_FIXEDWIDTH,
                         FONT_STYLE,  FONT_STYLE_NORMAL,
                         FONT_SIZE,   24,
                         0);

    if (!text_font)    
     { fprintf(stderr,"Cannot open text font\n");
       text_font = (Xv_Font)xv_get(frame,XV_FONT);
      }

    if (!bold_font)    
     { fprintf(stderr,"Cannot open bold font\n");
       bold_font = (Xv_Font)xv_get(frame,XV_FONT);
      }

    if (!message_font) 
     { fprintf(stderr,"Cannot open message font\n");
       message_font = (Xv_Font)xv_get(frame,XV_FONT);
      }


      gc_val.font = (Font)xv_get(text_font,XV_XID);
      XChangeGC(display,gc,GCFont,&gc_val);
}

x_draw_set_font(fname)
char* fname;
{
  XGCValues gc_val;
  Xv_Font f;

  xv_set(frame,FRAME_BUSY,TRUE,NULL);
  f = (Xv_Font)xv_find(frame,FONT,FONT_NAME,fname,NULL);
  xv_set(frame,FRAME_BUSY,FALSE,NULL);

  if (f) 
  { text_font = f;
    gc_val.font = (Font)xv_get(text_font,XV_XID);
    XChangeGC(display,gc,GCFont,&gc_val);
   }

}


int x_draw_set_color(col)
int col;
{ int save = x_draw_color;
  x_draw_color = (x_draw_depth==1 && col > 1) ? 1 : col;
  XSetForeground(display,gc,pixel_table[x_draw_color]);
  return save;
 }


int x_draw_set_line_width(w)
int w;
{ XGCValues gc_val;
  int save = x_draw_line_width;
  x_draw_line_width = w;
  gc_val.line_width = x_draw_line_width;
  XChangeGC(display,gc,GCLineWidth,&gc_val);
  return save;
}


int x_draw_set_line_style(s)
int s;
{ XGCValues gc_val;

  int save = x_draw_line_style;

  x_draw_line_style = s;
 
   switch (x_draw_line_style)  {

   case 0 : Line_style = LineSolid;
            break;

   case 1 : Line_style = LineOnOffDash;
            XSetDashes(display,gc,0,dashed,2);
            break;

   case 2 : Line_style = LineOnOffDash;
            XSetDashes(display,gc,0,dotted,2);
            break;

   default: Line_style = LineSolid;
            break;

   }

  gc_val.line_style = Line_style;
  XChangeGC(display,gc,GCLineStyle,&gc_val);
  return save;
}

int x_draw_set_node_width(w)
int w;
{ int save = x_draw_node_width;
  x_draw_node_width = w;
  return save;
 }

int x_draw_set_text_mode(m)
int m;
{ int save = x_draw_text_mode;
  x_draw_text_mode = m;
  return save;
 }

int x_draw_set_mode(m)
int m;
{ 
  XGCValues gc_val;

  int save = x_draw_drawing_mode;

  x_draw_drawing_mode = m;


  DPRINT(("x_draw_set_mode %d\n",x_draw_drawing_mode));

   switch (x_draw_drawing_mode)  {

   case 0 : xpix_mode_op = GXcopy;
            break;

   case 1 : xpix_mode_op = GXxor;
            break;

   case 2 : xpix_mode_op = GXor;
            break;

   default: break;

   }

  gc_val.function = xpix_mode_op; 
  XChangeGC(display,gc,GCFunction,&gc_val);

  return save;
}


static void x_draw_event_proc(canvas,event)
Canvas canvas;
Event* event;
{ 
  char s[32];


  int k = event_id(event); 

/*
printf("event = %d\n",k);
fflush(stdout);
*/

  switch (k) {

  case ACTION_SELECT:
  case MS_LEFT:   if (event_is_up(event)) break;
                  mouse_key = 1;

                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;

  case ACTION_ADJUST:
  case MS_MIDDLE: if (event_is_up(event)) break;
                  mouse_key = 2;
                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;

  case ACTION_MENU:
  case MS_RIGHT:  if (event_is_up(event)) break;
                  mouse_key = 3;
                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;


  case LOC_MOVE: 
  case LOC_WINENTER : 
  case LOC_WINEXIT : 
           mouse_xpix = event_x(event);
           mouse_ypix = event_y(event);

           if (x_draw_grid_mode)  x_draw_cursor();
         
           mouse_xreal =  x_draw_xmin+((double)mouse_xpix)/x_draw_scale;
           mouse_yreal =  x_draw_ymax-((double)mouse_ypix)/x_draw_scale;
         
         if (x_draw_grid_mode) 
         { 
           mouse_xreal = x_draw_grid_mode * (int)(mouse_xreal/x_draw_grid_mode + ((mouse_xreal > 0) ? 0.5 : -0.5));

           mouse_yreal = x_draw_grid_mode * (int)(mouse_yreal/x_draw_grid_mode + ((mouse_yreal > 0) ? 0.5 : -0.5));

           mouse_xpix  = XPIX(mouse_xreal);
           mouse_ypix  = YPIX(mouse_yreal);
         
           x_draw_cursor();
         }
       
       /* sprintf(s,read_frame_format, mouse_xreal,mouse_yreal,frame_label);
          window_set(frame,FRAME_LABEL,s,0);
       */

         sprintf(s,"%8.2f %8.2f", mouse_xreal,mouse_yreal);

         XDrawImageString(display,drawable,gc,xdots-160,13,s,strlen(s));
       
       
         if (x_draw_mouse_action) /* user defined action */
         { x_draw_mouse_action(mouse_last_xreal,mouse_last_yreal);
           x_draw_mouse_action(mouse_xreal,mouse_yreal);
          }
       
         mouse_last_xpix = mouse_xpix;
         mouse_last_ypix = mouse_ypix;
       
         mouse_last_xreal = mouse_xreal;
         mouse_last_yreal = mouse_yreal;
       
         break;

     } /* switch */

/*
printf("event_if = %d  key = %d  xreal = %f yreal = %f\n",k,mouse_key, mouse_xreal,mouse_yreal);
fflush(stdout);
*/


}

int x_read_mouse(kind, xstart,ystart,x,y)
int    kind;   /* 0: point, 1: segment, 2:rectangle, 3: circle */
double xstart;
double ystart;
double *x;
double *y;
{ 
  PMA f;
  int key;
  
  switch(kind) {

  case 0 : f = x_draw_mouse_default_action;
          break;

  case 1:  f = x_draw_mouse_segment_action;
           break;

  case 2:  f = x_draw_mouse_rect_action;
           break;

  case 3:  f = x_draw_mouse_circle_action;
           break;

  default: f = x_draw_mouse_default_action;
           break;

  }

  key = x_read_mouse_action(f,xstart,ystart,x,y);

  return key;

}


int x_draw_get_button()
{ x_draw_mouse_action = x_draw_mouse_default_action;
  mouse_key = 0;
  notify_dispatch();
  return mouse_key;
 }


int x_read_mouse_action(action, xstart,ystart,x,y)
PMA   action;
double xstart;
double ystart;
double *x;
double *y;
{ 
  DPRINT(("x_read_mouse_action\n"));
  x_draw_mouse_action = action;

  x_draw_set_gc_read_mouse();


  mouse_key = 0;

  mouse_start_xreal = xstart;
  mouse_start_yreal = ystart;

  mouse_start_xpix = XPIX(xstart);
  mouse_start_ypix = YPIX(ystart);

  if (x_draw_grid_mode) x_draw_cursor();

  if (x_draw_mouse_action)  /* user defined action */
  { x_draw_mouse_action(mouse_last_xreal,mouse_last_yreal);
   }


  /* notify-loop */

  while (!mouse_key && !x_draw_done)  notify_dispatch();

  

  if (x_draw_mouse_action)  /* user defined action */
  { x_draw_mouse_action(mouse_xreal,mouse_yreal);
   }

  if (x_draw_grid_mode) x_draw_cursor();

  *x = mouse_xreal;
  *y = mouse_yreal;

  x_draw_reset_gc();

  if (x_draw_done) return 0;

  return mouse_key;
}
  

static void x_draw_canvas_repaint_proc(canvas,paint_window,dpy,xwin,xrects)
Canvas canvas;
Xv_Window paint_window;
Display *dpy;
Window  xwin;
Xv_xrectlist *xrects;
{
  repaint_count++;
 }

static void x_draw_canvas_resize_proc(canvas,width,height)
Canvas canvas;
int    width;
int    height;
{
/*
 printf("RESIZE canvas = %d  widht = %d  height =%d\n",canvas,width,height);
 fflush(stdout);
*/
  if (draw_init_done)
      x_draw_init(x_draw_xmin,x_draw_xmax,x_draw_ymin,x_draw_grid_mode); 
}




Notify_value x_draw_notice_destroy(frame, status)
Frame frame;
Destroy_status status;
{
/*
  printf("x_draw_notice_destroy called\n");
*/

  if (status != DESTROY_CHECKING)
  { x_draw_done = 1;
    exit(0);
   }

  return (notify_next_destroy_func(frame,status));
}


/*
static error_proc(object,avlist)
Xv_object    object;
Attr_avlist  avlist;
{ char  buf[32];
  printf("%s\n", xv_error_format(object,avlist));
  printf("Dump core ? ");
  fflush(stdout);
  if (gets(buf) && (buf[0] == 'y')) abort();
  return XV_OK;
 }
*/
  


x_draw_init_window(w_width,w_height,w_xpos,w_ypos,frame_label)
int w_width,
    w_height,
    w_xpos,
    w_ypos;
char* frame_label;
{ 
  int       i, *xpixels;
  Xv_Screen xv_screen;
  XGCValues gc_val;
  Rect      *r;


  DPRINT(("x_draw_init_window\n"));
  if (pw!=0) 
  { fprintf(stderr,"warning: second initialization of window ignored.\n");
    return;
   } 

  strcpy(default_frame_label,frame_label);

/*
  xv_init(XV_ERROR_PROC, error_proc,0);
*/


  /* initalize the colormap segment data and set the required RGB values */

  (red)[0] =  255; (green)[0] = 255; (blue)[0] =  255 ;  /* white  */
  (red)[1] =    0; (green)[1] =   0; (blue)[1] =    0 ;  /* black  */
  (red)[2] =  255; (green)[2] =   0; (blue)[2] =    0 ;  /* red    */
  (red)[3] =    0; (green)[3] = 255; (blue)[3] =    0 ;  /* green  */
  (red)[4] =    0; (green)[4] = 100; (blue)[4] =  255 ;  /* blue   */
  (red)[5] =  128; (green)[5] = 128; (blue)[5] =    0 ;  /* yellow */
  (red)[6] =  128; (green)[6] =   0; (blue)[6] =  178 ;  /* violet */
  (red)[7] =  192; (green)[7] =  64; (blue)[7] =    0 ;  /* orange */

    cms_data.type = XV_STATIC_CMS;
    cms_data.size = 8;
    cms_data.rgb_count = 8;
    cms_data.index = 0;
    cms_data.red = red;
    cms_data.green = green;
    cms_data.blue = blue;

  icon = icon_create(ICON_IMAGE, &leda_icon_pixrect, 0);


  repaint_count = 0;


  frame = window_create(0, FRAME, 
              WIN_X,        w_xpos,
              WIN_Y,        w_ypos,
              WIN_WIDTH,    w_width-10,
              WIN_HEIGHT,   w_height-30,
              WIN_IGNORE_EVENT,      WIN_REPAINT,
              FRAME_NO_CONFIRM, TRUE,
              FRAME_LABEL, default_frame_label, 
              0);

/*
  icon = (Icon)xv_create(frame,ICON,
                         ICON_IMAGE,icon_image,
                         XV_X, 100,
                         XV_Y, 100,
                         0);

*/

  window_set(frame, FRAME_ICON, icon,0);

  window_set(frame, WIN_SHOW, TRUE, 0);

  canvas = window_create(frame, CANVAS,
              WIN_EVENT_PROC,        x_draw_event_proc,
              CANVAS_REPAINT_PROC,   x_draw_canvas_repaint_proc,
              CANVAS_RESIZE_PROC,    x_draw_canvas_resize_proc,
              CANVAS_X_PAINT_WINDOW, TRUE,
              WIN_CMS_NAME,          "palette",
              WIN_CMS_DATA,          &cms_data,
              WIN_IGNORE_EVENT,      WIN_REPAINT,
              0); 



/*
  xv_create(canvas,SCROLLBAR,
            SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL, 0);

  xv_create(canvas,SCROLLBAR,
            SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL, 0);
*/





  /* Get the actual indices into the colormap and store them in pixel_table */

  xpixels = (int *)xv_get(canvas, WIN_X_COLOR_INDICES);

  for (i = 0; i < 8; i++) pixel_table[i] = xpixels[i];
	
  pw = canvas_pixwin(canvas);

  xv_set(canvas_paint_window(canvas),
    WIN_EVENT_PROC,          x_draw_event_proc,
    WIN_CONSUME_EVENTS,      WIN_RIGHT_KEYS, LOC_MOVE,
                             LOC_WINENTER, LOC_WINEXIT,
                             WIN_MOUSE_BUTTONS,
                             0,
    WIN_IGNORE_EVENTS,       WIN_REPAINT,WIN_UP_EVENTS,0,
    0); 

  notify_interpose_destroy_func(frame,x_draw_notice_destroy);



  display   = (Display *)xv_get(frame,XV_DISPLAY);
  drawable  = (Drawable)xv_get(pw,XV_XID);
  xv_screen = (Xv_Screen)xv_get(frame,XV_SCREEN);
  screen    = (int)xv_get(xv_screen,SCREEN_NUMBER);

  gc    = DefaultGC(display,screen);
  x_draw_depth = DefaultDepth(display,screen);

  screen_width = DisplayWidth(display,screen);
  screen_height = DisplayHeight(display,screen);

  XSetLineAttributes(display,gc,1,LineSolid,CapButt,JoinMiter);

  x_draw_init_fonts();

  x_draw_set_line_style(0);
  x_draw_set_line_width(1);
  x_draw_set_mode(0);
  x_draw_set_node_width(12);
  x_draw_set_text_mode(0); 

  x_draw_color = 1;
  gc_val.foreground = BlackPixel(display,screen); 
  XChangeGC(display,gc,GCForeground,&gc_val);

  for(i=0;i<8;i++)
  { buffer_width[i] = 0;
    buffer_height[i] = 0;
   }

  x_draw_xmin = 0;
  x_draw_ymin = 0;
  x_draw_xmax = 0;
  x_draw_ymax = 0;
  x_draw_scale = 1;
  mouse_xpix = 0;
  mouse_ypix = 0;

  mesg_count = 0;

  x_draw_window_xpos = w_xpos;
  x_draw_window_ypos = w_ypos;
  x_draw_window_width = w_width;
  x_draw_window_height = w_height;


  /* wait for REPAINT events (non-blocking) */

  i = 0;
  while (repaint_count == 0 && i < 20000)   /* first REPAINT */
  { notify_dispatch();
    i++;
   }

  i = 0;
  while (repaint_count < 2 && i < 1000)   /* openwin: second REPAINT */ 
  { notify_dispatch();
    i++;
   }

  x_draw_reset_frame_label();

  XFlush(display);

}

x_draw_init(x0,x1,y0,g_mode)
double x0,x1,y0;
int g_mode;
{
  double x,y;

  DPRINT(("x_draw_init\n"));

  draw_init_done = TRUE;

  if (x0>=x1) 
  {fprintf(stderr,"Illegal arguments in draw_init: x0 (%f) >= x1 (%f)\n",x0,x1);
   abort();
   }

  x_draw_grid_mode = g_mode; 

  xdots = (int)window_get(canvas, CANVAS_WIDTH);
  ydots = (int)window_get(canvas, CANVAS_HEIGHT);


  x_draw_scale = ((double)xdots)/(x1-x0);

  /* at least grid distance of 2 pixels */
  if ((x_draw_grid_mode) && (x_draw_grid_mode*x_draw_scale < 2)) 
  { x_draw_grid_mode=0;  
    fprintf(stderr,"warning: grid distance to small.\n");
   }

  if (x_draw_grid_mode) 
  { if (x_draw_scale < 1) x_draw_scale = 1;
    else x_draw_scale = (int)x_draw_scale;
    DPRINT(("grid mode %d ; draw scale %d\n",x_draw_grid_mode,x_draw_scale));
  }

  x_draw_xmin = x0;
  x_draw_ymin = y0;
  x_draw_xmax = x0+xdots/x_draw_scale;
  x_draw_ymax = y0+ydots/x_draw_scale;

  xorigin = -x0*x_draw_scale;
  yorigin = ydots+y0*x_draw_scale;

  mouse_xreal = 0;
  mouse_yreal = 0;

  x_draw_clear(0);   

  if (x_draw_grid_mode)  x_draw_cursor();

  notify_dispatch();

  if (x_draw_grid_mode)  x_draw_cursor();

  if (x_draw_redraw) (*x_draw_redraw)();

  XFlush(display);

}

x_show_window()   { while (!x_draw_done) notify_dispatch(); }

x_draw_end()
{ if (pw)
  { pw_close(pw);
    /* window_destroy(frame); */
    pw = 0;
   }
}

x_draw_xpix(x)
double x;
{ return XPIX(x); }

x_draw_ypix(x)
double x;
{ return YPIX(x); }

x_draw_pix(x,y,col)
double x,y;
int col;
{ if (col != x_draw_color) x_draw_set_color(col);

  XDrawPoint(display,drawable,gc,XPIX(x),YPIX(y));

  if (x_draw_screen_flush)
    XFlush(display);
}


x_draw_line(x1, y1, x2, y2, col)
double x1,y1,x2,y2;
int col;
{ 
  int C[4];
  int i;

  int M = 32768;   /* 2^15    */ 

  double slope;

  DPRINT(("x_draw_line %d\n",xpix_mode_op));

  C[0] = XPIX(x1);
  C[1] = YPIX(y1);
  C[2] = XPIX(x2);
  C[3] = YPIX(y2);

  DPRINT(("x_draw_line %d  %d  %d  %d\n\n",C[0],C[1],C[2],C[3]));

  /* 
    Fehler beim Clipping fuer Koordinaten mit Absolutwert in
    [i*2^15..(i+1)*2^15-1],i ungerade.
  */

  for(i=0; i<4; i++)
    if ((C[i]/M) % 2) C[i] = -C[i];




  if (col != x_draw_color) x_draw_set_color(col);

  XDrawLine(display,drawable,gc,C[0],C[1],C[2],C[3]);

  if (x_draw_screen_flush)
    XFlush(display);
}


x_draw_point(x,y,col)
double x,y;
int col;
{ 
  int X = XPIX(x);
  int Y = YPIX(y);

  xv_vector(pw,X-2,Y-2,X+2,Y+2,PIX_SRC^PIX_DST,1);
  xv_vector(pw,X+1,Y-1,X+2,Y-2,PIX_SRC^PIX_DST,1);
  xv_vector(pw,X-1,Y+1,X-2,Y+2,PIX_SRC^PIX_DST,1);

  if (x_draw_screen_flush) XFlush(display);
}

x_draw_arc(x0,y0,a,b,col)
double x0,y0;
int a,b,col;
{ 

  if (col != x_draw_color) x_draw_set_color(col);

  XDrawArc(display,drawable,gc,XPIX(x0)-a,YPIX(y0)-b,2*a,2*b,0,360*64);

  if (x_draw_screen_flush)
    XFlush(display);

}

x_draw_filled_arc(x0,y0,a,b,col)
double x0,y0;
int a,b,col;
{ 
  if (col != x_draw_color) x_draw_set_color(col);

  XFillArc(display,drawable,gc,XPIX(x0)-a,YPIX(y0)-b,2*a,2*b,0,360*64);

  if (x_draw_screen_flush)
    XFlush(display);

}

x_draw_node(x0,y0,col)
double x0,y0;
int col;
{ int save = x_draw_set_line_width(1); 
  x_draw_arc(x0,y0,x_draw_node_width,x_draw_node_width,col); 
  x_draw_set_line_width(save); 
 }

x_draw_filled_node(x0,y0,col)
double x0,y0;
int col;
{ x_draw_filled_arc(x0,y0,x_draw_node_width,x_draw_node_width,col); }


x_draw_text_node(x0,y0,s,col)
double x0,y0;
int col;
char* s;
{ XGCValues gc_val;
  int save;

  gc_val.font = (Font)xv_get(bold_font,XV_XID);
  XChangeGC(display,gc,GCFont,&gc_val);
  save = x_draw_text_mode;
  x_draw_text_mode = 0;  /* transparent */

  if (x_draw_depth==1 || col == 1)
     x_draw_node(x0,y0,1);
  else
     x_draw_filled_node(x0,y0,col);

  x_draw_ctext(x0,y0,s,1);
  x_draw_text_mode = save;

  gc_val.font = (Font)xv_get(text_font,XV_XID);
  XChangeGC(display,gc,GCFont,&gc_val);
 }

x_draw_int_node(x0,y0,i,col)
double x0,y0;
int i,col;
{ char buf[16];
  sprintf(buf,"%d",i);
  x_draw_text_node(x0,y0,buf,col);
 }

x_draw_ellipse(x0,y0,a,b,col)
double x0,y0,a,b; 
int col;
{ int A = (int)(a*x_draw_scale);
  int B = (int)(b*x_draw_scale);
  x_draw_arc(x0,y0,A,B,col); }

x_draw_filled_ellipse(x0,y0,a,b,col)
double x0,y0,a,b; 
int col;
{ int A = (int)(a*x_draw_scale);
  int B = (int)(b*x_draw_scale);
  x_draw_filled_arc(x0,y0,A,B,col); }


x_draw_circle(x0,y0,r,col)
double x0,y0,r; 
int col;
{ int R = (int)(r*x_draw_scale);
  x_draw_arc(x0,y0,R,R,col); }


x_draw_filled_circle(x0,y0,r,col)
double x0,y0,r; 
int col;
{ int R = (int)(r*x_draw_scale);
  if (R > 0)
     x_draw_filled_arc(x0,y0,R,R,col); 
  else
     x_draw_pix(x0,y0,col); 
 }


x_draw_plot_xy(x0,x1,f,col)
double x0,x1;
double (*f)();
int col;
{ 
  XPoint *points;

  int x = XPIX(x0);
  int y_old = YPIX((*f)(x0));
  int i,y_new;
  int size = 0;
  int n = 0;

  if (col != x_draw_color) x_draw_set_color(col);

  for(x = XPIX(x0)+1; x <= XPIX(x1); x++)
  { y_new = YPIX((*f)(XREAL(x)));
    if (y_new > y_old)
       size += (y_new-y_old+1);
    else
       size += (y_old-y_new+1);
    y_old = y_new;
   }

  points = (XPoint *) malloc(2*size*sizeof(short));

  y_old = YPIX((*f)(x0));

  for(x = XPIX(x0)+1; x <= XPIX(x1); x++)
  { y_new = YPIX((*f)(XREAL(x)));
    if (y_new > y_old)
      for(i=y_old; i<=y_new; i++)  
      { points[n].x = (short) x; 
        points[n].y = (short) i;
        n++;
       }
    else
      for(i=y_old; i>=y_new; i--)  
      { points[n].x = (short) x; 
        points[n].y = (short) i;
        n++;
       }
    y_old = y_new;
  }

 XDrawPoints(display,drawable,gc,points,size,CoordModeOrigin);
  
 free((char*)points);


  if (x_draw_screen_flush)
    XFlush(display);
}

x_draw_plot_yx(y0,y1,f,col)
double y0,y1;
double (*f)();
int col;
{ 
  XPoint *points;

  int y;
  int i,x_new;
  int x_old = XPIX((*f)(y0));
  int size = 0;
  int n = 0;

  if (col != x_draw_color) x_draw_set_color(col);

  for(y = YPIX(y0)-1; y >= YPIX(y1); y++)
  { x_new = XPIX((*f)(YREAL(y)));
    if (x_new > x_old)
       size += (x_new-x_old+1);
    else
       size += (x_old-x_new+1);
    x_old = x_new;
   }

  points = (XPoint *) malloc(2*size*sizeof(short));

  x_old = XPIX((*f)(y0));

  for(y = YPIX(y0)-1; y >= YPIX(y1); y--)
  {
    x_new = XPIX((*f)(YREAL(y)));
    if (x_new > x_old)
      for(i=x_old; i<=x_new; i++)  
      { points[n].x = (short) i; 
        points[n].y = (short) y;
        n++;
       }
    else
      for(i=x_old; i>=x_new; i--)  
      { points[n].x = (short) i; 
        points[n].y = (short) y;
        n++;
       }
    x_old = x_new;
  }

 XDrawPoints(display,drawable,gc,points,size,CoordModeOrigin);
  
 free((char*)points);


  if (x_draw_screen_flush)
    XFlush(display);
}


x_draw_filled_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{
 XPoint *edges;
 int i;

 edges = (XPoint *) malloc(2*n*sizeof(short));

 for(i=0;i<n;i++) 
 { edges[i].x = (short) XPIX(xcoord[i]);
   edges[i].y = (short) YPIX(ycoord[i]);
  }

  if (col != x_draw_color) x_draw_set_color(col);

 XFillPolygon(display,drawable,gc,edges,n,Convex,CoordModeOrigin);

 free((char*)edges);

  if (x_draw_screen_flush)
    XFlush(display);

 }

x_draw_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{ int i;

  for(i=0;i<n-1;i++) 
    x_draw_line(xcoord[i],ycoord[i], xcoord[i+1],ycoord[i+1],col);

  x_draw_line(xcoord[n-1],ycoord[n-1],xcoord[0],ycoord[0],col);

 }

x_draw_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2;
int col;
{
 x_draw_line(x1,y1,x1,y2,col);
 x_draw_line(x1,y2,x2,y2,col);
 x_draw_line(x2,y2,x2,y1,col);
 x_draw_line(x2,y1,x1,y1,col);

 }


x_draw_filled_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2; 
int col;
{ double xcoord[4], ycoord[4];

 xcoord[0] = x1;   
 ycoord[0] = y1;   
 xcoord[1] = x1;  
 ycoord[1] = y2;   
 xcoord[2] = x2; 
 ycoord[2] = y2;   
 xcoord[3] = x2;
 ycoord[3] = y1;

 x_draw_filled_polygon(4,xcoord,ycoord,col);

 }


x_draw_copy(x1,y1,x2,y2,buf)
double x1,y1,x2,y2;
int buf;
{
  int w = (int)((x2-x1)*x_draw_scale);
  int h = (int)((y2-y1)*x_draw_scale);

  if (w<=0 || h <=0) return;

  buffer_pixmap[buf] = XCreatePixmap(display,drawable,w,h,x_draw_depth);
  buffer_width[buf] = w;
  buffer_height[buf] = h;

  XCopyArea(display,drawable,buffer_pixmap[buf],gc, XPIX(x1),YPIX(y2),w,h,0,0);

 }


x_draw_cut(x1,y1,x2,y2,buf)
double x1,y1,x2,y2;
int buf;
{ x_draw_copy(x1,y1,x2,y2,buf);
  x_draw_filled_rectangle(x1,y1,x2,y2,0);
 }

x_draw_paste(buf,x,y)
double x,y;
int buf;
{ int w = buffer_width[buf];
  int h = buffer_height[buf];
  if(w>0 && h>0)
  XCopyArea(display,buffer_pixmap[buf],drawable,gc,0,0,w,h,XPIX(x),YPIX(y)-h);
 }


x_draw_clear_buf(i)
int i;
{ buffer_height[i] = buffer_width[i] = 0; }


/*
x_draw_copy_rect(x1,y1,x2,y2,x,y)
{ x_draw_copy(x1,y1,x2,y2,0);
  x_draw_paste(0,x,y);
 }
*/

x_draw_copy_rect(x1,y1,x2,y2,x,y)
double x1,y1,x2,y2,x,y;
{
  Pixmap P;

  int w = (int)((x2-x1)*x_draw_scale);
  int h = (int)((y2-y1)*x_draw_scale);

  int X1 = XPIX(x1);
  int Y1 = YPIX(y2);

  int X = XPIX(x);
  int Y = YPIX(y)-h;

  int save;

  P = XCreatePixmap(display,drawable,w,h,x_draw_depth);

  save  = x_draw_set_mode(0);   /* src-mode */

  XCopyArea(display,drawable,P,gc, X1,Y1,w,h,0,0);

  XCopyArea(display,P,drawable,gc,0,0,w,h,X,Y);

  x_draw_set_mode(save);

  if (x_draw_screen_flush)
    XFlush(display);
 }


x_draw_move_rect(x1,y1,x2,y2,x,y)
double x1,y1,x2,y2,x,y;
{
  Pixmap P;

  int w = (int)((x2-x1)*x_draw_scale);
  int h = (int)((y2-y1)*x_draw_scale);

  int X1 = XPIX(x1);
  int Y1 = YPIX(y2);

  int X = XPIX(x);
  int Y = YPIX(y)-h;

  int i,j;

  int save;

  P = XCreatePixmap(display,drawable,w,h,x_draw_depth);

  save  = x_draw_set_mode(0);   /* src-mode */

  XCopyArea(display,drawable,P,gc, X1,Y1,w,h,0,0);

  save  = x_draw_set_mode(1);   /* xor-mode */

  while (X1!=X || Y1!=Y)
  {
    if (X1<X) i = X1+1;
    if (X1>X) i = X1-1;
    if (Y1<Y) j = Y1+1;
    if (Y1>Y) j = Y1-1;
    
    XCopyArea(display,P,drawable,gc,0,0,w,h,i,j);
    XCopyArea(display,P,drawable,gc,0,0,w,h,X1,Y1);

    X1 = i;
    Y1 = j;
   }

  x_draw_set_mode(save);


  if (x_draw_screen_flush)
    XFlush(display);
 }



x_draw_clear(col)
int col;
{
 int i=0;
 int n = 4;
 double x,y;


 XPoint *grid_points;

 x_draw_del_messages();

 XClearWindow(display,drawable);

 n = 0;
 if (x_draw_grid_mode) /* draw grid */
 { for(x = (int)(x_draw_xmin/x_draw_grid_mode)*x_draw_grid_mode; x<=x_draw_xmax; x+=x_draw_grid_mode)
   for(y = (int)(x_draw_ymin/x_draw_grid_mode)*x_draw_grid_mode; y<=x_draw_ymax; y+=x_draw_grid_mode)
     n++;

   grid_points = (XPoint *) malloc(2*n*sizeof(short));

   for(x = (int)(x_draw_xmin/x_draw_grid_mode)*x_draw_grid_mode; x<=x_draw_xmax; x+=x_draw_grid_mode)
   for(y = (int)(x_draw_ymin/x_draw_grid_mode)*x_draw_grid_mode; y<=x_draw_ymax; y+=x_draw_grid_mode)
   { if (x*y == 0) x_draw_filled_arc(x,y,2,2,1);
     else { grid_points[i].x = (short) XPIX(x);
            grid_points[i].y = (short) YPIX(y);
            i++;
           }
    }

   XDrawPoints(display,drawable,gc,grid_points,n,CoordModeOrigin);
  }

  if (x_draw_screen_flush)
    XFlush(display);
 }


/* TEXT  */

x_draw_message(s)
char * s;
{ 
  XGCValues gc_val;
  int y;

  mesg_list[mesg_count] = (char*)malloc(strlen(s)+1);
  strcpy(mesg_list[mesg_count],s);
  mesg_count++;

  y = 30*mesg_count+15;

  x_draw_set_color(1);

  gc_val.font     = (Font)xv_get(message_font,XV_XID);
  gc_val.function = GXxor; 
  XChangeGC(display,gc,GCFont|GCFunction,&gc_val);

  XDrawString(display,drawable,gc,30,y,s,strlen(s));

  gc_val.font     = (Font)xv_get(text_font,XV_XID);
  gc_val.function = xpix_mode_op; 
  XChangeGC(display,gc,GCFont|GCFunction,&gc_val);

  if (x_draw_screen_flush)
    XFlush(display);
}

x_draw_del_messages()
{ 
  XGCValues gc_val;
  int y;
  char* s;

  x_draw_set_color(1);

  gc_val.font     = (Font)xv_get(message_font,XV_XID);
  gc_val.function = GXxor; 
  XChangeGC(display,gc,GCFont|GCFunction,&gc_val);
 
  while(mesg_count > 0)
  { s = mesg_list[mesg_count-1];
    y = 30*mesg_count+15;
    XDrawString(display,drawable,gc,30,y,s,strlen(s));
    mesg_count--;
    free(s);
   }

  gc_val.font     = (Font)xv_get(text_font,XV_XID);
  gc_val.function = xpix_mode_op; 
  XChangeGC(display,gc,GCFont|GCFunction,&gc_val);

  if (x_draw_screen_flush)
    XFlush(display);
}



x_draw_text(x,y,s,col)
double x,y;
char * s;
int col;
{ 

  DPRINT(("x_draw_text im modus %d\n",xpix_mode_op));

  if (col != x_draw_color) x_draw_set_color(col);

  if(x_draw_text_mode == 1) /* opaque */
     XDrawImageString(display,drawable,gc,XPIX(x),YPIX(y),s,strlen(s));
  else  
     XDrawString(display,drawable,gc,XPIX(x),YPIX(y),s,strlen(s));

  if (x_draw_screen_flush)
    XFlush(display);
}

x_draw_ctext(x,y,s,col)
double x,y;
char * s;
int col;
{ 
  Font_string_dims dims;

  DPRINT(("x_draw_ctext im modus %d\n",xpix_mode_op));

  if (col != x_draw_color) x_draw_set_color(col);

  xv_get(text_font,FONT_STRING_DIMS,s,&dims);
  x -= ((double)dims.width)/(2*x_draw_scale);
  y -= ((double)dims.height)/(3*x_draw_scale);

  x_draw_text(x,y,s,col);

}

x_draw_int(x0,y0,i,col)
double x0,y0;
int i,col;
{ 
  char buf[16];
  sprintf(buf,"%d",i);
  x_draw_ctext(x0,y0,buf,col);
 }


x_draw_cursor()
{ 
  int X,Y;

  X = XPIX(mouse_xreal);
  Y = YPIX(mouse_yreal);

  xv_vector(pw,X,Y,X+10,Y,PIX_SRC^PIX_DST,1);
  xv_vector(pw,X,Y,X-10,Y,PIX_SRC^PIX_DST,1);
  xv_vector(pw,X,Y,X,Y+10,PIX_SRC^PIX_DST,1);
  xv_vector(pw,X,Y,X,Y-10,PIX_SRC^PIX_DST,1);

}



int x_draw_confirm(header)
char *header;
{ /* ask for yes or no */
  char* s[2];
  s[0] = "NO";
  s[1] = "YES";
  return x_draw_read_panel(header,2,s,0);
}

int x_draw_acknowledge(header)
char *header;
{ /* ask for ok */
  char* s[1];
  s[0] = "OK";
  return x_draw_read_panel(header,1,s,0);
}

/*
int x_draw_confirm(s)
char *s;
{ 
  return x_confirm(s,0);
}

int x_draw_acknowledge(s)
char *s;
{
  return x_confirm(s,1);
}

int
x_confirm(message, ok_only)
char	*message;
int	ok_only;
{
    int		answer;
  
    if (ok_only) 
      answer = notice_prompt(frame,NULL,
                NOTICE_MESSAGE_STRINGS, message , NULL,
                NOTICE_BUTTON_YES,      "OK",
                NULL) ;
    else
      answer = notice_prompt(frame,NULL,
                NOTICE_MESSAGE_STRINGS, message , NULL,
                NOTICE_BUTTON_YES,      "YES",
                NOTICE_BUTTON_NO,       "NO",
                NULL) ;

    XFlush(display);
    return answer;
}
*/



/* notify proc */
static void panel_input_notify(item, event)
Panel_item	item;
Event		*event;
{
    xv_set(panel,PANEL_CLIENT_DATA,(int)panel_get(item, PANEL_CLIENT_DATA),0);

    notify_stop();

}

int x_draw_screen_width()
{ Rect *r;
  Frame frame = window_create(0, FRAME,NULL); 
  r = (Rect *) window_get(frame, WIN_SCREEN_RECT);
  window_destroy(frame);
  return(r->r_width);
}


int x_draw_screen_height()
{ Rect *r;
  Frame frame = window_create(0, FRAME,NULL); 
  r = (Rect *) window_get(frame, WIN_SCREEN_RECT);
  window_destroy(frame);
  return(r->r_height);
}


static void
center_frame(frame)
Frame frame;
{ Rect * r;
  int left,top,width,height;

    /* center frame on the screen */

    height = (int) window_get(frame, WIN_HEIGHT);
    width = (int) window_get(frame, WIN_WIDTH);

    left = (screen_width - width) / 2;
    top = (screen_height - height) / 2;

    if (left < 0) left = 0;
    if (top < 0) top = 0;

    window_set(frame, WIN_X, left, WIN_Y, top, 0);
}


static void 
init_panel_frame(message,num,label,vertical)
char	*message;
int     num;
char   **label;
int    vertical;
{
    Panel_item		message_item,button[64],but;
    int			i,w,left, top, panel_width[64], width, height;
    Rect		*r;
  

    panel_frame = window_create(0, FRAME,
                             FRAME_SHOW_LABEL, FALSE,
                             FRAME_NO_CONFIRM, TRUE, 
                             WIN_X, 100, WIN_Y, 100, 0);


   panel = window_create(panel_frame, PANEL, WIN_FONT, text_font, 0);



    message_item = panel_create_item(panel, PANEL_MESSAGE, 
                           PANEL_LABEL_STRING, message,
                           PANEL_LABEL_BOLD, TRUE,
                           PANEL_ITEM_X, 12,
                           PANEL_ITEM_Y, 10,
	                   0);

    r = (Rect *) panel_get(message_item, PANEL_ITEM_RECT);

    left = 12;

    height = rect_bottom(r) + 15;

    button[0] = panel_create_item(panel, PANEL_BUTTON, 
                  PANEL_ITEM_X, left, PANEL_ITEM_Y, height, 
                  PANEL_LABEL_STRING, label[0],       
                  PANEL_CLIENT_DATA, 0,
                  PANEL_NOTIFY_PROC, panel_input_notify,
                  0);

      but = panel_create_item(panel, PANEL_BUTTON, 
                    PANEL_ITEM_Y, (i+1) * height,
                    PANEL_LABEL_STRING, "0",  
                    0);

      panel_width[0] =  panel_get(but,PANEL_ITEM_X) -left -10;

      w = panel_width[0];

       
      xv_destroy(but);
      

    if (vertical)
    for(i=1;i<num;i++)
    { button[i] = panel_create_item(panel, PANEL_BUTTON, 
                  PANEL_ITEM_X, left, PANEL_ITEM_Y, (i+1) * height,
                  PANEL_LABEL_STRING, label[i],     
                  PANEL_CLIENT_DATA, i,
                  PANEL_NOTIFY_PROC, panel_input_notify,
                  0);

      but = panel_create_item(panel, PANEL_BUTTON, 
                    PANEL_ITEM_Y, (i+1) * height,
                    PANEL_LABEL_STRING, "0",  
                    0);

      panel_width[i] =  panel_get(but,PANEL_ITEM_X) -left -10;

      if (w < panel_width[i]) w = panel_width[i];

       
      xv_destroy(but);
      
     }
    else
    { for(i=1;i<num;i++)
        button[i] = panel_create_item(panel, PANEL_BUTTON, 
                    PANEL_ITEM_Y, height,
                    PANEL_LABEL_STRING, label[i],  
                    PANEL_CLIENT_DATA, i,
                    PANEL_NOTIFY_PROC, panel_input_notify,
                    0);

      but = panel_create_item(panel, PANEL_BUTTON, 
                    PANEL_ITEM_Y, height,
                    PANEL_LABEL_STRING, "0",  
                    0);

      w = panel_get(but,PANEL_ITEM_X) -left -10;

      xv_destroy(but);

      for(i=0;i<num;i++) panel_width[i] = w;

     }

   /* center buttons under the message  or vice versa */

   for(i=0;i<num;i++)
   { left = (w - panel_width[i]) / 2;  
     panel_set(button[i],PANEL_ITEM_X,panel_get(button[i],PANEL_ITEM_X)+left,0);
    }

    left = (r->r_width - w) / 2;  

    if (left < 0) 
      panel_set(message_item,PANEL_ITEM_X,12-left,0);
    else
      for(i=0;i<num;i++)
        panel_set(button[i],PANEL_ITEM_X,panel_get(button[i],PANEL_ITEM_X)+left,0);



    window_fit(panel);
    window_fit(panel_frame);

    center_frame(panel_frame);
}


int x_draw_read_panel(message,n,labels,vertical)
char	*message;
int n;
char	**labels;
int    vertical;
{
    int answer;

    if (x_draw_grid_mode) x_draw_cursor();

    /* create the panel_frame */
    init_panel_frame(message,n,labels,vertical);


    xv_main_loop(panel_frame);

    answer = (int)xv_get(panel,PANEL_CLIENT_DATA);


    /* destroy the panel_frame */
    window_destroy(panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();

    x_draw_reset_gc();

    XFlush(display);

    return answer;

}




char* x_draw_read_text_panel(message,menu_label,n,items)
char	*message;
char	*menu_label;
int      n;
char   **items;
{
    if (x_draw_grid_mode) x_draw_cursor();

    /* create the panel_frame */
    init_panel_text_frame(message,menu_label,n,items);

    xv_main_loop(panel_frame);

    /* destroy the panel_frame */
    window_destroy(panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();

    x_draw_reset_gc();

    XFlush(display);

    return text_panel_answer;

}



static Panel_item panel_text_item;

static void 
init_panel_text_frame(message,menu_label,n,items)
char	*message;
char	*menu_label;
int      n;
char  **items;
{
    
    int	   left, top, width, height;
    Rect  *r;
    int    i;
    Menu   menu;
    int    cols;


    cols =  1+ n/15;
  

    panel_frame = window_create(0, FRAME,
                             FRAME_SHOW_LABEL, FALSE,
                             FRAME_NO_CONFIRM, TRUE, 
                             WIN_X, mouse_xpix, WIN_Y, mouse_ypix, 0);


    panel = window_create(panel_frame, PANEL, WIN_FONT, text_font, 0);




    panel_text_item = panel_create_item(panel, PANEL_TEXT, 
                           PANEL_ITEM_Y, 18,
                           PANEL_NOTIFY_PROC,  panel_input_text_notify,
                           PANEL_LABEL_STRING, message,
                           PANEL_VALUE_DISPLAY_LENGTH, 20,
                           PANEL_VALUE_STORED_LENGTH, 256, 
	                   0);
    
/*
    if (n>0)
    { menu = (Menu)xv_create(NULL, MENU,
                             MENU_NCOLS, cols,
                             MENU_NOTIFY_PROC, text_panel_menu_proc,
                             0);

      for(i=0;i<n;i++) menu_set(menu,MENU_STRING_ITEM,items[i],i,0);

      (void) xv_create(panel, PANEL_BUTTON,
                              PANEL_LABEL_STRING, menu_label,
                              PANEL_ITEM_MENU,    menu, 
                              0);
     }
*/


    window_fit(panel);
    window_fit(panel_frame);

    center_frame(panel_frame);

    window_set(panel, PANEL_CARET_ITEM, panel_text_item, 0);

}


/* notify proc */

static void panel_input_text_notify(item, event)    /* pressing return */
Panel_item	item;
Event		*event;
{
    strcpy(text_panel_answer,(char*)panel_get_value(item));
    notify_stop();
}


static void text_panel_menu_proc(menu, menu_item)  /* selecting menu */
Menu menu;
Menu_item menu_item;
{
    xv_set(panel_text_item,PANEL_VALUE,xv_get(menu_item, MENU_STRING),0);
    strcpy(text_panel_answer,xv_get(menu_item, MENU_STRING));
    notify_stop();
}





void x_draw_notice(mesg)
char* mesg;
{
    notice_prompt(frame, NULL,
        NOTICE_FOCUS_XY,        500,200,
        NOTICE_MESSAGE_STRINGS, mesg, NULL,
        NOTICE_BUTTON_YES,      "OK",
        NULL);
}

static done_proc(subframe)
Frame subframe;
{ xv_set(subframe,XV_SHOW,FALSE,0);
  notify_stop();
 }

x_draw_message_panel(argc, argv)
char *argv[];
{   int max_len,i,left, top, width, height;
    Rect		*r;
    Panel_item but;

    if (x_draw_grid_mode) x_draw_cursor();

    panel_frame = (Frame)xv_create(NULL, FRAME, 
                                   FRAME_LABEL, argv[0], 
                                   WIN_X, 10,
                                   WIN_Y, 10,
                                   NULL);


/*

    panel_frame = (Frame)xv_create(frame, FRAME_CMD,
                                         WIN_X, 10,
                                         WIN_Y, 10,
                                         WIN_WIDTH, 10,
                                         WIN_HEIGHT, 10,
                                         FRAME_CMD_PUSHPIN_IN, TRUE,
                                         FRAME_LABEL, argv[0],
                                         FRAME_DONE_PROC, done_proc,
                                         NULL);
*/

    panel = window_create(panel_frame, PANEL, 
                                       PANEL_LAYOUT, PANEL_VERTICAL,
                                       WIN_FONT, text_font, 0);

    if (argc > 1)
    { xv_create(panel, PANEL_MESSAGE, 
                PANEL_ITEM_Y, 10,
                PANEL_ITEM_X, 25,
                PANEL_LABEL_BOLD, TRUE, 
                PANEL_LABEL_STRING, argv[1],
                NULL);
      max_len = strlen(argv[1]);
     }

    for(i = 2; i< argc; i++)
    { if (max_len < strlen(argv[i])) 
          max_len = strlen(argv[i]);
      xv_create(panel, PANEL_MESSAGE, 
                PANEL_ITEM_X, 25,
                PANEL_LABEL_BOLD, TRUE, 
                PANEL_LABEL_STRING, argv[i],
                NULL);
     }

    but = xv_create(panel, PANEL_BUTTON,
                PANEL_LABEL_STRING, "OK",
                PANEL_CLIENT_DATA, 0,
                PANEL_NOTIFY_PROC, panel_input_notify,
                NULL);


    window_fit(panel);
    window_fit(panel_frame);

    width = xv_get(panel_frame,WIN_WIDTH);
    panel_set(but,PANEL_ITEM_X,width/2 - 15,0);


    center_frame(panel_frame);

    xv_main_loop(panel_frame);

    window_destroy(panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();
}
