/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _win_input.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/window.h>
#include <LEDA/stream.h>
#include <math.h>

#include "x_draw.h"


//------------------------------------------------------------------------------
// INPUT
//------------------------------------------------------------------------------

int  window::confirm(string s)     { return x_draw_confirm(~s); }
void window::acknowledge(string s) { x_draw_acknowledge(~s); }


int window::get_button() { return x_draw_get_button(); }

int window::read_mouse()
{ double X,Y;
  return x_read_mouse(0,0.0,0.0,&X,&Y);
}


int  window::read_mouse(double& x, double& y)
{ return x_read_mouse(0,0.0,0.0,&x,&y); }

int  window::read_mouse(point& q)
{ double X,Y;
  int key = x_read_mouse(0,0.0,0.0,&X,&Y);
  q = point(X,Y);
  return key;
}



int  window::read_mouse_seg(double x0, double y0, double& x, double& y)
{ return x_read_mouse(1,x0,y0,&x,&y); }

int  window::read_mouse_seg(point p, point& q)
{ double X,Y;
  int key = x_read_mouse(1,p.xcoord(),p.ycoord(),&X,&Y);
  q = point(X,Y);
  return key;
}


int  window::read_mouse_rect(double x0, double y0, double& x, double& y)
{ return x_read_mouse(2,x0,y0,&x,&y); }


int  window::read_mouse_rect(point p, point& q)
{ double X,Y;
  int key = x_read_mouse(2,p.xcoord(),p.ycoord(),&X,&Y);
  q = point(X,Y);
  return key;
}


int  window::read_mouse_circle(double x0, double y0, double& x, double& y)
{ return x_read_mouse(3,x0,y0,&x,&y); }


int  window::read_mouse_circle(point p, point& q)
{ double X,Y;
  int key = x_read_mouse(3,p.xcoord(),p.ycoord(),&X,&Y);
  q = point(X,Y);
  return key;
}



int window::read_mouse_action(mouse_action_func_ptr f, double& x, double& y)
{ return x_read_mouse_action(f,0.0,0.0,&x,&y); }


int window::read_mouse_action(mouse_action_func_ptr f, point& q)
{ double X,Y;
  int key = x_read_mouse_action(f,0.0,0.0,&X,&Y);
  q = point(X,Y);
  return key;
}



window& window::read(point& p)
{ double x,y;
  state = 1;
  int k;
  while ((k = read_mouse(x,y)) != 1) 
   if (k == 3) 
    { state = 0;
      return *this;
     }
  p = point(x,y);
  return *this;
 }


window& window::read(segment& s)
{ double x,y;
  point p;
  int key = 0;
  state = 1;

  if (!read(p)) 
   return *this;

  while ((key=read_mouse_seg(p.xcoord(),p.ycoord(),x,y)) != 1)
  { if (key== 3)  
     { state = 0;
       break; 
      }

    if (key==-1)
      if (!read(p)) break;
   }

   if (state) s = segment(p.xcoord(),p.ycoord(),x,y);

  return *this;
}



window& window::operator>>(point& p)    
{ x_draw_set_frame_label(">> POINT");
  read(p); 
  x_draw_reset_frame_label();
  return *this; 
 }

window& window::operator>>(segment& s)  
{ x_draw_set_frame_label(">> SEGMENT");
  read(s); 
  x_draw_reset_frame_label();
  return *this; 
 }




int  window::read_panel(string header, int n, string* L)
{ char** p = new char*[n];
  for(int i = 0; i < n; i++) p[i] = ~L[i];
  return x_draw_read_panel(~header,n,p,0);
 }


int  window::read_vpanel(string header, int n, string* L)
{ char** p = new char*[n];
  for(int i = 0; i < n; i++) p[i] = ~L[i];
  return x_draw_read_panel(~header,n,p,1);
 }



string  window::read_string(string header)
{ return x_draw_read_text_panel(~header,0,0,0); }

int  window::read_int(string s)
{ string_istream in(x_draw_read_text_panel(~s,0,0,0));
  int res;
  in >> res;
  return res;
 }

double  window::read_real(string s)
{ string_istream in(x_draw_read_text_panel(~s,0,0,0));
  double res;
  in >> res;
  return res;
 }


#ifndef __TURBOC__

window& window::read(line& l)
{ segment s;
  state = 1;
  read(s);
  if (state) l = line(s);
  return *this;
 }


window& window::read(circle& c)
{ double x,y;
  point p;
  int key = 0;
  state = 1;

  if (!read(p)) 
   return *this;

  drawing_mode save = set_mode(xor_mode);
  draw(p);

  while ((key=read_mouse_circle(p.xcoord(),p.ycoord(),x,y)) != 1)
  { if (key== 3)  
     { state = 0;
       break; 
      }

    if (key==-1)
    { draw(p);
      if (!read(p)) break;
      draw(p);
     }
   }
   if (state) 
   { double dx = x-p.xcoord();
     double dy = y-p.ycoord();
     c = circle(p,hypot(dx,dy));
     draw(p);
    }

  set_mode(save);
  return *this;
}

window& window::read(polygon& P)
{ double x,y;
  int key = 0;
  state = 1;
  point first,last,p;
  list(point) pl;

  if (!read(first)) return *this;

  pl.append(first);

  p = first;

  drawing_mode save = set_mode(xor_mode);

  while ((key = read_mouse_seg(p.xcoord(),p.ycoord(),x,y)) !=2)
  { 
    if (key==3) break;

    if (key==-1 && (pl.length() > 1 )) 
    { point l = pl.Pop();
      draw_segment(pl.tail(),l);
      p = pl.tail();
     }

    if (key==1)
    { point q(x,y);
      draw_segment(p,q);
      pl.append(q);
      p = q;
     }
  }


  draw_segment(first,p);

  list_item it;
  forall_items(it,pl) draw_segment(pl[it],pl[pl.cyclic_succ(it)]);


  P = polygon(pl);

  if (key==3)
  { state = 0;
    Clear(P);
    Init(P);
   }

  set_mode(save);

  return *this;

}


window& window::operator>>(line& l)     
{ x_draw_set_frame_label(">> LINE");
  read(l); 
  x_draw_reset_frame_label();
  return *this; 
 }

window& window::operator>>(circle& C)   
{ x_draw_set_frame_label(">> CIRCLE");
  read(C); 
  x_draw_reset_frame_label();
  return *this; 
 }

window& window::operator>>(polygon& P)  
{ x_draw_set_frame_label(">>POLYGON");
  read(P); 
  x_draw_reset_frame_label();
  return *this; 
 }

#endif
