/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _spanning.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



/*******************************************************************************
*                                                                              *
*  SPANNING_TREE  (spanning tree)                                              *
*                                                                              *
*******************************************************************************/



#include <LEDA/graph_alg.h>

#include <LEDA/node_partition.h>


list(edge) SPANNING_TREE(const graph& G)
{ node v,w;
  edge e;
  list(edge) EL;
  node_partition P(G);

  forall_edges(e,G)
     { v = source(e);
       w = target(e);
       if (! P.same_block(v,w))
        { EL.append(e);
          P.union_blocks(v,w);
         }
      }

  return EL;
}


/*******************************************************************************
*                                                                              *
*  LEDA 1.0    (graph algorithms)                                              *
*                                                                              *
*  MIN_SPANNING_TREE   (minimum spanning tree)                                 *
*                                                                              *
*******************************************************************************/

static edge_array(int) edge_cost;

static int CMP_EDGES(edge& e1, edge& e2) 
{ return (edge_cost[e1] - edge_cost[e2]); }

list(edge) MIN_SPANNING_TREE(const graph& G, const edge_array(int)& cost)
{ node v,w;
  edge e;
  list(edge) EL;
  node_partition P(G);

  list(edge) OEL = G.all_edges();

  edge_cost = cost;

  OEL.sort(CMP_EDGES);

  forall(e,OEL)
     { v = source(e);
       w = target(e);
       if (! P.same_block(v,w))
        { EL.append(e);
          P.union_blocks(v,w);
         }
      }

  return EL;
}




#ifndef __TURBOC__


static edge_array(double) edge_cost1;

static int CMP_EDGES1(edge& e1, edge& e2) 
{ return (edge_cost[e1] - edge_cost[e2]); }

list(edge) MIN_SPANNING_TREE(const graph& G, const edge_array(double)& cost)
{ node v,w;
  edge e;
  list(edge) EL;
  node_partition P(G);

  list(edge) OEL = G.all_edges();

  edge_cost1 = cost;

  OEL.sort(CMP_EDGES1);

  forall(e,OEL)
     { v = source(e);
       w = target(e);
       if (! P.same_block(v,w))
        { EL.append(e);
          P.union_blocks(v,w);
         }
      }

  return EL;
}


#endif
