#include <LEDA/point_set.h>
#include <LEDA/plane.h>
#include <LEDA/window.h>

declare(point_set,string)

void draw_polygon(window& W, point_set(string)& S, list(ps_item)& P)
{ list_item it;
  forall_items(it,P)
  { point p =  S.key(P[it]);
    point q =  S.key(P[P.cyclic_succ(it)]);
    W.draw_segment(p,q);
   }
 }

void main()
{

  window W;


  W.set_node_width(5);
  W.set_line_width(2);
  W.set_mode(xor_mode);

  panel P("POINT SET");

  P.text_item("Use the left mouse button to insert points. If a shift ");
  P.text_item("key is pressed simultaneously the nearest neighbor of  ");
  P.text_item("the current mouse position is computed and displayed.  ");
  P.text_item("An iso-oriented query rectangle can by defined using   ");
  P.text_item("the middle button twice. An orthogonal range query is  ");
  P.text_item("performed and all points lying inside the rectangle    ");
  P.text_item("are deleted. Click the right button to quit.           ");

  P.button("continue");

  P.open();


  W.clear();

  point_set(string) S;

  double          x,y,x1,y1;
  int           button=0;
  ps_item       nearest_it=nil;
  point         p; 
  list(ps_item) Pol;



  while (button !=3 )
  {  
     button =  W.read_mouse(x,y);

     // delete arrow to nearest neighbor or polygon

     if (nearest_it!=nil) 
      { W.draw_edge_arrow(p,S.key(nearest_it));
        nearest_it = nil;
       }

     if (!Pol.empty()) 
     { draw_polygon(W,S,Pol); 
       Pol.clear();
      }

     p = point(x,y);

     switch(button) {

     case 1: { string s("point (%f,%f)",p.xcoord(),p.ycoord());
               S.insert(p,s);
               W.draw_filled_node(p);
               break;
              }


     case 2: { W.read_mouse_rect(x,y,x1,y1);
               list(ps_item) L = S.range_search(x,x1,y,y1);
               ps_item it;
               forall(it,L) 
               { cout << "delete " << S.inf(it) << "\n";
                 W.draw_filled_node(S.key(it));
                 S.del_item(it);
                }
               cout.flush();
               break;
              }

     case -1:  { nearest_it = S.nearest_neighbor(p);
                 if (nearest_it!=nil) 
                  { W.draw_edge_arrow(p,S.key(nearest_it));
                    cout << "Nearest " << S.inf(nearest_it) << "\n";
                   }
                 else cout << "Empty point set.\n";	
                 cout.flush();
                 break;
                }

     case -2:  { Pol = S.convex_hull();
                 draw_polygon(W,S,Pol);
                 break;
                }

     } //switch


} //for

}
