/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  subdivision.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef SUBDIVISIONH
#define SUBDIVISIONH

#include <LEDA/point.h>
#include <LEDA/planar_map.h>

static point name2(point,X);

class SubDivision : public planar_map
{
  face outer_face;

  void* strip_ptr;   //pointer to strip_list
  
public:
  
  SubDivision(const graph&);

 ~SubDivision();

  point  position(node v)    const { return ACCESS(point,inf(v)); }
  
  face   locate_point(point) const;

  void   print_stripes() const;
  
};


//------------------------------------------------------------------------------
//
// subdivision(ftype): generic subdivisions with face entries of type "ftype"
//
// Type GRAPH(point,ftype) must be declared  before 
//
//------------------------------------------------------------------------------

#define subdivision(ftype)   name2(ftype,subdivision)

#define subdivisiondeclare(ftype)\
\
class subdivision(ftype) : public SubDivision {\
\
ftype name2(ftype,X);\
\
void copy_face_entry(GenPtr& x)  const { x=Copy(ACCESS(ftype,x)); }\
void clear_face_entry(GenPtr& x) const { Clear(ACCESS(ftype,x));  }\
\
public:\
\
   ftype  inf(face f)         const {return ACCESS(ftype,SubDivision::inf(f));}\
   point  operator[](node v)  const {return ACCESS(point,SubDivision::inf(v));}\
   ftype  operator[](face f)  const {return ACCESS(ftype,SubDivision::inf(f));}\
\
void print_node(node v) const { cout << "[" << index(v) <<"] (";\
                                Print(position(v));\
                                cout << ") ";}\
\
   subdivision(ftype)(GRAPH(point,ftype)& G) : SubDivision((graph&)G)   {}\
  ~subdivision(ftype)()     {}\
\
};

#endif SUBDIVISIONH
