/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  point.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef POINTH
#define POINTH

#include <LEDA/list.h>
#include <LEDA/vector.h>

class point;
class segment;

//------------------------------------------------------------------------------
// points
//------------------------------------------------------------------------------

struct point_rep  {
   
   double x;
   double y;
   int  count;
    
   point_rep();     
   point_rep(double a, double b);
   
   
    LEDA_MEMORY(point_rep)
   
};


class point  : public LEDA_SIMPLE 
{

friend class segment;
friend class line;
friend class circle;



/* point_rep* ptr(); */

point_rep* ptr() const { return (point_rep*)PTR; }

public:

point();
point(double, double);
point(vector);
point(const point&);
void clear();

~point()                  { clear(); }

/*  cfront3.0 bug ???
operator vector()         { return vector(ptr()->x,ptr()->y); }
*/

double  xcoord()  const   { return ptr()->x; }
double  ycoord()  const   { return ptr()->y; }

double  angle(point,point);

double  distance(point);
double  distance();

point   translate(double,double);
point   translate(const vector&);

point   rotate(point,double);
point   rotate(double);

point& operator=(const point& p);

point operator+(vector& v) { return translate(v); }

int operator==(const point&);

int operator!=(const point& p) { return !operator==(p);}

friend ostream& operator<<(ostream& out, const point& p) ;
friend istream& operator>>(istream& in, point& p) ;

friend void Print(const point& p, ostream& out = cout) { out << p; } 
friend void Read(point& p,  istream& in = cin)   { in >> p; }

friend void   Clear(point& p) { p.clear(); }
friend GenPtr Copy(point& p)  { p.ptr()->count++; return p.PTR; }
friend point& Access(const point&, const GenPtr& p) { return *(point*)&p; }

friend int compare(const point&, const point&);

};

declare(list,point)


//------------------------------------------------------------------------------
// POINT(cmp): points with user defined linear order cmp
//------------------------------------------------------------------------------

#define POINT(cmp) name2(point_,cmp)

#define POINTdeclare(cmp)\
struct POINT(cmp) : public point \
{  POINT(cmp)(point  p )           : point(p)   {}\
   POINT(cmp)(POINT(cmp)& p)       : point(p)   {}\
   POINT(cmp)() {}\
 ~ POINT(cmp)() {}\
};\
\
int compare(const POINT(cmp)& x, const POINT(cmp)& y) { return cmp(x,y); }

#endif

