/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  f_heap.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef FHEAP_H
#define FHEAP_H

//------------------------------------------------------------------------------
//
// Fibonacci Heap
//
// Michael Muth  (1988)
//
// Modifications
//
// - virtual compare function  (Stefan Naeher, August 1989)
//
// - virtual clear functions   (Stefan Naeher, April 1990)
//
//------------------------------------------------------------------------------


#include <LEDA/basic.h>


class f_heap_node  {
// repraesentiert Knoten und Heap geordnete Baeume

friend class f_heap;

   f_heap_node* next;          // used to link all used items 
   int deleted;                // to mark deleted nodes

   f_heap_node* left;          // left and right siblings (circular List)
   f_heap_node* right;   
   f_heap_node* parent;        // parent node
   f_heap_node* children;      // a child

   int rank;                   // number of children
   int mark;                   // ( 1=true, 0=false )
   GenPtr key;                    // key
   GenPtr inf;                    // information


// size: 9 words =  36 bytes


   void link(f_heap_node*);
   void cut(f_heap_node*);


public:

   f_heap_node(GenPtr k, GenPtr info, f_heap_node* n) 
   {  key = k;
      inf = info;
      next = n;
      deleted = 0;
      rank = 0;
      mark = 0;
      parent = 0;
      children = 0;
    }  // end of f_heap_node()

  LEDA_MEMORY(f_heap_node)

 };  //f_heap_node


typedef f_heap_node* f_heap_item;


class f_heap
 /* Ein F-Heap enthaelt eine zirkulaere Liste von Heap geordneten
    Baeumen. Der Einstieg erfolgt ueber den minptr, einen Zeiger
    auf den Baum mit kleinstem Schluessel in der Wurzel. Die ei-
    gentlichen Items ( Paare aus /NxT ) sind in den Knoten der
    Baeume enthalten.                                               */
 { 
   int node_count;         // number of nodes
   f_heap_node* minptr;    // entry to the List of roots
   f_heap_node* node_list; // List of all nodes

   f_heap_node** rank_field;

   int max_rank() const;

   f_heap_node* new_f_heap_node(GenPtr k, GenPtr i)
   { return (node_list = new f_heap_node(k,i,node_list)); }

   virtual int cmp(GenPtr x, GenPtr y) const { return int(x)-int(y); }

   virtual void print_key(GenPtr&)  const {}
   virtual void print_inf(GenPtr&)  const {}

   virtual void clear_key(GenPtr&)  const {}
   virtual void clear_inf(GenPtr&)  const {}

   virtual void copy_key(GenPtr&)   const {}
   virtual void copy_inf(GenPtr&)   const {}

public:

 f_heap();
 f_heap(const f_heap&);
 f_heap& operator=(const f_heap&);
~f_heap()  { clear(); delete rank_field; }


f_heap_node* insert(GenPtr, GenPtr);
f_heap_node* find_min() const { return(minptr); }

void del_min();  
void decrease_key(f_heap_node*,GenPtr);
void change_inf(f_heap_node*,GenPtr);
void del_item(f_heap_node *x){ decrease_key(x,minptr->key); del_min();}
void clear();

GenPtr  key(f_heap_node *x) const { return x->key ; }
GenPtr  inf(f_heap_node *x) const { return x->inf; }

  
int  size()  const { return node_count; }
int  empty() const { return (find_min()==0) ? true : false; }


// Iteration:
f_heap_node* first_item() const;
f_heap_node* next_item(f_heap_node*) const;


 };  // end of class f_heap

#endif
