/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  dictionary1.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef DICTIONARY_H
#define DICTIONARY_H


#include <LEDA/basic.h>
#include <LEDA/rb_tree.h>

#define DEFAULT rb_tree

typedef ITEM(rb_tree) dic_item;

#define dictionary(keytype,inftype) name3(keytype,inftype,dictionary)

#define dictionarydeclare2(keytype,inftype)\
\
class dictionary(keytype,inftype) : public DEFAULT {\
\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
int  int_type() const { return 0; }\
\
virtual int  cmp(GenPtr x, GenPtr y) const\
                     { return compare(ACCESS1(keytype,x),ACCESS1(keytype,y)); }\
virtual void clear_key(GenPtr& x)   const { Clear(ACCESS1(keytype,x)); }\
virtual void clear_inf(GenPtr& x)   const { Clear(ACCESS2(inftype,x)); }\
virtual void copy_key(GenPtr& x)    const { x=Copy(ACCESS1(keytype,x)); }\
virtual void copy_inf(GenPtr& x)    const { x=Copy(ACCESS2(inftype,x)); }\
\
public:\
\
virtual dic_item lookup(keytype x)  const{ return DEFAULT::lookup(Convert(x));}\
virtual int      defined(keytype x) const{ return (lookup(x)) ? false:true; }\
virtual void     change_inf(dic_item it, inftype i)\
                            { DEFAULT::change_inf(it,Convert(i)); }\
virtual dic_item insert(keytype x,inftype y)\
                            { return DEFAULT::insert(Convert(x),Convert(y)); } \
\
virtual void     del(keytype x)          { DEFAULT::del(Convert(x)); } \
virtual void     del_item(dic_item it)   { DEFAULT::del_item(it); } \
virtual keytype  key(dic_item it)  const { return ACCESS1(keytype,DEFAULT::key(it));  }\
virtual inftype inf(dic_item it)   const { return ACCESS2(inftype,DEFAULT::inf(it));}\
virtual inftype access(keytype k)  const { return inf(lookup(k));}\
\
virtual int      size()  const { return DEFAULT::size(); }\
virtual bool     empty() const { return (size()==0) ? true : false; }\
virtual dic_item first_item() const { return DEFAULT::first_item(); }\
virtual dic_item next_item(dic_item it) const { return DEFAULT::next_item(it); }\
\
virtual dictionary(keytype,inftype)& operator=(const dictionary(keytype,inftype)& D)\
{ return (dictionary(keytype,inftype)&)DEFAULT::operator=(/*(DEFAULT&) */D); }\
\
 dictionary(keytype,inftype)()   {}\
 dictionary(keytype,inftype)(const dictionary(keytype,inftype)& D) :\
  DEFAULT(/*(DEFAULT&) */D)   {}\
~dictionary(keytype,inftype)()   { DEFAULT::clear(); }\
};


 

#define DICTIONARY(ktype,itype,impl) name4(itype,ktype,impl,dictionary)


#define DICTIONARYdeclare3(keytype,inftype,impl)\
\
class DICTIONARY(keytype,inftype,impl) : public dictionary(keytype,inftype),\
                                          public impl {\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
int  int_type() const { return 0; }\
\
int  cmp(GenPtr x, GenPtr y) const\
                     { return compare(ACCESS1(keytype,x),ACCESS1(keytype,y)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(keytype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(inftype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS1(keytype,x)); }\
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS2(inftype,x)); }\
\
public:\
\
dic_item  lookup(keytype x)  const { return dic_item(impl::lookup(Convert(x))); }\
int       defined(keytype x) const { return (lookup(x)==nil) ? false : true; }\
\
void      change_inf(dic_item it, inftype i)\
                      { impl::change_inf(ITEM(impl)(it),Convert(i));}\
\
dic_item  insert(keytype x,inftype y)\
                      { return dic_item(impl::insert(Convert(x),Convert(y))); }\
\
void     del(keytype x)          { impl::del(Convert(x)); } \
void     del_item(dic_item it)   { impl::del_item(ITEM(impl)(it)); } \
keytype  key(dic_item it)  const { return ACCESS1(keytype,impl::key(ITEM(impl)(it)));  }\
inftype  inf(dic_item it)  const { return ACCESS2(inftype,impl::inf(ITEM(impl)(it)));}\
\
int   size()  const { return impl::size(); }\
bool  empty() const { return (size()==0) ? true : false; }\
dic_item first_item() const { return dic_item(impl::first_item()); }\
dic_item next_item(dic_item it) const { return dic_item(impl::next_item(ITEM(impl)(it))); }\
\
dictionary(keytype,inftype)& operator =(const dictionary(keytype,inftype)& D)\
{ return (DICTIONARY(keytype,inftype,impl)&)impl::operator=(*(impl*)&D); }\
\
 DICTIONARY(keytype,inftype,impl)()   {}\
\
 DICTIONARY(keytype,inftype,impl)(const DICTIONARY(keytype,inftype,impl)& D):\
  impl(*(impl*)&D)   {}\
~DICTIONARY(keytype,inftype,impl)()   { impl::clear(); }\
};

// ----------------------------------------------------------------
// iteration
// ----------------------------------------------------------------

#define forall_dic_items(i,D) for(i = (D).first_item(); i; i=(D).next_item(i))

#endif
