: run this script through /bin/sh
##############################################################
#
#  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
#  Otakaari 7 B
#  02150 Espoo
#  FINLAND
#
#  CVOPS Source Code Control System, 12.7.89
#
#  Name:	/files/dvops/util/SCCS/s.make-lib.sh
#  Version:	1.1
#  Time:	89/11/09, 11:28:17
#
##############################################################

# borrowed from ISODE -jfr.

M=BSD42 L= O= S= Q=

for A in $*
do
    case $A in
	-bsd42)
		M=BSD42
		;;

	-sys5)	M=SYS5
		;;

	-aix)	M=AIX
		;;

	-ros)	M=ROS
		;;

	-ranlib)
		case $M in
		    BSD42|ROS)
			    echo ranlib "$L"
			    ranlib "$L"
			    ;;

		    SYS5|AIX|old)
			    ;;

		    *)	    echo "make-lib: mode botch" 1>&2
			    exit 1
		esac
		exit 0
		;;

	-quick)	Q=T
		;;

	-*)	S="$S`echo $A | sed -e s%-%%`"
		;;

	*)	if [ "x$L" = x ]; then
		    L="$A"
		else
		    O="$O $A"
		fi
		;;
    esac
done

case $M in
    BSD42|ROS)
	    echo ar q"$S" "$L" $O
	    ar q"$S" "$L" $O
	    if [ "x$Q" != xT ]; then
		echo ranlib "$L"
		ranlib "$L"
	    fi
	    ;;

    SYS5)   echo ar q"$S" "$L" $O
	    ar q"$S" "$L" $O
	    ;;

    AIX)    echo ar rlv"$S" "$L" \`lorder $O \| tsort\`
	    ar rlv"$S" "$L" `lorder $O | tsort`
	    ;;

    old)    echo ar r"$S" "$L" \`lorder $O \| tsort\`
	    ar r"$S" "$L" `lorder $O | tsort`
	    ;;

    *)	    echo "make-lib: mode botch" 1>&2
	    exit 1
	    ;;
esac

exit 0
